/* USER CODE BEGIN Header */
/* you can remove the copyright */
/*
 * Copyright 2020-2025 Yuntu Microelectronics Co., Ltd.
 * All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 * 
 * @file main.c
 * @brief 
 * 
 */

/* USER CODE END Header */
#include "sdk_project_config.h"
/* Includes ------------------------------------------------------------------*/

/* Private includes ----------------------------------------------------------*/
/* USER CODE BEGIN Includes */
#include "uds.h"
#include "lin_core.h"
#include "lin_tp.h"
#include "Uds_Service.h"


/* USER CODE END Includes */

/* Private typedef -----------------------------------------------------------*/
/* USER CODE BEGIN PTD */
/* USER CODE END PTD */

/* Private define ------------------------------------------------------------*/
/* USER CODE BEGIN PD */
#define INST_LPTMR 0

#define TIMER_COMPARE_VAL (uint16_t)(20000U)
#define TIMER_TICKS_1US (uint16_t)(40U)
/* USER CODE END PD */

/* Private macro -------------------------------------------------------------*/
/* USER CODE BEGIN PM */
/* USER CODE END PM */

/* Private variables ---------------------------------------------------------*/
/* USER CODE BEGIN PV */
uint16_t timerOverflowInterruptCount = 0U;
/* USER CODE END PV */

/* Private function declare --------------------------------------------------*/
/* USER CODE BEGIN PFDC */
/* USER CODE END PFDC */
static void Board_Init(void);

/* Private user code ---------------------------------------------------------*/
/* USER CODE BEGIN 0 */
uint32_t linTimerGetTimeIntervalCallback(uint32_t *ns)                         
{
    static uint32_t previousCountValue = 0UL;
    uint32_t counterValue;

    counterValue = lpTMR_DRV_GetCounterValueByCount(INST_LPTMR);
    *ns = ((uint32_t)(counterValue + timerOverflowInterruptCount * TIMER_COMPARE_VAL - previousCountValue)) * 1000U /
          TIMER_TICKS_1US;
    timerOverflowInterruptCount = 0UL;
    previousCountValue = counterValue;

    return 0UL;
}
l_u8 ld_read_by_id_callout (l_ifc_handle inst,l_u8 id,l_u8* data){
    return LD_NEGATIVE_RESPONSE;
}
/* USER CODE END 0 */


/**
 * @brief  The application entry point.
 * @retval int
 */
int main(void)
{
    /* USER CODE BEGIN 1 */
    RCU->RSSR = 0x1;
    /* USER CODE END 1 */ 
    Board_Init();
    /* USER CODE BEGIN 2 */
    l_sys_init();
    l_ifc_init(0);
    ld_init(0);
    Uds_Init();

    INT_SYS_EnableIRQ(lpTMR0_IRQn);
    lpTMR_DRV_StartCounter(INST_LPTMR);
    pTMR_DRV_StartTimerChannels(0, 0);
    /* USER CODE END 2 */

    /* Infinite loop */
    /* USER CODE BEGIN WHILE */
    while (1)
    {
        /* USER CODE END WHILE */
        /* USER CODE BEGIN 3 */
        Uds_MainFunction();
    }
    /* USER CODE END 3 */
}

static void Board_Init(void)
{
    CLOCK_SYS_Init(g_clockManConfigsArr,CLOCK_MANAGER_CONFIG_CNT,g_clockManCallbacksArr,CLOCK_MANAGER_CALLBACK_CNT);
    CLOCK_SYS_UpdateConfiguration(CLOCK_MANAGER_ACTIVE_INDEX,CLOCK_MANAGER_POLICY_AGREEMENT);
    PINS_DRV_Init(NUM_OF_CONFIGURED_PINS0,g_pin_mux_InitConfigArr0);
    lpTMR_DRV_Init(0,&LPTMR_Config,false);
    pTMR_DRV_Init(0,&PTMR_Config);
    LIN_DRV_Init(0,&lin_config0,&lin_config0_State);
    INT_SYS_ConfigInit();
}

/* USER CODE BEGIN 4 */
uint32_t ECU_m_num_SysTick;
void lpTMR0_IRQHandler(void)
{
    Uds_TimeService(1);
    lpTMR_DRV_ClearCompareFlag(0);
    // Boot_TimeService();
    ECU_m_num_SysTick++;
    if (ECU_m_num_SysTick % 1000 ==0)
    {
        PINS_DRV_TogglePins(GPIOD, 1 << 7);
    }
}

void pTMR0_IRQHandler()
{
    pTMR_DRV_ClearInterruptFlagTimerChannels(0,0);
    lin_timeout_handle(0);
}
/* USER CODE END 4 */
