#include "Can.h"
#include "Can_Drv.h"
#include "Platform_Types.h"


/**
 * @brief 更改指定Hrh的过滤器，需要在初始化前调用
 * 
 * @param Hrh Hardware receive handler id.
 * @param FilterCode filter code
 * @param MaskCode mask code
 */
void Can_ChangeFilter(uint8 Hrh, uint32 FilterCode, uint32 MaskCode);

/**
 * @brief 更改指定Hrh的过滤器指针，需要在初始化前调用
 * 
 * @param Hrh Hardware receive handler id.
 * @param ptr 指针
 */
void Can_ChangeFilterPtr(uint8 Hrh, Can_FilterOfMbType* ptr);
