#include "Can.h"
#include "Can_Drv.h"
#include "Can_ExtraConfig.h"

#include "Can_PbCfg.h"
CAN_CONFIG_PB


/**
 * @brief 一个邮箱的过滤器配置，需要更改哪一个的就修改哪一个的
 */
Can_FilterOfMbType Can_ExtraConfig_0[1] =
{
    {
        .FilterCode = 0x7FFU,
        .MaskCode   = 0x7FFU,
    }
};


void Can_ChangeFilter(uint8 Hrh, uint32 FilterCode, uint32 MaskCode)
{
    Can_Config.CanHohCfgPtr[Hrh].FilterConfig[0].FilterCode = FilterCode;
    Can_Config.CanHohCfgPtr[Hrh].FilterConfig[0].FilterCode = MaskCode;
}

/**
 * @brief 更改指定Hrh的过滤器指针，需要在初始化前调用
 * 
 * @param Hrh Hardware receive handler id.
 * @param ptr 指针
 */
void Can_ChangeFilterPtr(uint8 Hrh, Can_FilterOfMbType* ptr)
{
    Can_Config.CanHohCfgPtr[Hrh].FilterConfig = ptr;
}
