# CAN Example Code

## Project Name: Can_Demo

---

## Function Description

This example uses four channels. The relationship between logical channels and physical channels is as follows:

| Channel Name | CanHwChannel |   FIFO   |
| :----------: | :----------: | :------: |
|     CAN0     |  FLEXCAN_0   | Enhanced |
|     CAN1     |  FLEXCAN_1   | Enhanced |
|     CAN2     |  FLEXCAN_6   |  Legacy  |
|     CAN3     |  FLEXCAN_7   |  Legacy  |

> The logical channel names used in this example correspond to the silk screen on the EVB board.

This example includes four demonstration stages:

* **CAN1_TX_CAN0**: Can_Demo uses CAN1 to send messages to CAN0
* **CAN0_TX_CAN1**: Can_Demo uses CAN0 to send messages to CAN1
* **CAN3_TX_CAN2**: Can_Demo uses CAN3 to send messages to CAN2
* **CAN2_TX_CAN3**: Can_Demo uses CAN2 to send messages to CAN3

### CAN1_TX_CAN0

This stage demonstrates the following:

* Receive **CANFD** **standard** ID using **mailbox** with **interrupt** for `0x101`
* Receive **CANFD** **extended** ID using **mailbox** with **interrupt** for `0x00000102`
* Receive **CAN2.0** **standard** ID using **mailbox** with **polling** for `0x103`
* Receive **CAN2.0** **extended** ID using **mailbox** with **polling** for `0x0000104`
* Use **Enhanced FIFO** and configure **standard** ID filters with three filtering modes from `0x105` to `0x10A`

In this stage, the source code will send CAN messages in the following ID order:

`0x101`, `0x00000102`, `0x103`, `0x00000104`, `0x105`, `0x106`, `0x107`, `0x108`, `0x109`, `0x10A`

The actual message order on the CAN bus will be:

`0x101`, `0x00000102`, `0x00000104`, `0x103`, `0x105`, `0x106`, `0x107`, `0x108`, `0x109`, `0x10A`

The callback function will consider the received ID order as:

`0x101`, `0x00000102`, `0x00000104`, `0x105`, `0x106`, `0x107`, `0x108`, `0x109`, `0x10A`, `0x103`

> 1. The message with ID `0x00000104` will be sent before `0x103` because it has a higher priority.
> 2. The message `0x103` will be received via polling, and the polling interval is 500ms, so it is the last data to arrive.

### CAN0_TX_CAN1

This stage demonstrates the following:

* Use Enhanced FIFO and configure extended ID filters with three filtering modes

In this stage, the source code will send CAN messages in the following ID order:

`0x00000201`, `0x00000202`, `0x00000203`, `0x00000204`, `0x00000205`, `0x00000206`, `0x00000207`, `0x00000208`, `0x00000208`, `0x00000209`, `0x0000020A`, `0x20A`

The actual message order on the CAN bus will be:

`0x00000201`, `0x00000202`, `0x00000203`, `0x00000204`, `0x00000205`, `0x00000206`, `0x00000207`, `0x00000208`, `0x00000208`, `0x00000209`, `0x0000020A`, `0x20A`

The callback function will consider the received ID order as:

`0x00000201`, `0x00000202`, `0x00000203`, `0x00000204`, `0x00000205`, `0x00000206`, `0x00000207`, `0x00000208`, `0x00000208`, `0x00000209`, `0x20A`

> 1. The message with ID `0x0000020A` will be ignored because there is no filter matching this ID.

### CAN3_TX_CAN2

This stage demonstrates the following:

* Use Legacy FIFO with `CAN_LEGACY_RX_FIFO_FILTER_FORMAT_A` as the mailbox filtering mode

In this stage, the source code will send CAN messages in the following ID order:

`0x301`, `0x00000302`, `0x303`, `0x00000304`, `0x305`

The actual message order on the CAN bus will be:

`0x301`, `0x00000302`, `0x00000304`, `0x303`, `0x305`

The callback function will consider the received ID order as:

`0x305`, `0x301`, `0x00000302`, `0x00000304`, `0x303`

> 1. The Legacy FIFO filtering format is: `CAN_LEGACY_RX_FIFO_FILTER_FORMAT_A`.
> 2. The message with ID `0x303` is matched by Global_Filter0. See Figure 20.4 "ID Filter Table Structure" in the reference manual for why `0xC0C00000` matches `0x303`.
> 3. The message with ID `0x305` will be received in software because other messages are received with a 2ms polling interval.

### CAN2_TX_CAN3

This stage demonstrates the following:

* Use Legacy FIFO with `CAN_LEGACY_RX_FIFO_FILTER_FORMAT_B` as the mailbox filtering mode

In this stage, the source code will send CAN messages in the following ID order:

`0x401`, `0x04020000`, `0x04030000`, `0x100`, `0x101`, `0x10100000`, `0x404`, `0x04050000`

The actual message order on the CAN bus will be:

`0x401`, `0x100`, `0x04020000`, `0x04030000`, `0x101`, `0x04050000`, `0x404`, `0x10100000`

The callback function will consider the received ID order as:

`0x401`, `0x100`, `0x04020000`, `0x04030000`, `0x04050000`, `0x404`, `0x10100000`

> 1. The Legacy FIFO filtering format is: `CAN_LEGACY_RX_FIFO_FILTER_FORMAT_B`.
> 2. The message with ID `0x100` is matched by Individual_Filter2. See Figure 20.4 "ID Filter Table Structure" in the reference manual for why `0x04020000` matches `0x100`.
> 3. The message with ID `0x404` is matched by Individual_Filter3. See Figure 20.4 "ID Filter Table Structure" in the reference manual for why `0x10100000` matches `0x404`.
> 4. The message with ID `0x101` will be ignored because there is no filter matching this ID.

---

## HW requirement
+ **EVB**: YTM32B1HA01-EVB-Q176-Rev.A
+ **Debugger**: J-Link HW v9 or later with YUNTU YTM32B1HA01 patch(support package) installed.

---
## SW requirement

+ **Config & Code Generation Tool**
  + **MCAL**:     Yuntu Config Tool(YCT) v2.6 or later version
+ **Compiler Toolchain**
  + **GCC**     : GNU GCC v10.3 or later version
  + **Keil/MDK**: ARM Keil/MDK v5.36 or later version
  + **IAR**     : IAR v8.40 or later version
  + **VS Code**  : Microsoft Visual Studio Code IDE v1.76 or later version(C/C++ support, GNU toolchain, CMake v3.25, ninja, Cortex-Debug extensions installation required)
+ **Debugger driver**
    + **J-Link**              : SEGGER J-Link v7.82 or later version, YUNTU YTM32B1HA01 patch(support package) installation required.
    + **Ozone Debugger tool**  : SEGGER Ozone v3.28 or later version.

    ***Note***:  **YTM32B1HA0** patch install required which can be obtained via **YCT** or contact ***YUNTU sales/FAE team***.

---

## Errata

1. To enable CAN1, disconnect the EVB J17 and J19 jumpers and connect J17-1 to J19-2, and J19-1 to J17-2.
2. To enable CAN2, disconnect the EVB J25 and connect J25-2 to P4-87.

---

## Steps

1. **Step 1**: Open `Can_Demo.yct` with the YCT tool and configure the toolchain according to your needs (default is VS Code + GCC).
2. **Step 2**: Generate the code. If necessary, change the configuration (to suit your own hardware design). Ensure all modifications are correct before generating the code.
3. **Step 3**: Open the generated project with your chosen VS Code/IAR/Keil IDE.
4. **Step 4**: Compile the project, power on the EVB, and download it to the EVB via the available debugger (such as the J-Link debugger probe).
5. **Step 5**: If you did not change the default configuration, you can find the logical names corresponding to the silk screen on the EVB.
6. **Step 6**: Connect CAN1 and CAN2, and CAN2 and CAN3 respectively.
7. **Step 7**: Change the `Demo_State` in **main.c** and then compile to test different send and receive types.

---