/*
* @file    SchM_Platform.h
*==================================================================================================
*   Project              : YTMicro AUTOSAR 4.4.0 MCAL
*   Platform             : ARM
*   Peripheral           : SchM_Platform
*   Dependencies         : none
*
*   Autosar Version      : V4.4.0
*   Autosar Revision     : ASR_REL_4_4_REV_0000
*   SW Version           : V1.0.0.HF001
*
*   (c) Copyright 2020-2025 Yuntu Microelectronics co.,ltd.
*   All Rights Reserved.
==================================================================================================*/

#ifndef SCHM_PLATFORM_H
#define SCHM_PLATFORM_H

/**
*   @file    SchM_Platform.h
*
*   @addtogroup SCHM_PLATFORM_MODULE
*   @{
*/

#ifdef __cplusplus
extern "C" {
#endif

/*==================================================================================================
                                              INCLUDE FILES                                          
==================================================================================================*/
/*==================================================================================================
                                      HEADER FILE VERSION INFORMATION                                
==================================================================================================*/
#define SCHM_PLATFORM_VENDOR_ID                      (180)
#define SCHM_PLATFORM_AR_RELEASE_MAJOR_VERSION       (4)
#define SCHM_PLATFORM_AR_RELEASE_MINOR_VERSION       (4)
#define SCHM_PLATFORM_AR_RELEASE_REVISION_VERSION    (0)
#define SCHM_PLATFORM_SW_MAJOR_VERSION               (1)
#define SCHM_PLATFORM_SW_MINOR_VERSION               (0)
#define SCHM_PLATFORM_SW_PATCH_VERSION               (0)
/*==================================================================================================
                                                DEFINES AND MACROS                                       
==================================================================================================*/

/* Number of cores id */
#ifndef NUMBER_OF_CORES
#define NUMBER_OF_CORES         (uint8)(1U)
#endif /* NUMBER_OF_CORES */

/*==================================================================================================
                                                EXTERNAL CONSTANTS                                        
==================================================================================================*/
/*==================================================================================================
                                                ENUMS                                        
==================================================================================================*/
/*==================================================================================================
                                                FUNCTION PROTOTYPES                                           
==================================================================================================*/

extern void SchM_Enter_Platform_PLATFORM_EXCLUSIVE_AREA_00(void);
extern void SchM_Exit_Platform_PLATFORM_EXCLUSIVE_AREA_00(void);

#ifdef __cplusplus
}
#endif

/** @} */

#endif /* End of file SchM_Platform.h */

