{{ytCopyright 'lin_lib_config.h'}}



#ifndef LIN_LIB_CONFIG_H_
#define LIN_LIB_CONFIG_H_

#include "lin_types.h"

{{#if (getGlobalVar 'meta.isLinUart')}}
#define LIN_USE_UART
#include "lin_driver.h"
{{else}}
#include "linflexd_lin_driver.h"
{{/if}}

#define LIN_IFC_INST {{objLen this.data.ldf}}

{{setVar2 'hasMaster' false}}
{{setVar2 'hasSlave' false}}
{{#each this.data.ldf}}


{{setVar2 'index' @index~}}
{{setVar2 'variant' @key~}}

/*  === start of {{@root.variant}} === */

#define LIN_IFC_{{@root.variant}} ((l_ifc_handle){{@root.index}})

/* signal handle and flag macro define */
{{setVar2 'signals' this.signals~}}
{{setVar2 'nodeName' this.global.targetNode~}}
{{#eq this.node.master.nodeName @root.nodeName~}}
{{setVar2 'master' true~}}
{{setVar2 'hasMaster' true~}}
{{else~}}
{{setVar2 'hasSlave' true~}}
{{setVar2 'master' false~}}
{{/eq}}
{{setVar2 'sigCnt' 0~}}
{{#each @root.signals}}
{{#or (gte (indexOf this.subscribedBy @root.nodeName) 0) (eq this.punishedBy @root.nodeName)~}}
/* {{this.signalName}}*/
#define {{@root.variant}}_{{this.signalName}}_signal_handle (l_signal_handle)({{@root.index}}<<16|{{@root.sigCnt}})
#define {{@root.variant}}_{{this.signalName}}_flag_handle (l_flag_handle)({{@root.index}}<<24|{{@root.sigCnt}})
{{#eq this.singleType 'Scalar'}}
{{#eq (Number this.signalSizeBits) 1}}
#define l_bool_rd_{{@root.variant}}_{{this.signalName}}() l_bool_rd({{@root.variant}}_{{this.signalName}}_signal_handle)
{{#eq this.punishedBy @root.nodeName}}
#define l_bool_wr_{{@root.variant}}_{{this.signalName}}(v) l_bool_wr({{@root.variant}}_{{this.signalName}}_signal_handle,v)
{{/eq}}
{{else}}
{{#gt (Number this.signalSizeBits) 8}}
#define l_u16_rd_{{@root.variant}}_{{this.signalName}}() l_u16_rd({{@root.variant}}_{{this.signalName}}_signal_handle)
{{#eq this.punishedBy @root.nodeName}}
#define l_u16_wr_{{@root.variant}}_{{this.signalName}}(v) l_u16_wr({{@root.variant}}_{{this.signalName}}_signal_handle,v)
{{/eq}}
{{else}}
#define l_u8_rd_{{@root.variant}}_{{this.signalName}}() l_u8_rd({{@root.variant}}_{{this.signalName}}_signal_handle)
{{#eq this.punishedBy @root.nodeName}}
#define l_u8_wr_{{@root.variant}}_{{this.signalName}}(v) l_u8_wr({{@root.variant}}_{{this.signalName}}_signal_handle,v)
{{/eq}}
{{/gt}}
{{/eq}}
{{else}}
#define l_bytes_rd_{{@root.variant}}_{{this.signalName}}(start,count,data) l_bytes_rd({{@root.variant}}_{{this.signalName}}_signal_handle,start,count,data)
{{#eq this.punishedBy @root.nodeName}}
#define l_bytes_wr_{{@root.variant}}_{{this.signalName}}(start,count,data) l_bytes_wr({{@root.variant}}_{{this.signalName}}_signal_handle,start,count,data)
{{/eq}}
{{/eq}}
#define l_flg_clr_{{@root.variant}}_{{this.signalName}}() l_flg_clr({{@root.variant}}_{{this.signalName}}_flag_handle)
#define l_flg_tst_{{@root.variant}}_{{this.signalName}}() l_flg_tst({{@root.variant}}_{{this.signalName}}_flag_handle) 
{{setVar2 'sigCnt' (add @root.sigCnt 1)~}}
{{/or}}
{{/each}}

/* frame flag macro define */
{{setVar2 'curIndex' 0~}}
{{setVar2 'frameIndex' (createObject)~}}
{{#each this.frames~}}
{{#eq @root.nodeName this.publishedBy~}}
#define {{@root.variant}}_{{@key}}_flag_handle (l_flag_handle)({{@root.index}}<<24|1<<16|{{@root.curIndex}})
#define l_flg_clr_{{@root.variant}}_{{@key}}() l_flg_clr({{@root.variant}}_{{@key}}_flag_handle)
#define l_flg_tst_{{@root.variant}}_{{@key}}() l_flg_tst({{@root.variant}}_{{@key}}_flag_handle) 
{{set2 @root.frameIndex @key @root.curIndex~}}
{{setVar2 'curIndex' (add @root.curIndex 1)~}}
{{else~}}
{{setVar2 'subList' (createArray)~}}
{{#each this.signals~}}
{{#each (get 'subscribedBy' (get this.name @root.signals))~}}
{{setVar2 'subList' (push @root.subList this)~}}
{{/each~}}
{{/each~}}
{{#gte (indexOf @root.subList @root.nodeName) 0~}}
#define {{@root.variant}}_{{@key}}_flag_handle (l_flag_handle)({{@root.index}}<<24|1<<16|{{@root.curIndex}})
#define l_flg_clr_{{@root.variant}}_{{@key}}() l_flg_clr({{@root.variant}}_{{@key}}_flag_handle)
#define l_flg_tst_{{@root.variant}}_{{@key}}() l_flg_tst({{@root.variant}}_{{@key}}_flag_handle) 
{{set2 @root.frameIndex @key @root.curIndex~}}
{{setVar2 'curIndex' (add @root.curIndex 1)~}}
{{else}}
{{#if @root.master}}
#define {{@root.variant}}_{{@key}}_flag_handle (l_flag_handle)({{@root.index}}<<24|1<<16|{{@root.curIndex}})
#define l_flg_clr_{{@root.variant}}_{{@key}}() l_flg_clr({{@root.variant}}_{{@key}}_flag_handle)
#define l_flg_tst_{{@root.variant}}_{{@key}}() l_flg_tst({{@root.variant}}_{{@key}}_flag_handle) 
{{set2 @root.frameIndex @key @root.curIndex~}}
{{setVar2 'curIndex' (add @root.curIndex 1)~}}
{{/if}}
{{/gte~}}    
{{/eq~}}
{{/each~}}
{{#if @root.master}}
{{#each this.eventTriggeredFrames}}
#define {{@root.variant}}_{{this.name}}_flag_handle (l_flag_handle)({{@root.index}}<<24|1<<16|{{@root.curIndex}})
#define l_flg_clr_{{@root.variant}}_{{this.name}}() l_flg_clr({{@root.variant}}_{{this.name}}_flag_handle)
#define l_flg_tst_{{@root.variant}}_{{this.name}}() l_flg_tst({{@root.variant}}_{{this.name}}_flag_handle) 
{{set2 @root.frameIndex this.name @root.curIndex~}}
{{setVar2 'curIndex' (add @root.curIndex 1)~}}
{{/each}}
{{else}}
{{#each this.eventTriggeredFrames}}
{{setVar2 'eventFrameName' this.name ~}}
{{#each this.frameNames}}
{{#if (hasOwnProperty @root.frameIndex this)~}}
#define {{@root.variant}}_{{@root.eventFrameName}}_flag_handle (l_flag_handle)({{@root.index}}<<24|1<<16|{{@root.curIndex}})
#define l_flg_clr_{{@root.variant}}_{{@root.eventFrameName}}() l_flg_clr({{@root.variant}}_{{@root.eventFrameName}}_flag_handle)
#define l_flg_tst_{{@root.variant}}_{{@root.eventFrameName}}() l_flg_tst({{@root.variant}}_{{@root.eventFrameName}}_flag_handle) 
{{set2 @root.frameIndex @root.eventFrameName @root.curIndex~}}
{{setVar2 'curIndex' (add @root.curIndex 1)~}}
{{/if}}
{{/each}}
{{/each}}
{{/if}}
#define {{@root.variant}}_master_req_flag_handle (l_flag_handle)({{@root.index}}<<24|1<<16|{{@root.curIndex}})
 {{setVar2 'curIndex' (add @root.curIndex 1)~}}
#define {{@root.variant}}_slave_resp_flag_handle (l_flag_handle)({{@root.index}}<<24|1<<16|{{@root.curIndex}})
/*  === end of {{@root.variant}} === */
{{/each}}





{{#each this.data.ldf}}
{{setVar2 'variant' @key}}
{{setVar2 'nodeName' this.global.targetNode~}}
{{#eq this.node.master.nodeName @root.nodeName~}}
{{setVar2 'master' true~}}
{{else~}}
{{setVar2 'master' false~}}
{{/eq}}

{{#if @root.master}}
extern const struct lin_sch_t* g_linGlobalSchTable[];

extern const uint8_t g_linGlobalSchTableNum;

#define l_sch_tick_{{@root.variant}}() l_sch_tick({{@index}})
#define l_sch_set_{{@root.variant}}(sch,entry) l_sch_set({{@index}},sch,entry)

{{#each this.schTables}}
#define SCH_{{@root.variant}}_{{this.name}} {{@index}}
{{/each}}
#define SCH_{{@root.variant}}_sleepTable {{this.schTables.length}}


{{/if}}


{{/each}}


{{#if @root.hasMaster}}
#define LIN_HAS_MASTER
{{/if}}
{{#if @root.hasSlave}}
#define LIN_HAS_SLAVE
{{/if}}



typedef struct
{
    l_u16 ifcStatus;                /*!< interface status for l_ifc_read_status*/
    lin_frame_status_t frameStatus; /*!< frame status*/
	lin_error_t error;              /*!< last error code */
	lin_frame_sm_t frameSm;         /*!< frame state machine */
	const lin_frame_t* activeFrame; /*!< active frame */
    int frameTimeout;               /*!< timeout count */
    int idleTimeout;                /*!< idle timeout count */

#ifdef LIN_USE_UART
    uint8_t dataBuffer[8];
    uint8_t dataLength;
    uint8_t id;
    lin_event_id_t event;           /*!< lin event id */
#else
	linflexd_event_id_t event;     /*!< linflexd event id */
	linflexd_frame_t frameBuf;     /*!< frame buffer */
#endif
    
    l_u8* dataPool;                 /*!< data pool */
    l_u8* frameFlagPool;            /*!< frame flag pool */
    l_u8* signalFlagPool;           /*!< signal flag pool */
    l_u8* updateFlagPool;           /*!< update flag pool */
    
    lin_master_state_t* masterState;    /*!< master state */
    lin_slave_state_t* slaveState;      /*!< slave state */
    lin_tp_state_t* tpState;            /*!< transport layer state */
    l_bool tpInit;                  /*!< transport layer init */

#ifdef LIN_DEBUG
    l_u16 preSendCnt;
    l_u16 sendCnt;
#endif
}lin_core_state_t;


extern const lin_config_t* g_linGlobalConfig[LIN_IFC_INST];
extern lin_core_state_t g_linGlobalState[LIN_IFC_INST];

extern void lin_config_init();
#endif