/* USER CODE BEGIN Header */
/* you can remove the copyright */

/*
 *  Copyright 2020-2023 Yuntu Microelectronics co.,ltd
 *  All rights reserved.
 * 
 *  YUNTU Confidential. This software is owned or controlled by YUNTU and may only be
 *  used strictly in accordance with the applicable license terms. By expressly
 *  accepting such terms or by downloading, installing, activating and/or otherwise
 *  using the software, you are agreeing that you have read, and that you agree to
 *  comply with and are bound by, such license terms. If you do not agree to be
 *  bound by the applicable license terms, then you may not retain, install,
 *  activate or otherwise use the software. The production use license in
 *  Section 2.3 is expressly granted for this software.
 * 
 * @file main.c
 * @brief 
 * 
 */

/* USER CODE END Header */
#include "sdk_project_config.h"
/* Includes ------------------------------------------------------------------*/

/* Private includes ----------------------------------------------------------*/
/* USER CODE BEGIN Includes */
#include "lin_core.h"
#include "lin_tp.h"
/* USER CODE END Includes */

/* Private typedef -----------------------------------------------------------*/
/* USER CODE BEGIN PTD */
/* USER CODE END PTD */

/* Private define ------------------------------------------------------------*/
/* USER CODE BEGIN PD */
/* USER CODE END PD */

/* Private macro -------------------------------------------------------------*/
/* USER CODE BEGIN PM */
/* USER CODE END PM */

/* Private variables ---------------------------------------------------------*/
/* USER CODE BEGIN PV */
/* user use debug to modify the action to test the demo */
/* action=0: idle */
/* action=1: case 1 */
/* action=2: case 2 */
/* *** see below code ***/
uint32_t action=0;
/* USER CODE END PV */

/* Private function declare --------------------------------------------------*/
/* USER CODE BEGIN PFDC */
/* USER CODE END PFDC */
static void Board_Init(void);

/* Private user code ---------------------------------------------------------*/
/* USER CODE BEGIN 0 */
void lin_error_handler(l_ifc_handle inst,l_u8 id,lin_error_t error_code)
{

}



void pTMR0_Ch0_IRQHandler(){
    l_sch_tick(0);
    pTMR_DRV_ClearInterruptFlagTimerChannels(0,0);
}
   
l_u8 ld_read_by_id_callout (l_ifc_handle inst,l_u8 id,l_u8* data){
    return LD_NEGATIVE_RESPONSE;
}
/* USER CODE END 0 */


/**
 * @brief  The application entry point.
 * @retval int
 */
int main(void)
{
    /* USER CODE BEGIN 1 */
    int cnt=0;
    static uint8_t isEventTable=0;
    /* USER CODE END 1 */ 
    Board_Init();
    /* USER CODE BEGIN 2 */
    l_sys_init();
    /* init seatEcu*/
    l_ifc_init(0); 
    /* init Motor1*/
    l_ifc_init(1);
    /* init Motor2*/
    l_ifc_init(2);
    /* init tp for seatEcu*/  
    ld_init(0);
    /* init tp for Motor1*/
    ld_init(1);

    /* use NormalTable as init table */
    l_sch_set(0, SCH_SeatECU_NormalTable, 0);

    /* 5ms timer for sys_tick */
    pTMR_DRV_InitChannel(0,0,&ptmr_channel_0);
    pTMR_DRV_StartTimerChannels(0,0);
    /* USER CODE END 2 */

    /* Infinite loop */
    /* USER CODE BEGIN WHILE */
    while (1)
    {
        /* USER CODE END WHILE */
        /* USER CODE BEGIN 3 */
        cnt++;
        switch (action) {
            case 1:
                /* case 1: send 0x3C */
                if(cnt%10000==0){
                    if(l_u8_rd_SeatECU_MotorDirection()==0){
                        l_u8_wr_SeatECU_MotorDirection(1);
                    }else{
                        l_u8_wr_SeatECU_MotorDirection(0);
                    }
                }
                if(l_flg_tst_Motor1_MotorDirection()==l_true){
                    /* motor1 has received a frame*/
                    l_flg_clr_Motor1_MotorDirection();
                    /* PTB4 */
                    PINS_DRV_WritePin(GPIOB, 4,l_u8_rd_Motor1_MotorDirection());
                }
                if(l_flg_tst_Motor2_MotorDirection()==l_true){
                    /* motor1 has received a frame*/
                    l_flg_clr_Motor2_MotorDirection();
                    /* PTB5 */
                    PINS_DRV_WritePin(GPIOB, 5,l_u8_rd_Motor2_MotorDirection());
                }
                
                break;
            case 2:
                /* case2: event frame */
                if(isEventTable==0){
                    l_sch_set(0, SCH_SeatECU_NormalTableEvent, 0);
                    l_u8_wr_Motor1_Motor1ErrorCode(l_u8_rd_Motor1_Motor1ErrorCode()+1);
                    l_u8_wr_Motor2_Motor2ErrorCode(l_u8_rd_Motor2_Motor2ErrorCode()+1);
                    isEventTable=1;
                }
            /* FAE help to add other cases */
            default:
                break;
        
        }

    }
    /* USER CODE END 3 */
}

static void Board_Init(void)
{
    CLOCK_SYS_Init(g_clockManConfigsArr,CLOCK_MANAGER_CONFIG_CNT,g_clockManCallbacksArr,CLOCK_MANAGER_CALLBACK_CNT);
    CLOCK_SYS_UpdateConfiguration(CLOCK_MANAGER_ACTIVE_INDEX,CLOCK_MANAGER_POLICY_AGREEMENT);
    PINS_DRV_Init(NUM_OF_CONFIGURED_PINS0,g_pin_mux_InitConfigArr0);
    LINFlexD_DRV_Init(0,&linflexd_lin_config0,&linflexd_lin_config0_State);
    LINFlexD_DRV_Init(1,&linflexd_lin_config1,&linflexd_lin_config1_State);
    LINFlexD_DRV_Init(3,&linflexd_lin_config2,&linflexd_lin_config2_State);
    pTMR_DRV_Init(0,&PTMR_Config);
    INT_SYS_ConfigInit();
}

/* USER CODE BEGIN 4 */
/* USER CODE END 4 */
