{{ytCopyright 'lin_lib_config.c'}}

#include "lin_lib_config.h"



{{setVar2 'pidTable' (split '0x80, 0xC1, 0x42, 0x03, 0xC4, 0x85, 0x06, 0x47,0x08, 0x49, 0xCA, 0x8B, 0x4C, 0x0D, 0x8E, 0xCF,0x50, 0x11, 0x92, 0xD3, 0x14, 0x55, 0xD6, 0x97,0xD8, 0x99, 0x1A, 0x5B, 0x9C, 0xDD, 0x5E, 0x1F,0x20, 0x61, 0xE2, 0xA3, 0x64, 0x25, 0xA6, 0xE7,0xA8, 0xE9, 0x6A, 0x2B, 0xEC, 0xAD, 0x2E, 0x6F,0xF0, 0xB1, 0x32, 0x73, 0xB4, 0xF5, 0x76, 0x37,0x78, 0x39, 0xBA, 0xFB, 0x3C, 0x7D, 0xFE, 0xBF')}}

{{#each this.data.ldf}}
{{setVar2 'variant' @key~}}
/* =====  start of {{@root.variant}} config ==== */
{{setVar2 'signals' this.signals~}}
{{setVar2 'nodeName' this.global.targetNode~}}
{{setVar2 'nodeAttrs' this.nodeAttrs}}
{{#eq this.node.master.nodeName @root.nodeName~}}
{{setVar2 'master' true~}}
{{else~}}
{{setVar2 'master' false~}}
{{setVar2 'nodeAttr' (get this.global.targetNode this.nodeAttrs)}}
{{/eq}}
{{setVar2 'sigCnt' 0~}}
{{setVar2 'eventFrames' this.eventTriggeredFrames~}}
{{setVar2 'sporadicFrames' this.sporadicFrames~}}
{{setVar2 'frames' this.frames~}}
{{setVar2 'sigIndex' (createObject)}}
{{setVar2 'bufOffset' 0~}}

/* {{@key}} */
static const lin_signal_t {{@root.variant}}_signals[]={
{{#each @root.signals}}
{{#or (gte (indexOf this.subscribedBy @root.nodeName) 0) (eq this.punishedBy @root.nodeName)~}}
    /* {{this.signalName}}*/
    {
        .signalType={{#eq this.singleType 'Scalar'}}LIN_SIGNAL_TYPE_SCALAR{{else}}LIN_SIGNAL_TYPE_ARRAY{{/eq}},
        .flagBitOffset={{@root.sigCnt}},
        .bufOffset={{@root.bufOffset}},
        .bitLen={{this.signalSizeBits}},
    },
    {{setVar2 'bufOffset' (add @root.bufOffset (ceil (divide this.signalSizeBits 8)))~}}
    {{set2 @root.sigIndex this.signalName @root.sigCnt}}
    {{setVar2 'sigCnt' (add @root.sigCnt 1)~}}
{{/or}}
{{/each}}
};

static l_u8 {{@root.variant}}_data_pool[{{@root.bufOffset}}] = {
{{#each @root.signals}}
{{#or (gte (indexOf this.subscribedBy @root.nodeName) 0) (eq this.punishedBy @root.nodeName)~}}
    /* {{this.signalName}}*/
{{#eq this.singleType 'Scalar'}}
{{#gt this.signalSizeBits 8}}
    {{modulo this.initValue 256}}, {{floor (divide this.initValue 256)}},
{{else}}
    {{this.initValue}},
{{/gt}}
{{else}}
    {{this.initValue}},
{{/eq}}
{{/or}}
{{/each}}    
};
static l_u8 {{@root.variant}}_flag_pool[{{ceil (divide @root.sigCnt 8)}}];
static l_u8 {{@root.variant}}_update_pool[{{ceil (divide @root.sigCnt 8)}}];

/* const signal config */
{{#each this.frames~}}
{{#eq @root.nodeName this.publishedBy~}}
/* frame {{this.name}} signals table */
static const l_u8 {{@root.variant}}_{{this.name}}_signals[]={
{{#each this.signals~}}
     /* {{this.name}}*/
    {{get this.name @root.sigIndex}},
{{/each}}
};
{{else~}}
{{setVar2 'subList' (createArray)~}}
{{#each this.signals~}}
{{#each (get 'subscribedBy' (get this.name @root.signals))~}}
{{setVar2 'subList' (push @root.subList this)~}}
{{/each~}}
{{/each~}}
{{#gte (indexOf @root.subList @root.nodeName) 0~}}
/* frame {{this.name}} signals table */
static const l_u8 {{@root.variant}}_{{this.name}}_signals[]={
{{#each this.signals~}}
    /* {{this.name}}, offset*/
    {{get this.name @root.sigIndex}},
{{/each}}
};
{{/gte~}}    
{{/eq~}}
{{/each~}}



{{#each this.frames~}}
{{#eq @root.nodeName this.publishedBy~}}
/* frame {{this.name}} signals table */
static const l_u8 {{@root.variant}}_{{this.name}}_offsets[]={
{{#each this.signals~}}
     /* {{this.name}}*/
    {{this.offset}},
{{/each}}
};
{{else~}}
{{setVar2 'subList' (createArray)~}}
{{#each this.signals~}}
{{#each (get 'subscribedBy' (get this.name @root.signals))~}}
{{setVar2 'subList' (push @root.subList this)~}}
{{/each~}}
{{/each~}}
{{#gte (indexOf @root.subList @root.nodeName) 0~}}
/* frame {{this.name}} signals table */
static const l_u8 {{@root.variant}}_{{this.name}}_offsets[]={
{{#each this.signals~}}
    /* {{this.name}}, offset*/
    {{this.offset}},
{{/each}}
};
{{/gte~}}    
{{/eq~}}
{{/each~}}


/* const frame config */
static const lin_frame_t {{@root.variant}}_frames[]={
{{setVar2 'frameIndex' (createObject)~}}
{{setVar2 'curIndex' 0~}}
{{setVar2 'frameId' (createObject)~}}
{{#each this.frames~}}
{{#eq @root.nodeName this.publishedBy~}}
    /* {{@key}} */
    {{set2 @root.frameIndex @key @root.curIndex~}}
    {{set2 @root.frameId @key this.id~}}
    {
        .frameType=LIN_FRAME_TYPE_UNCD,
        .bufLen={{this.frameSize}},
        .flagBitOffset={{@root.curIndex}},
        .id={{this.id}},
        .dir=LIN_DIR_PUBLISH,
        .checksumType=LIN_FRAME_CHECKSUM_ENHANCED,
        .signalList={{@root.variant}}_{{this.name}}_signals,
        .signalOffset={{@root.variant}}_{{this.name}}_offsets,
        .signalNum={{objLen this.signals}},
{{#if @root.master}}
        .idChangeable=l_false,
{{else}}
        .idChangeable={{#gt (indexOf @root.nodeAttr.configFrames @key) -1}}l_true{{else}}l_false{{/gt}},
        .idRamIndex={{add 1 (indexOf @root.nodeAttr.configFrames @key)}},
{{/if}}
    },
    {{setVar2 'curIndex' (add @root.curIndex 1)~}}
{{else~}}
{{setVar2 'subList' (createArray)~}}
{{#each this.signals~}}
{{#each (get 'subscribedBy' (get this.name @root.signals))~}}
{{setVar2 'subList' (push @root.subList this)~}}
{{/each~}}
{{/each~}}
{{#gte (indexOf @root.subList @root.nodeName) 0~}}
    /* {{@key}} */
    {{set2 @root.frameIndex @key @root.curIndex~}}
    {{set2 @root.frameId @key this.id~}}
    {
        .frameType=LIN_FRAME_TYPE_UNCD,
        .bufLen={{this.frameSize}},
        .flagBitOffset={{@root.curIndex}},
        .id={{this.id}},
        .dir=LIN_DIR_SUBSCRIBE,
        .checksumType=LIN_FRAME_CHECKSUM_ENHANCED,
        .signalList={{@root.variant}}_{{this.name}}_signals,
        .signalOffset={{@root.variant}}_{{this.name}}_offsets,
        .signalNum={{objLen this.signals}},
{{#if @root.master}}
        .idChangeable=l_false,
{{else}}
        .idChangeable={{#gt (indexOf @root.nodeAttr.configFrames @key) -1}}l_true{{else}}l_false{{/gt}},
        .idRamIndex={{add 1 (indexOf @root.nodeAttr.configFrames @key)}},
{{/if}}      
    },
    {{setVar2 'curIndex' (add @root.curIndex 1)~}}
{{else}}
{{#if @root.master}}
    {{set2 @root.frameIndex @key @root.curIndex~}}
    {{set2 @root.frameId @key this.id~}}
    /* {{@key}} */
    {
        .frameType=LIN_FRAME_TYPE_UNCD,
        .bufLen={{this.frameSize}},
        .flagBitOffset={{@root.curIndex}},
        .id={{this.id}},
        .dir=LIN_DIR_SUBSCRIBE_IGNORE_DATA,
        .checksumType=LIN_FRAME_CHECKSUM_ENHANCED,
        .signalList={{@root.variant}}_{{this.name}}_signals,
        .signalOffset={{@root.variant}}_{{this.name}}_offsets,
        .signalNum={{objLen this.signals}},
        .idChangeable=l_false,
    },
    {{setVar2 'curIndex' (add @root.curIndex 1)~}}
{{/if}}
{{/gte~}}    
{{/eq~}}
{{/each~}}
{{#if @root.master}}
    /* event frames for master*/
{{#each this.eventTriggeredFrames}}
    /* {{this.name}} */
    {{set2 @root.frameIndex this.name @root.curIndex~}}
    {{set2 @root.frameId this.name this.frameId~}}
    {
        .frameType=LIN_FRAME_TYPE_EVENT,
        .flagBitOffset={{@root.curIndex}},
        .id={{this.frameId}},
        .bufLen={{get 'frameSize' (get (get '0' this.frameNames) @root.frames)}},
        .dir=LIN_DIR_SUBSCRIBE,
        .checksumType=LIN_FRAME_CHECKSUM_ENHANCED,
        .idChangeable=l_false,
    },
    {{setVar2 'curIndex' (add @root.curIndex 1)~}}
{{/each}}
{{else}}
    /* event frames for slave*/
{{#each this.eventTriggeredFrames}}
{{setVar2 'eventId' this.frameId ~}}
{{setVar2 'eventFrameName' this.name ~}}
{{#each this.frameNames}}
{{#if (hasOwnProperty @root.frameIndex this)~}}
    /* {{@root.eventFrameName}} */
    {{set2 @root.frameIndex @root.eventFrameName @root.curIndex~}}
    {{set2 @root.frameId @root.eventFrameName @root.eventId~}}
    {
        .frameType=LIN_FRAME_TYPE_EVENT,
        .id={{@root.eventId}},
        .subIdIndex={{get (get 'name' (get this @root.frames)) @root.frameIndex}},
        .flagBitOffset={{@root.curIndex}},
        .bufLen={{get 'frameSize' (get this @root.frames)}},
        .signalList={{@root.variant}}_{{this}}_signals, /* reused unconditional frames signal*/
        .signalOffset={{@root.variant}}_{{this}}_offsets,
        .signalNum={{objLen (get 'signals' (get this @root.frames))}},
        .dir=LIN_DIR_PUBLISH,
        .checksumType=LIN_FRAME_CHECKSUM_ENHANCED,
        .idChangeable={{#gt (indexOf @root.nodeAttr.configFrames @root.eventFrameName) -1}}l_true{{else}}l_false{{/gt}},
        .idRamIndex={{add 1 (indexOf @root.nodeAttr.configFrames @root.eventFrameName)}},                
    },
    {{setVar2 'curIndex' (add @root.curIndex 1)~}}
{{/if}}
{{/each}}
{{/each}}
{{/if}}
{{#if @root.master}}
    /* diagnostic frames for master*/
    {{set2 @root.frameIndex 'masterReq' @root.curIndex~}}
    {
        .frameType=LIN_FRAME_TYPE_DIAG,
        .id=0x3C,
        .flagBitOffset={{@root.curIndex}},
        .bufLen=8,
        .dir=LIN_DIR_PUBLISH,
        .checksumType=LIN_FRAME_CHECKSUM_CLASSIC,
        .idChangeable=l_false,
    },
    {{setVar2 'curIndex' (add @root.curIndex 1)~}}
    {{set2 @root.frameIndex 'slaveResp' @root.curIndex~}}
    {
        .frameType=LIN_FRAME_TYPE_DIAG,
        .id=0x3D,
        .flagBitOffset={{@root.curIndex}},
        .bufLen=8,
        .dir=LIN_DIR_SUBSCRIBE,
        .checksumType=LIN_FRAME_CHECKSUM_CLASSIC,
        .idChangeable=l_false,
    },
    {{setVar2 'curIndex' (add @root.curIndex 1)~}}
{{else}}
    /* diagnostic frames for slave*/
    {{set2 @root.frameIndex 'masterReq' @root.curIndex~}}
    {
        .frameType=LIN_FRAME_TYPE_DIAG,
        .id=0x3C,
        .flagBitOffset={{@root.curIndex}},
        .bufLen=8,
        .dir=LIN_DIR_SUBSCRIBE,
        .checksumType=LIN_FRAME_CHECKSUM_CLASSIC,
        .idChangeable=l_false,
    },
    {{setVar2 'curIndex' (add @root.curIndex 1)~}}
    {{set2 @root.frameIndex 'slaveResp' @root.curIndex~}}
    {
        .frameType=LIN_FRAME_TYPE_DIAG,
        .id=0x3D,
        .flagBitOffset={{@root.curIndex}},
        .bufLen=8,
        .dir=LIN_DIR_PUBLISH,
        .checksumType=LIN_FRAME_CHECKSUM_CLASSIC,
        .idChangeable=l_false,
    },
    {{setVar2 'curIndex' (add @root.curIndex 1)~}}
{{/if}}
};


static l_u8 {{@root.variant}}_frame_flag_pool[{{ceil (divide @root.curIndex 8)}}];



{{#if @root.master}}

{{#each this.sporadicFrames}}
const l_u8 {{@root.variant}}_sporadic_{{this.name}}_frame_list[]={
{{#each this.frameNames}}
    {{get this @root.frameIndex}},
{{/each}}
};
{{/each}}

{{setVar2 'slaveRespSchIndex' 'LIN_INVALID_SCH_INDEX'~}}
{{setVar2 'masterReqSchIndex' 'LIN_INVALID_SCH_INDEX'~}}

{{#each this.schTables}}
{{setVar2 'schName' this.name}}
const lin_sch_slot_t {{@root.variant}}_sch_{{this.name}}_slots[]={
{{setVar2 'schIndex' @index}}
{{#each this.entries}}
{{#if this.isCommand}}
    /* Command-{{this.name}}*/
{{#eq this.name 'DiagnosticMasterReq'}}
    {
        .frameType=LIN_FRAME_TYPE_DIAG,
        .delay={{this.delay}},
        .diag.frameIndex={{get 'masterReq' @root.frameIndex}},
        .diag.diagType=0,
    },
    {{setVar2 'masterReqSchIndex' @root.schIndex}}
{{/eq}}
{{#eq this.name 'DiagnosticSlaveResp'}}
    {
        .frameType=LIN_FRAME_TYPE_DIAG,
        .delay={{this.delay}},
        .diag.frameIndex={{get 'slaveResp' @root.frameIndex}},
        .diag.diagType=0,
    },
    {{setVar2 'slaveRespSchIndex' @root.schIndex}}
{{/eq}}
{{else}}
    /* {{this.name}} */
{{#if (hasOwnProperty @root.frames this.name)}}
    {
        .frameType=LIN_FRAME_TYPE_UNCD,
        .delay={{this.delay}},
        .uncd.frameIndex={{get this.name @root.frameIndex}},
    },
{{/if}}
{{#if (hasOwnProperty @root.eventFrames this.name)}}
    {
        .frameType=LIN_FRAME_TYPE_EVENT,
        .delay={{this.delay}},
        .event.frameIndex={{get this.name @root.frameIndex}},
        .event.resolveSch=SCH_{{@root.variant}}_{{get 'schTableName' (get this.name @root.eventFrames)}},
    },
{{/if}}
{{#if (hasOwnProperty @root.sporadicFrames this.name)}}
    {
        .frameType=LIN_FRAME_TYPE_SPRDC,
        .delay={{this.delay}},
        .sprdc.frameList={{@root.variant}}_sporadic_{{get 'name' (get this.name @root.sporadicFrames)}}_frame_list,
        .sprdc.frameNum={{objLen (get 'frameNames' (get this.name @root.sporadicFrames))}},
    },
{{/if}}
{{/if}}
{{/each}}
};
{{/each}}

const lin_sch_slot_t {{@root.variant}}_sch_sleep_slots[]={
    /* sleep */
    {
        .frameType=LIN_FRAME_TYPE_DIAG,
        .delay=10,
        .diag.frameIndex=8,
        .diag.diagType=1,
    },
};

{{#each this.schTables}}
static const struct lin_sch_t {{@root.variant}}_{{this.name}}_sch={
    .slotList={{@root.variant}}_sch_{{this.name}}_slots,
    .numSlot={{objLen this.entries}},
{{setVar 'isColl' false~}}
{{setVar 'schName' this.name~}}
{{#each @root.eventFrames}}
{{#eq this.schTableName @root.schName}}
{{setVar 'isColl' true~}}
{{/eq~}}
{{/each}}
{{#if @root.isColl}}
    .schType=LIN_SCH_TYPE_COLLISION_RESOLVED,
{{else if (eq @root.masterReqSchIndex @index)}}
    .schType=LIN_SCH_TYPE_MASTER_REQUEST,
{{else if (eq @root.slaveRespSchIndex @index)}}
    .schType=LIN_SCH_TYPE_SLAVE_RESPONSE,
{{else}}
    .schType=LIN_SCH_TYPE_NORMAL,
{{/if}}
};
{{/each}}

static const struct lin_sch_t {{@root.variant}}_sleep_sch={
    .slotList={{@root.variant}}_sch_sleep_slots,
    .numSlot=1,
    .schType=LIN_SCH_TYPE_SLEEP,
};

const struct lin_sch_t* g_linGlobalSchTable[]={
    {{#each this.schTables}}
    &{{@root.variant}}_{{this.name}}_sch,
    {{/each}}
    &{{@root.variant}}_sleep_sch,
};

const uint8_t g_linGlobalSchTableNum={{add (objLen this.schTables) 1}};

const lin_master_config_t {{@root.variant}}_master_config={
    .masterReqSchIndex={{@root.masterReqSchIndex}},
    .slaveRespSchIndex={{@root.slaveRespSchIndex}},
    .sleepSchIndex={{objLen this.schTables}},
    .timeBase={{this.node.master.timeBase}},
    .schTimeout={{#isTruthy this.global.schTimeout}}{{this.global.schTimeout}}{{else}}0{{/isTruthy}},
};

{{else}}


static const lin_slave_config_t {{@root.variant}}_slave_config={
    .initNad={{get 'initial_NAD' @root.nodeAttr}},
    .configNad={{get 'configured_NAD' @root.nodeAttr}},
    .product_id={
        .supplierId={{get 'supplier_id' @root.nodeAttr}},
        .functionId={{get 'function_id' @root.nodeAttr}},
        .variant={{get 'variant' @root.nodeAttr}},
    },
    .sn={
        .serial0=0,
        .serial1=0,
        .serial2=0,
        .serial3=0,
    },
    .p2Min={{get 'P2_min' @root.nodeAttr}},
    .stMin={{get 'ST_min' @root.nodeAttr}},
    .nAsTimeout={{get 'N_As_timeout' @root.nodeAttr}},
    .nCrTimeout={{get 'N_Cr_timeout' @root.nodeAttr}},
};

{{/if}}




{{#if @root.master}}
static lin_master_state_t {{@root.variant}}_master_state;
{{else}}
static lin_slave_state_t {{@root.variant}}_slave_state;
{{/if}}


{{#if this.global.tpEnable}}
static lin_tp_state_t {{@root.variant}}_tp_state;
static lin_tp_item_t {{@root.variant}}_tp_tx_queue[{{this.global.tpTxQueueSize}}];
static lin_tp_item_t {{@root.variant}}_tp_rx_queue[{{this.global.tpRxQueueSize}}];
{{#if @root.master}}
static lin_master_tp_state_t {{@root.variant}}_master_tp_state;
{{else}}
static l_u8 {{@root.variant}}_id_list[{{add 1 @root.nodeAttr.configFrames.length}}]={
    {{@root.nodeAttr.initial_NAD}},
{{#each @root.nodeAttr.configFrames}}
    {{itemAt @root.pidTable (get this @root.frameId)}},
{{/each}}
};
{{/if}}
static const lin_tp_config_t {{@root.variant}}_tp_config={
    .txQueueSize={{this.global.tpTxQueueSize}},
    .rxQueueSize={{this.global.tpRxQueueSize}},
    .rxMaxFrameLength={{add (multiply (minus  (Number this.global.tpRxQueueSize) 1) 6) 5}},
    .idList={{#if @root.master}}NULL{{else}}{{@root.variant}}_id_list{{/if}},
    .idNum={{#if @root.master}}0{{else}}{{add 1 @root.nodeAttr.configFrames.length}}{{/if}},
};
{{/if}}
{{#isTruthy this.global.coreErrCb}}
extern void {{this.global.coreErrCb}}(l_ifc_handle inst,l_u8 id,lin_error_t error_code);
{{/isTruthy}}

const lin_config_t {{@root.variant}}_config={
    .hwInst={{this.global.hwInst}},
    .nodeType={{#if @root.master}}LIN_NODE_MASTER{{else}}LIN_NODE_SLAVE{{/if}},
    .frameNum={{@root.curIndex}},
    .frameList={{@root.variant}}_frames,
    .signalList={{@root.variant}}_signals,
    .signalNum={{@root.sigCnt}},
    .masterCfg={{#if @root.master}}&{{@root.variant}}_master_config{{else}}NULL{{/if}},
    .slaveCfg={{#if @root.master}}NULL{{else}}&{{@root.variant}}_slave_config{{/if}},
    .tpCfg={{#if this.global.tpEnable}}&{{@root.variant}}_tp_config{{else}}NULL{{/if}},
    .baudRate={{multiply this.global.LIN_speed 1000}},
    .maxIdleTimeoutMs={{this.global.maxIdleTimeoutMs}},
    .coreErrorCb={{#isTruthy this.global.coreErrCb}}{{this.global.coreErrCb}}{{else}}NULL{{/isTruthy}},
};



/* =====  end of {{@root.variant}} config ==== */
{{/each}}





const lin_config_t* g_linGlobalConfig[LIN_IFC_INST]={
{{#each this.data.ldf}}
    &{{@key}}_config,
{{/each}}
};


lin_core_state_t g_linGlobalState[LIN_IFC_INST];



void lin_config_init(void)
{
{{setVar2 'initIndex' 0~}}
{{#each this.data.ldf}}
{{setVar2 'nodeName' this.global.targetNode~}}
{{#eq this.node.master.nodeName @root.nodeName~}}
{{setVar2 'master' true~}}
{{else~}}
{{setVar2 'master' false~}}
{{/eq}}
    /* {{@key}}*/
    g_linGlobalState[{{@root.initIndex}}].dataPool = {{@key}}_data_pool;
    g_linGlobalState[{{@root.initIndex}}].signalFlagPool = {{@key}}_flag_pool;
    g_linGlobalState[{{@root.initIndex}}].frameFlagPool = {{@key}}_frame_flag_pool;
    g_linGlobalState[{{@root.initIndex}}].updateFlagPool = {{@key}}_update_pool;
{{#if @root.master}}
    g_linGlobalState[{{@root.initIndex}}].masterState = &{{@key}}_master_state;
{{#if this.global.tpEnable}}
    {{@key}}_master_state.masterTpState = &{{@key}}_master_tp_state;
{{/if}}
{{else}}
    g_linGlobalState[{{@root.initIndex}}].slaveState = &{{@key}}_slave_state;
{{/if}}
{{#if this.global.tpEnable}}
    g_linGlobalState[{{@root.initIndex}}].tpState = &{{@key}}_tp_state;
    {{@key}}_tp_state.rxQueue.items={{@key}}_tp_rx_queue;
    {{@key}}_tp_state.txQueue.items={{@key}}_tp_tx_queue;
{{/if}}
    {{setVar2 'initIndex' (add @root.initIndex 1)~}}
{{/each}}

}