/*
 * Copyright 2020-2025 Yuntu Microelectronics Co., Ltd.
 * All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 * 
 * @file lin_lib_config.c
 * @brief 
 * 
 */


#include "lin_lib_config.h"





/* =====  start of LinConfig_0 config ==== */



/* LinConfig_0 */
static const lin_signal_t LinConfig_0_signals[]={
/* Motor_Dynamic_Sig*/
    {
        .signalType=LIN_SIGNAL_TYPE_SCALAR,
        .flagBitOffset=0,
        .bufOffset=0,
        .bitLen=8,
    },
    
    };

static l_u8 LinConfig_0_data_pool[1] = {
/* Motor_Dynamic_Sig*/
    7,
};
static l_u8 LinConfig_0_flag_pool[1];
static l_u8 LinConfig_0_update_pool[1];

/* const signal config */
/* const frame config */
static const lin_frame_t LinConfig_0_frames[]={
    /* event frames for slave*/
    /* diagnostic frames for slave*/
    {
        .frameType=LIN_FRAME_TYPE_DIAG,
        .id=0x3C,
        .flagBitOffset=0,
        .bufLen=8,
        .dir=LIN_DIR_SUBSCRIBE,
        .checksumType=LIN_FRAME_CHECKSUM_CLASSIC,
        .idChangeable=l_false,
    },
    {
        .frameType=LIN_FRAME_TYPE_DIAG,
        .id=0x3D,
        .flagBitOffset=1,
        .bufLen=8,
        .dir=LIN_DIR_PUBLISH,
        .checksumType=LIN_FRAME_CHECKSUM_CLASSIC,
        .idChangeable=l_false,
    },
    };


static l_u8 LinConfig_0_frame_flag_pool[1];





static const lin_slave_config_t LinConfig_0_slave_config={
    .initNad=2,
    .configNad=2,
    .product_id={
        .supplierId=30,
        .functionId=1,
        .variant=0,
    },
    .sn={
        .serial0=0,
        .serial1=0,
        .serial2=0,
        .serial3=0,
    },
    .p2Min=100,
    .stMin=20,
    .nAsTimeout=1000,
    .nCrTimeout=1000,
};





static lin_slave_state_t LinConfig_0_slave_state;


static lin_tp_state_t LinConfig_0_tp_state;
static lin_tp_item_t LinConfig_0_tp_tx_queue[30];
static lin_tp_item_t LinConfig_0_tp_rx_queue[30];
static l_u8 LinConfig_0_id_list[1]={
    2,
};
static const lin_tp_config_t LinConfig_0_tp_config={
    .txQueueSize=30,
    .rxQueueSize=30,
    .rxMaxFrameLength=179,
    .idList=LinConfig_0_id_list,
    .idNum=1,
};

const lin_config_t LinConfig_0_config={
    .hwInst=0,
    .nodeType=LIN_NODE_SLAVE,
    .frameNum=2,
    .frameList=LinConfig_0_frames,
    .signalList=LinConfig_0_signals,
    .signalNum=1,
    .masterCfg=NULL,
    .slaveCfg=&LinConfig_0_slave_config,
    .tpCfg=&LinConfig_0_tp_config,
    .baudRate=19200,
    .maxIdleTimeoutMs=4000,
    .coreErrorCb=NULL,
};



/* =====  end of LinConfig_0 config ==== */





const lin_config_t* g_linGlobalConfig[LIN_IFC_INST]={
    &LinConfig_0_config,
};


lin_core_state_t g_linGlobalState[LIN_IFC_INST];



void lin_config_init(void)
{
    /* LinConfig_0*/
    g_linGlobalState[0].dataPool = LinConfig_0_data_pool;
    g_linGlobalState[0].signalFlagPool = LinConfig_0_flag_pool;
    g_linGlobalState[0].frameFlagPool = LinConfig_0_frame_flag_pool;
    g_linGlobalState[0].updateFlagPool = LinConfig_0_update_pool;
    g_linGlobalState[0].slaveState = &LinConfig_0_slave_state;
    g_linGlobalState[0].tpState = &LinConfig_0_tp_state;
    LinConfig_0_tp_state.rxQueue.items=LinConfig_0_tp_rx_queue;
    LinConfig_0_tp_state.txQueue.items=LinConfig_0_tp_tx_queue;
    
}