/*
 * Copyright 2020-2025 Yuntu Microelectronics Co., Ltd.
 * All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 * 
 * @file yt_linker.ld
 * @brief 
 * 
 */










 


/* MEMORY MAP */
MEMORY
{
    BOOT   (RX) : ORIGIN = 0x0, LENGTH = 0xa000
    IVT   (RX) : ORIGIN = 0xa000, LENGTH = 0xc0
    TEXT   (RX) : ORIGIN = 0xa0c0, LENGTH = 0x15c00
    IVT_RAM   (RW) : ORIGIN = 0x20000000, LENGTH = 0x400
    FBL_VAR   (RW) : ORIGIN = 0x20000400, LENGTH = 0x10
    RAM   (RW) : ORIGIN = 0x20000410, LENGTH = 0x37f0
    STACK   (RW) : ORIGIN = 0x20003c00, LENGTH = 0x400
}
/* SECTIONS */
SECTIONS
{
    .IVT  : {
        
        . = ALIGN(8);
        IVT_start = .;
        isr_vector_region_start = .;
        KEEP(*(.isr_vector))
        isr_vector_region_end = .;
        
        . = ALIGN(8);
        IVT_end = .;
    } > IVT
   
    


    .TEXT  : {
        
        TEXT_start = .;
        i_region_start = .;
        *(i)
        *(i*)
        i_region_end = .;
        
        rodata_region_start = .;
        *(.rodata)
        *(.rodata*)
        rodata_region_end = .;
        
        text_region_start = .;
        *(.text)
        *(.text*)
        text_region_end = .;
        
        . = ALIGN(8);
        TEXT_end = .;
    } > TEXT
   
    


    .ARM  : {
        
        ARM_start = .;
        ARM.exidx_region_start = .;
        *(.ARM.exidx)
        *(.ARM.exidx*)
        ARM.exidx_region_end = .;
        
        . = ALIGN(8);
        ARM_end = .;
    } > TEXT
   
    


    CODE_RAM_rom_start_not_align = .;
    CODE_RAM_rom_start = CODE_RAM_rom_start_not_align + (CODE_RAM_rom_start_not_align % 4);
   
    CODE_RAM_rom_end = CODE_RAM_rom_start + CODE_RAM_ram_end - CODE_RAM_ram_start;
    


    DATA_RAM_rom_start_not_align = CODE_RAM_rom_end;
    DATA_RAM_rom_start = DATA_RAM_rom_start_not_align + (DATA_RAM_rom_start_not_align % 4);
   
    DATA_RAM_rom_end = DATA_RAM_rom_start + DATA_RAM_ram_end - DATA_RAM_ram_start;
    


    .FBL_VAR  (NOLOAD): {
        
        . = ALIGN(8);
        FBL_VAR_start = .;
        . = ALIGN(8);
        fbl_bss_region_start = .;
        *(.fbl_bss)
        fbl_bss_region_end = .;
        
        . = ALIGN(8);
        FBL_VAR_end = .;
    } > FBL_VAR
   
    


    .IVT_RAM  : {
        
        . = ALIGN(1024);
        IVT_RAM_start = .;
        m_interrupts_ram_region_start = .;
        KEEP(*(.m_interrupts_ram))
        m_interrupts_ram_region_end = .;
        
        IVT_RAM_end = .;
    } > IVT_RAM
   
    


    .STACK  : {
        
        STACK_start = .;
        . += 1024;
        STACK_end = .;
    } > STACK
   
    


    .BSS  (NOLOAD): {
        
        . = ALIGN(8);
        BSS_start = .;
        . = ALIGN(8);
        bss_region_start = .;
        *(.bss)
        *(.bss*)
        bss_region_end = .;
        
        . = ALIGN(8);
        BSS_end = .;
    } > RAM
   
    


    .CODE_RAM  : AT(CODE_RAM_rom_start) {
        
        . = ALIGN(4);
        CODE_RAM_ram_start = .;
        CODE_RAM_start = .;
        . = ALIGN(4);
        code_ram_region_start = .;
        *(.code_ram)
        code_ram_region_end = .;
        
        . = ALIGN(4);
        CODE_RAM_end = .;
        CODE_RAM_ram_end = .;
    } > RAM
   
    
    ASSERT((CODE_RAM_ram_end - CODE_RAM_ram_start) == (CODE_RAM_rom_end - CODE_RAM_rom_start), "Copy Section CODE_RAM Size non-aligned")


    .DATA_RAM  : AT(DATA_RAM_rom_start) {
        
        . = ALIGN(4);
        DATA_RAM_ram_start = .;
        DATA_RAM_start = .;
        . = ALIGN(4);
        data_region_start = .;
        *(.data)
        *(.data*)
        data_region_end = .;
        
        . = ALIGN(4);
        DATA_RAM_end = .;
        DATA_RAM_ram_end = .;
    } > RAM
   
    
    ASSERT((DATA_RAM_ram_end - DATA_RAM_ram_start) == (DATA_RAM_rom_end - DATA_RAM_rom_start), "Copy Section DATA_RAM Size non-aligned")


    BOOT_memory_start = ORIGIN(BOOT);
    BOOT_memory_end = ORIGIN(BOOT) + LENGTH(BOOT);
    BOOT_memory_size = LENGTH(BOOT);
    IVT_memory_start = ORIGIN(IVT);
    IVT_memory_end = ORIGIN(IVT) + LENGTH(IVT);
    IVT_memory_size = LENGTH(IVT);
    TEXT_memory_start = ORIGIN(TEXT);
    TEXT_memory_end = ORIGIN(TEXT) + LENGTH(TEXT);
    TEXT_memory_size = LENGTH(TEXT);
    FBL_VAR_memory_start = ORIGIN(FBL_VAR);
    FBL_VAR_memory_end = ORIGIN(FBL_VAR) + LENGTH(FBL_VAR);
    FBL_VAR_memory_size = LENGTH(FBL_VAR);
    IVT_RAM_memory_start = ORIGIN(IVT_RAM);
    IVT_RAM_memory_end = ORIGIN(IVT_RAM) + LENGTH(IVT_RAM);
    IVT_RAM_memory_size = LENGTH(IVT_RAM);
    STACK_memory_start = ORIGIN(STACK);
    STACK_memory_end = ORIGIN(STACK) + LENGTH(STACK);
    STACK_memory_size = LENGTH(STACK);
    RAM_memory_start = ORIGIN(RAM);
    RAM_memory_end = ORIGIN(RAM) + LENGTH(RAM);
    RAM_memory_size = LENGTH(RAM);
}