/*
 * Copyright 2020-2025 Yuntu Microelectronics Co., Ltd.
 * All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 * 
 * @file lin_lib_config.h
 * @brief 
 * 
 */




#ifndef LIN_LIB_CONFIG_H_
#define LIN_LIB_CONFIG_H_

#include "lin_types.h"

#define LIN_USE_UART
#include "lin_driver.h"

#define LIN_IFC_INST 1





/*  === start of LinConfig_0 === */

#define LIN_IFC_LinConfig_0 ((l_ifc_handle)0)

/* signal handle and flag macro define */
/* Motor_Dynamic_Sig*/
#define LinConfig_0_Motor_Dynamic_Sig_signal_handle (l_signal_handle)(0<<16|0)
#define LinConfig_0_Motor_Dynamic_Sig_flag_handle (l_flag_handle)(0<<24|0)
#define l_u8_rd_LinConfig_0_Motor_Dynamic_Sig() l_u8_rd(LinConfig_0_Motor_Dynamic_Sig_signal_handle)
#define l_u8_wr_LinConfig_0_Motor_Dynamic_Sig(v) l_u8_wr(LinConfig_0_Motor_Dynamic_Sig_signal_handle,v)
#define l_flg_clr_LinConfig_0_Motor_Dynamic_Sig() l_flg_clr(LinConfig_0_Motor_Dynamic_Sig_flag_handle)
#define l_flg_tst_LinConfig_0_Motor_Dynamic_Sig() l_flg_tst(LinConfig_0_Motor_Dynamic_Sig_flag_handle) 

/* frame flag macro define */
#define LinConfig_0_master_req_flag_handle (l_flag_handle)(0<<24|1<<16|0)
 #define LinConfig_0_slave_resp_flag_handle (l_flag_handle)(0<<24|1<<16|1)
/*  === end of LinConfig_0 === */











#define LIN_HAS_SLAVE



typedef struct
{
    l_u16 ifcStatus;                /*!< interface status for l_ifc_read_status*/
    lin_frame_status_t frameStatus; /*!< frame status*/
	lin_error_t error;              /*!< last error code */
	lin_frame_sm_t frameSm;         /*!< frame state machine */
	const lin_frame_t* activeFrame; /*!< active frame */
    int frameTimeout;               /*!< timeout count */
    int idleTimeout;                /*!< idle timeout count */

#ifdef LIN_USE_UART
    uint8_t dataBuffer[8];
    uint8_t dataLength;
    uint8_t id;
    lin_event_id_t event;           /*!< lin event id */
#else
	linflexd_event_id_t event;     /*!< linflexd event id */
	linflexd_frame_t frameBuf;     /*!< frame buffer */
#endif
    
    l_u8* dataPool;                 /*!< data pool */
    l_u8* frameFlagPool;            /*!< frame flag pool */
    l_u8* signalFlagPool;           /*!< signal flag pool */
    l_u8* updateFlagPool;           /*!< update flag pool */
    
    lin_master_state_t* masterState;    /*!< master state */
    lin_slave_state_t* slaveState;      /*!< slave state */
    lin_tp_state_t* tpState;            /*!< transport layer state */
    l_bool tpInit;                  /*!< transport layer init */

#ifdef LIN_DEBUG
    l_u16 preSendCnt;
    l_u16 sendCnt;
#endif
}lin_core_state_t;


extern const lin_config_t* g_linGlobalConfig[LIN_IFC_INST];
extern lin_core_state_t g_linGlobalState[LIN_IFC_INST];

extern void lin_config_init();
#endif