/* USER CODE BEGIN Header */
/* you can remove the copyright */

/*
 *  Copyright 2020-2023 Yuntu Microelectronics co.,ltd
 *  All rights reserved.
 * 
 *  YUNTU Confidential. This software is owned or controlled by YUNTU and may only be
 *  used strictly in accordance with the applicable license terms. By expressly
 *  accepting such terms or by downloading, installing, activating and/or otherwise
 *  using the software, you are agreeing that you have read, and that you agree to
 *  comply with and are bound by, such license terms. If you do not agree to be
 *  bound by the applicable license terms, then you may not retain, install,
 *  activate or otherwise use the software. The production use license in
 *  Section 2.3 is expressly granted for this software.
 * 
 * @file main.c
 * @brief 
 * 
 */

/* USER CODE END Header */
#include "sdk_project_config.h"
/* Includes ------------------------------------------------------------------*/

/* Private includes ----------------------------------------------------------*/
/* USER CODE BEGIN Includes */
/* USER CODE END Includes */

/* Private typedef -----------------------------------------------------------*/
/* USER CODE BEGIN PTD */
/* USER CODE END PTD */

/* Private define ------------------------------------------------------------*/
/* USER CODE BEGIN PD */
#define LPTMR_INST 0

#define RUN_MODE       0
#define SLEEP_MODE     1
#define DEEPSLEEP_MODE 2
#define STANDBY_MODE   3

#define LOW_POWER_MODE STANDBY_MODE

/* USER CODE END PD */

/* Private macro -------------------------------------------------------------*/
/* USER CODE BEGIN PM */
#define SW1_PORT       (GPIOE)
#define SW1_PORT_INDEX (0U)
/* USER CODE END PM */

/* Private variables ---------------------------------------------------------*/
/* USER CODE BEGIN PV */

volatile uint32_t g_lptmrIrqCnt = 0U;
uint32_t uart_rx[10] = {0};
/* USER CODE END PV */

/* Private function declare --------------------------------------------------*/
/* USER CODE BEGIN PFDC */
/* USER CODE END PFDC */
static void Board_Init(void);

/* Private user code ---------------------------------------------------------*/
/* USER CODE BEGIN 0 */
void lpTMR0_IRQHandler(void)
{
    lpTMR_DRV_ClearCompareFlag(0);
    g_lptmrIrqCnt++;
}

void GPIOE_IRQHandler(void)
{
    if (PINS_DRV_GetPortIntFlag(SW1_PORT) & (1 << SW1_PORT_INDEX))
    {
        /* Note: Debug output inserted into interrupt routine for demo clarity. Might introduce delay. */
        PRINTF("SW1 pressed.\r\n");
        /* Clear interrupt flag.*/
        PINS_DRV_ClearPinIntFlagCmd(SW1_PORT, SW1_PORT_INDEX);
    }
}
void uart_callback(void *driverState, uart_event_t event, void *userData){
    if (event == UART_EVENT_RX_FULL)
    {
        PRINTF("UART1 RX: %s\r\n", uart_rx);
    }
    else if (event == UART_EVENT_END_TRANSFER)
    {
        UART_DRV_ReceiveData(1, (uint8_t *) &uart_rx, 1);
        // PRINTF("UART1 RX END\r\n");
    }
    else if (event == UART_EVENT_ERROR)
    {
        PRINTF("UART1 RX ERROR\r\n");
    }
}
extern void UART_DRV_IRQHandler(uint32_t instance);
void UART1_New_IRQHandler(void){
    UART_DRV_IRQHandler(1);
    if(UART1->INTE & UART_INTE_RXEDGEIE_MASK){
        UART1->INTF |= UART_INTF_RXEDGEIF_MASK;
        UART1->INTE &= ~UART_INTE_RXEDGEIE_MASK;
    }
}
/* USER CODE END 0 */


/**
 * @brief  The application entry point.
 * @retval int
 */
int main(void)
{
    /* USER CODE BEGIN 1 */
    status_t status = STATUS_SUCCESS;
    /* USER CODE END 1 */ 
    Board_Init();
    /* USER CODE BEGIN 2 */
    PRINTF("Build %s %s\n", __DATE__, __TIME__);
    PRINTF("Lowest Power Demo!\r\n");

    POWER_SYS_Init(&powerConfigsArr, POWER_MANAGER_CONFIG_CNT, NULL, POWER_MANAGER_CALLBACK_CNT);
    INT_SYS_EnableIRQ(UART1_IRQn);
    UART_DRV_InstallRxCallback(1, uart_callback, NULL);
    INT_SYS_InstallHandler(UART1_IRQn, UART1_New_IRQHandler, (isr_t *)NULL);
    UART_DRV_ReceiveData(1, (uint8_t *) &uart_rx, 1);

    /* When debugging low power mode, it is recommended to add a delay to wait to 
       prevent debugger cannot be connected as soon as the power is turned on */
    OSIF_TimeDelay(2000);

    lpTMR_DRV_StartCounter(LPTMR_INST);

    PRINTF("Wait to enter low power mode.\n");
    while (g_lptmrIrqCnt == 0)
        ;
    PRINTF("Start to enter low power mode.\n");
    // Enter into low power mode
    PRINTF("Because SIRC disable Standby/Deepsleep, it cannot wakeup by Lptmr.\r\n");
    PRINTF("Please press SW1 to wakeup device.\r\n");
    UART1->INTE |= UART_INTE_RXEDGEIE_MASK;
    POWER_SYS_SetMode(LOW_POWER_MODE, POWER_MANAGER_POLICY_AGREEMENT);
    PRINTF("Device has been waken up from standby or deepsleep mode!\n");
    /* USER CODE END 2 */

    /* Infinite loop */
    /* USER CODE BEGIN WHILE */
    while (1)
    {
        if (status != STATUS_SUCCESS)
        {
            break;
        }
        /* USER CODE END WHILE */
        /* USER CODE BEGIN 3 */
    }
    return status;
    /* USER CODE END 3 */
}

static void Board_Init(void)
{
    CLOCK_SYS_Init(g_clockManConfigsArr,CLOCK_MANAGER_CONFIG_CNT,g_clockManCallbacksArr,CLOCK_MANAGER_CALLBACK_CNT);
    CLOCK_SYS_UpdateConfiguration(CLOCK_MANAGER_ACTIVE_INDEX,CLOCK_MANAGER_POLICY_AGREEMENT);
    PINS_DRV_Init(NUM_OF_CONFIGURED_PINS0,g_pin_mux_InitConfigArr0);
    UTILITY_PRINT_Init();
    lpTMR_DRV_Init(LPTMR_INST,&LPTMR_Config,false);
    INT_SYS_ConfigInit();
}

/* USER CODE BEGIN 4 */
/* USER CODE END 4 */
