# Flexcan Example Code

## Project Name: Flexcan


---


## Function description

The application is a demonstration of the use of the Flexcan on the YTM32B1MD1 FlexCAN0 channel.
- **Flexcan**: 
  - Use **TX_MAILBOX** defined mailbox number(mailbox-1) to send a standard frame message with id = **TX_MSG_ID**(0x003) every 100ms.
  - Use **RX_STD_MAILBOX** defined mailbox number(mailbox-0) to receive a message id = **RX_STD_MSG_ID**(0x002), once received the message the LED0 will be toggled
  - Use **RX_EXT_MAILBOX** defined mailbox number(mailbox-2) to receive a message id = **RX_EXTMSG_ID**(0x70012), once received the message the LED0 will be toggled
  - Baud rate(nominal) is 500Kbps
  - Each match id message received will be print via UART
  - If received message count up to 10, the whole demo routine will be stopped

---


## HW requirement
+ **EVB**: YTM32B1MD1-EVB-Q100
+ **Debugger**: J-LINK v9.2 or later with YUNTU YTM32B1MD1 patch(support package) installed.
+ **Connect**: 
  - UART via on board UART-USB converter
  - J11: connect PIN1 to PIN2(Can_SLEEP_EN)
  - J11: connect PIN3 to PIN4(Can_Txd0)
  - J11: connect PIN5 to PIN6(Can_Rxd0)
  - Connect CAN tool CANH&CANL line to board CAN0 chananel CANH&CANL(CAN2 in evb)

---

## SW requirement

+ **Config & Code Generation Tool**
  + **SDK**:       Yuntu Config Tool(YCT) v2.4.0 or later version
+ **Compiler Toolchain**
  + **GCC***     : GNU GCC v10.3 or later version
  + **Keil/MDK***: ARM Keil/MDK v5.35 or later version
  + **IAR***     : IAR v8.4 or later version
  + **VS Code**  : Microsoft Visual Studio Code IDE v1.76 or later version(C/C++ support, GNU toolchain, CMake v3.25, ninja, Cortex-Debug extensions installation required)
+ **Debugger driver**
    + **J-LINK***              : SEGGER JLINK v6.96 or later version, YUNTU YTM32B1MD1 patch(support package) installation required.
    + **Ozone Debugger tool**  : SEGGER Ozone v3.28 or later version.

    ***Note***: * **YTM32B1MD1** patch install required which can be obtained via **YCT** or contact ***YUNTU sales/FAE team***.

---

## Setup

+ ***Step1***: Open the project.yct with the YCT tool, config the toolchain per your required(by default, the VS code + GCC are used)
+ ***Step2***: Generate the codes, you can change the configurations if needed(to adapt to your own HW design), if so, please ensure all the modifications are OK with no any errors exist before generating the code.
+ ***Step3***: Open the generated project with VS code/IAR/Keil IDE per your selected.
+ ***Step4***: Compile the project, power on the EVB and download it to the EVB via the available debugger, such as a J-LINK debugger probe.
+ ***Step5***: At last, enjoy the demo example.
  
---

