/*
 * Copyright 2020-2025 Yuntu Microelectronics co.,ltd
 * All rights reserved.
 *
 * YUNTU Confidential. This software is owned or controlled by YUNTU and may
 * only be used strictly in accordance with the applicable license terms. By expressly
 * accepting such terms or by downloading, installing, activating and/or otherwise
 * using the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software. The production use license in
 * Section 2.3 is expressly granted for this software.
 */
/*!
 * @file flash_ecc_fault.h
 *
 */

#ifndef FLASH_ECC_FAULT_H
#define FLASH_ECC_FAULT_H

#include <stdbool.h>
#include <stddef.h>
#include "status.h"
#include "device_registers.h"


/*******************************************************************************
* Function Prototypes for Flash ECC Fault
*******************************************************************************/
/*!
 * @name Flash ECC Fault APIs
 * @{
 */

#if defined(__cplusplus)
extern "C" {
#endif

/*!
 * @brief Install the ECC fault handler for Bus Fault or Hard Fault.
 *
 * This function installs the ECC fault handler for Bus Fault or Hard Fault.
 *
 */
void FLASH_DRV_ECC_Fault_Install(void);

#if defined(__cplusplus)
}
#endif

/*@}*/ /* End of Flash driver APIs*/
/*! @}*/ /* End of addtogroup flash_driver */

#endif /* FLASH_ECC_FAULT_H */