/***********************************************************************************************************************
                                    Copyright (C), 2006-2023, NAEN Auto Tech. Co., Ltd.
 *  --------------------------------------------------------------------------------------------------------------------
 *  File Description
 *  ------------------------------------------------------------------------------------------------------------------*/
/** \file     Wdg.c
 *  \brief    This is the code comment template for GAC_YX2_PTU_App
***********************************************************************************************************************/


/***********************************************************************************************************************
                                            Include Files
***********************************************************************************************************************/
#include "DrvWdg.h"

/***********************************************************************************************************************
                                            Local Macros
***********************************************************************************************************************/


/***********************************************************************************************************************
                                        Local Structure&Union&Enumerate Declarations
***********************************************************************************************************************/


/***********************************************************************************************************************
                                        Static Variable Definitions
***********************************************************************************************************************/
//static void Wdg_DelayUs(UINT16 uwDelay);
/***********************************************************************************************************************
                                        Local Function Declarations
***********************************************************************************************************************/
/*************************************************************************************************************
* Function Name  : Wdg_DelayUs
* Description    : delay n us(Core clock = 64M)
* Input          : INT16 uwDelay
* Output         : None
* Return         : None
*************************************************************************************************************/
#if 0
#pragma optimize=none
static void Wdg_DelayUs(UINT16 delay)
{
    UINT16 realloop;
    UINT16 outerloop;

    /*Calibration for the timing*/
    if(delay < WDG_CPU_DELAY)
    {
        realloop = delay*6/10;
    }
   else
    {
        realloop = delay;
    }

    
    for(outerloop = 0; outerloop < realloop; outerloop++)
    {
       __NOP();
       __NOP();
       __NOP();
       __NOP();
       __NOP();
       
       __NOP();
       __NOP();
       __NOP();
       __NOP();
       __NOP();
       
       __NOP();
       __NOP();
       __NOP();
       __NOP();
       __NOP();
       
//       __NOP();
//       __NOP();
//       __NOP();
//       __NOP();
//       __NOP();
//       
//       __NOP();
//       __NOP();
//       __NOP();
//       __NOP();
//       __NOP();
//       
//       __NOP();
//       __NOP();
//       __NOP();
//       __NOP();
//       __NOP();
    }
}
#endif
/***********************************************************************************************************************
                                        External Function Definitions
***********************************************************************************************************************/
/*************************************************************************************************************
* Function Name  : Wdg_Feed
* Description    : Function to Feed WatchDog 
*                  FREQS：H (low frequency oscillator)
*                  WTS：L (window模式)
*                  看门狗窗口的持续时间为250ms(OW:CW=8:1 10%)
*                  RUN模式喂狗周期：100ms
*                  Polling时喂狗周期：100ms
* Input          : None
* Output         : None
* Return         : None
*************************************************************************************************************/

/*************************************************************************************************************
* Function Name  : Wdg_EcuSystemReset
* Description    : Function to external watchdog Reset.
* Input          : None
* Output         : None
* Return         : None
*************************************************************************************************************/
#if 0
extern void Wdg_EcuSystemReset(void)
{
    Dio_WriteChannel(DioConf_DioChannel_WD_DO_MCU, LOW);
    /*** 278us ***/
    Wdg_DelayUs(260);
    Dio_WriteChannel(DioConf_DioChannel_WD_DO_MCU, HIGH);
    /*** Watchdog service-signal duration: min 100us ***/
    Wdg_DelayUs(260);
    Dio_WriteChannel(DioConf_DioChannel_WD_DO_MCU, LOW);

    Wdg_DelayUs(260);

    Dio_WriteChannel(DioConf_DioChannel_WD_DO_MCU, HIGH);
    /*** Watchdog service-signal duration: min 100us ***/
    Wdg_DelayUs(260);
    Dio_WriteChannel(DioConf_DioChannel_WD_DO_MCU, LOW);
}
#endif
/***********************************************************************************************************************
                                        End Of File
***********************************************************************************************************************/
