/***********************************************************************************************************************
                                    Copyright (C), 2006-2023, NAEN Auto Tech. Co., Ltd.
 *  --------------------------------------------------------------------------------------------------------------------
 *  File Description
 *  ------------------------------------------------------------------------------------------------------------------*/
/** \file     DrvGpt.h
 *  \brief    The NaEnTemplate module head file for 
***********************************************************************************************************************/

#ifndef DRV_GPT_H
#define DRV_GPT_H

/***********************************************************************************************************************
                                             Include Files
***********************************************************************************************************************/
#include "Drv.h"

/***********************************************************************************************************************
                                                Macros
***********************************************************************************************************************/
#define  GPT_LPTMR_INIT_VAL         (12800u)

/***********************************************************************************************************************
                                      Structure&Union&Enumerate Declarations
***********************************************************************************************************************/
typedef struct
{
    UINT32 udwPtmrCh2StartValue;
    UINT32 udwPtmrCh2EndValue;
    UINT32 udwPtmrCh2CalibValue;
}ST_GPT_PTMR_CALIBRATION;

/***********************************************************************************************************************
                                       Extern Function Declarations 
***********************************************************************************************************************/
extern void DrvGpt_TimerStartup(void);
extern void DrvGpt_StartMcuPolling(void);
extern void GptSleepHandle(void);


/***********************************************************************************************************************
                                               End Of File
***********************************************************************************************************************/
#endif /***DRV_GPT_H***/
