/***********************************************************************************************************************
                                    Copyright (C), 2006-2023, NAEN Auto Tech. Co., Ltd.
 *  --------------------------------------------------------------------------------------------------------------------
 *  File Description
 *  ------------------------------------------------------------------------------------------------------------------*/
/** \file     DrvGpt.c
 *  \brief    This is the code comment template for 
***********************************************************************************************************************/


/***********************************************************************************************************************
                                            Include Files
***********************************************************************************************************************/
#include "DrvGpt.h"

/***********************************************************************************************************************
                                            Local Macros
***********************************************************************************************************************/
#define NOP()             __asm volatile ("nop")

static ST_GPT_PTMR_CALIBRATION gstGptPtmrCalib;
static UINT8 GptSleepFlag = 0u;


/***********************************************************************************************************************
                                        Local Structure&Union&Enumerate Declarations
***********************************************************************************************************************/


/***********************************************************************************************************************
                                        GPT Discharge use
***********************************************************************************************************************/


/***********************************************************************************************************************
                                        Static Variable Definitions
***********************************************************************************************************************/


/***********************************************************************************************************************
                                        Local Function Declarations
***********************************************************************************************************************/

/***********************************************************************************************************************
                                        External Function Definitions
***********************************************************************************************************************/
#pragma optimize=none
void GptDelay_In_Us(UINT16 delay)
{
    UINT16 realloop;
    UINT16 outerloop;

    /*Calibration for the timing*/
    if(delay < 10)
    {
        realloop = delay*6/10;
    }
    else
    {
        realloop = delay;
    }


    for(outerloop = 0; outerloop < realloop; outerloop++)
    {
        NOP();
        NOP();
        NOP();
        NOP();
        NOP();

        NOP();
        NOP();
        NOP();
        NOP();
        NOP();

        NOP();
        NOP();
        NOP();
        NOP();
        NOP();
        
        NOP();
        NOP();
        NOP();
        NOP();
        NOP();

        NOP();
        NOP();
        NOP();
        NOP();
        NOP();

        NOP();
        NOP();
        NOP();
        NOP();
        NOP();
        
        NOP();
        NOP();
        NOP();
        NOP();
        NOP();
        
        NOP();
        NOP();
        NOP();
        NOP();
        NOP();
    }

}


/*************************************************************************************************************
* Function Name  : Gpt_pTMRNotification_Normal
* Description    : pTMR Notification to Normal Mode
* Input          : None
* Output         : None
* Return         : None
*************************************************************************************************************/
void DrvGpt_pTMRCh0NotificationOS(void)
{
    Dio_WriteChannel(DioConf_DioChannel_WD_DO_MCU, 1);
    //OsSysTick();
    GptDelay_In_Us(150);
    Wdg_180_Inst0_Service();
    Dio_WriteChannel(DioConf_DioChannel_WD_DO_MCU, 0);
}

/*************************************************************************************************************
* Function Name  : DrvGpt_pTMRCh1NotificationTimeStamp
* Description    : pTMR Notification to TimeStamp timeout val
* Input          : None
* Output         : None
* Return         : None
*************************************************************************************************************/
void DrvGpt_pTMRCh1NotificationTimeStamp(void)
{

}

/*************************************************************************************************************
* Function Name  : Gpt_pTMRNotification_Calibration
* Description    : pTMR Notification to Calib
* Input          : None
* Output         : None
* Return         : None
*************************************************************************************************************/
void DrvGpt_pTMRCh2NotificationCalibration(void)
{
    gstGptPtmrCalib.udwPtmrCh2EndValue = Gpt_GetTimeElapsed(GptConf_GptChannelConfiguration_LPTMR_POLLING);
    Gpt_StopTimer(GptConf_GptChannelConfiguration_PTMR_CH2_Calibration);
    Gpt_DisableNotification(GptConf_GptChannelConfiguration_PTMR_CH2_Calibration);
    if(gstGptPtmrCalib.udwPtmrCh2EndValue > gstGptPtmrCalib.udwPtmrCh2StartValue)
    {
        gstGptPtmrCalib.udwPtmrCh2CalibValue = gstGptPtmrCalib.udwPtmrCh2EndValue - gstGptPtmrCalib.udwPtmrCh2StartValue;
    }
    else if(gstGptPtmrCalib.udwPtmrCh2EndValue < gstGptPtmrCalib.udwPtmrCh2StartValue)
    {
        gstGptPtmrCalib.udwPtmrCh2CalibValue = GPT_LPTMR_INIT_VAL - gstGptPtmrCalib.udwPtmrCh2StartValue + gstGptPtmrCalib.udwPtmrCh2EndValue;
    }
    else
    {}
    Gpt_StopTimer(GptConf_GptChannelConfiguration_LPTMR_POLLING);
    Gpt_DisableNotification(GptConf_GptChannelConfiguration_LPTMR_POLLING);
	GptSleepFlag=1;
}
void GptSleepHandle(void)
{
    if(1 == GptSleepFlag)
    {
       GptSleepFlag=0;
	   DrvGpt_StartMcuPolling();
	    do
        {
        //Wdg_180_Inst0_Service();
        /*** #1 Set the McuMode for the current sleep phase, in this function call the Ecu is not executing code any more. ***/
        /*** #2 After an occurred Interrupt the Mcu starts again and control goes back to the EcuM. ***/
		//Wdg_180_Inst0_Service();
        Mcu_SetMode(McuConf_McuModeSettingConf_STANDBY);
        //Wdg_180_Inst0_Service();
        /*** #3 Do a global restore to be in a defined status after Mcu_SetMode. ***/
        //EcuM_GlobalRestore();

        /*** #4 GlobalSuspend is needed for the new call of Mcu_SetMode. It is called at this place to do not miss any wakeup events. ***/
        //EcuM_GlobalSuspend();

        /*** #5 If no pending or validated wakeup is stored, the EcuM transits back to sleep again. ***/
        }
        while (1);
    }
}
void DrvRfReceive_ISR(void)
{



}


/*************************************************************************************************************
* Function Name  : Gpt_lpTMRNotification_Standby
* Description    : lpTMR Notification to Polling
* Input          : None
* Output         : None
* Return         : None
*************************************************************************************************************/
void DrvGpt_lpTMRNotificationPolling(void)
{
    Dio_WriteChannel(DioConf_DioChannel_WD_DO_MCU, 1);
    Dio_WriteChannel(DioConf_DioChannel_DIAG_EN, 1);/*SGHA_RFR_ONES_67616*/
    Mcu_InitClock(McuClockSettingConfig_Polling);
    //EcuM_CheckWakeup(ECUM_WKSOURCE_ECUM_WKSORCE_GPT);
	
	Wdg_180_Inst0_Service();
	//Gpt_StopTimer(GptConf_GptChannelConfiguration_LPTMR_POLLING);
    Dio_WriteChannel(DioConf_DioChannel_DIAG_EN, 0);
    Dio_WriteChannel(DioConf_DioChannel_WD_DO_MCU, 0);
}

/*************************************************************************************************************
* Function Name  : Gpt_TimerStartup
* Description    : init all timer get ptmr start value
* Input          : None
* Output         : None
* Return         : None
*************************************************************************************************************/
void DrvGpt_TimerStartup(void)
{
    Gpt_StartTimer(GptConf_GptChannelConfiguration_PTMR_CH0_OS, 400000);              /*** 40ms ***/
    Gpt_EnableNotification(GptConf_GptChannelConfiguration_PTMR_CH0_OS);

    Gpt_StartTimer(GptConf_GptChannelConfiguration_PTMR_CH1_TimeStamp, 0xFFFFFFFF);       /*** 7min ***/
    Gpt_EnableNotification(GptConf_GptChannelConfiguration_PTMR_CH1_TimeStamp);

    Gpt_StartTimer(GptConf_GptChannelConfiguration_PTMR_CH2_Calibration, 5000000);       /*** 500ms ***/
    Gpt_EnableNotification(GptConf_GptChannelConfiguration_PTMR_CH2_Calibration);

    Gpt_StartTimer(GptConf_GptChannelConfiguration_LPTMR_POLLING, 64000);     /*** 64000 / 32000 = 2s ***/
    Gpt_DisableNotification(GptConf_GptChannelConfiguration_LPTMR_POLLING);
    gstGptPtmrCalib.udwPtmrCh2StartValue = Gpt_GetTimeElapsed(GptConf_GptChannelConfiguration_LPTMR_POLLING);

}

/*************************************************************************************************************
* Function Name: Gpt_StartMcuPolling
* Description  : Before sleep GPT Wake up IRQ enable config  50%
* Input        : None
* Output       : None
* Return       : None
*************************************************************************************************************/
extern void DrvGpt_StartMcuPolling(void)
{
    Gpt_StopTimer(GptConf_GptChannelConfiguration_PTMR_CH0_OS);
    Gpt_StopTimer(GptConf_GptChannelConfiguration_PTMR_CH1_TimeStamp);
    
    Gpt_StopTimer(GptConf_GptChannelConfiguration_PTMR_CH2_Calibration);
    Gpt_DisableNotification(GptConf_GptChannelConfiguration_PTMR_CH2_Calibration);
    Gpt_StopTimer(GptConf_GptChannelConfiguration_LPTMR_POLLING);
    Gpt_DisableNotification(GptConf_GptChannelConfiguration_LPTMR_POLLING);
    if(gstGptPtmrCalib.udwPtmrCh2CalibValue >= 24000)
    {
        Gpt_StartTimer(GptConf_GptChannelConfiguration_LPTMR_POLLING, 24000 / 5);//100ms
        Gpt_EnableNotification(GptConf_GptChannelConfiguration_LPTMR_POLLING);
    }
    else if(gstGptPtmrCalib.udwPtmrCh2CalibValue <= 8000)
    {
        Gpt_StartTimer(GptConf_GptChannelConfiguration_LPTMR_POLLING, 8000 / 5);//100ms
        Gpt_EnableNotification(GptConf_GptChannelConfiguration_LPTMR_POLLING);
    }
    else
    {
        Gpt_StartTimer(GptConf_GptChannelConfiguration_LPTMR_POLLING, gstGptPtmrCalib.udwPtmrCh2CalibValue / 5);//100ms
        Gpt_EnableNotification(GptConf_GptChannelConfiguration_LPTMR_POLLING);
    }
}



/***********************************************************************************************************************
                                        End Of File
***********************************************************************************************************************/
