/******************************************************************************
*
*       Copyright (C) 2010 NAEN, Inc.
*       All Rights Reserved
*
* Filename:     $ TYPEDEF.h $
* Author:       $ James Lu $
* Locker:       $$
* State:        $$
* Revision:     $$
*
* Functions:    C Type Define
*
* History:
*
* Description:
*
* Notes:
*
******************************************************************************/

#ifndef __TYPEDEF_H__
#define __TYPEDEF_H__

//#pragma MESSAGE DISABLE C4200 
#include "Platform_Types.h"
#include <stdint.h>

//Type definition
typedef signed char        INT8;
typedef unsigned char    UINT8;
typedef signed short    INT16;    //typedef signed int        INT16;
typedef unsigned short  UINT16;   //typedef unsigned int    UINT16;
typedef signed long        INT32;
typedef unsigned long    UINT32;
typedef signed long        INT64[2];
typedef unsigned long    UINT64[2];

//typedef unsigned long    uint32_t;

#define S08    INT8
#define U08    UINT8
#define S16    INT16
#define U16    UINT16
#define S32 INT32
#define U32 UINT32

#define uint8_t   UINT8
#define uint16_t  UINT16

/* define in <stdtypes.h>
#define uchar    UINT8
#define uint    UINT16
#define ulong    UINT32
#define udlong    UINT64
#define dlong   INT64
*/
#define UCHAR    UINT8
#define UINT    UINT16
#define ULONG    UINT32
#define UDLONG    UINT64
#define DLONG   INT64

#define PTR_ZERO    (void *)0

/* define in <stdtypes.h>
#define byte    UINT8
#define word    UINT16
#define dword    UINT32
*/
#ifndef BYTE
#define BYTE    UINT8
#define WORD    UINT16
#define DWORD    UINT32
#endif


#ifndef BOOL
typedef INT8 BOOL;
//typedef unsigned char BOOL;
//typedef enum {TRUE, FALSE} BOOL;
#endif

#define STATUS    INT8


//Define
#define FOREVER        for(;;)

#ifndef NULL
#define NULL        ((void *)0)
#endif

#ifndef FALSE
#define TRUE        (1)
#define FALSE        (0)
#endif

#ifndef ERROR
#define OK            (0)
#define ERROR        (-1)
#endif

#ifndef ON
#define ON          1
#define OFF         0
#endif

#ifndef YES
#define YES         1
#define NO          0
#endif

#define ONE                 1
#define ZERO                0

//#ifndef SET
//#define SET                 ONE
//#endif

//#ifndef RESET
//#define RESET               ZERO
//#endif

#ifndef ENABLED
#define ENABLED             ONE
#endif

#ifndef DISABLED
#define DISABLED            ZERO
#endif

#define OS_ENABLED          ENABLED
#define OS_DISABLED         DISABLED


#define VECTOR_F    (void(*const)(void))
#define VECTOR_NULL    (VECTOR_F(0xffff))


#ifndef _BIT0
#define _BIT0        (0x01)
#define _BIT1        (0x02)
#define _BIT2        (0x04)
#define _BIT3        (0x08)
#define _BIT4        (0x10)
#define _BIT5        (0x20)
#define _BIT6        (0x40)
#define _BIT7        (0x80)
#define _BIT8        (0x0100)
#define _BIT9        (0x0200)
#define _BITA        (0x0400)
#define _BITB        (0x0800)
#define _BITC        (0x1000)
#define _BITD        (0x2000)
#define _BITE        (0x4000)
#define _BITF        (0x8000)
#endif

#ifndef HIGH
#define HIGH        1
#define LOW            0
#endif

#ifndef NULL_PTR
#define NULL_PTR            (void *)ZERO
#endif

#ifndef NULL
#define NULL                ZERO
#endif


/* Return errors */
#define ERR_OK           0u             /* OK */
#define ERR_ERROR        1             /* ERROR */
#define ERR_RANGE        2             /* Parameter out of range. */
#define ERR_VALUE        3             /* Parameter of incorrect value. */
#define ERR_OVERFLOW     4             /* Timer overflow. */
#define ERR_MATH         5             /* Overflow during evaluation. */
#define ERR_ENABLED      6             /* Device is enabled. */
#define ERR_DISABLED     7             /* Device is disabled. */
#define ERR_BUSY         8             /* Device is busy. */
#define ERR_NOTAVAIL     9             /* Requested value or method not available. */
#define ERR_RXEMPTY      10            /* No data in receiver. */
#define ERR_TXFULL       11            /* Transmitter is full. */
#define ERR_BUSOFF       12            /* Bus not available. */
#define ERR_OVERRUN      13            /* Overrun error is detected. */
#define ERR_FRAMING      14            /* Framing error is detected. */
#define ERR_PARITY       15            /* Parity error is detected. */
#define ERR_NOISE        16            /* Noise error is detected. */
#define ERR_IDLE         17            /* Idle error is detected. */
#define ERR_FAULT        18            /* Fault error is detected. */
#define ERR_BREAK        19            /* Break char is received during communication. */
#define ERR_CRC          20            /* CRC error is detected. */
#define ERR_ARBITR       21            /* A node losts arbitration. This error occurs if two nodes start transmission at the same time. */
#define ERR_PROTECT      22            /* Protection error is detected. */
#define ERR_UNDERFLOW    23            /* Underflow error is detected. */
#define ERR_UNDERRUN     24            /* Underrun error is detected. */
#define ERR_COMMON       25            /* Common error of a device. */
#define ERR_LINSYNC      26            /* LIN synchronization error is detected. */


#define glue(x, y)            x##y
#define xglue(x, y)            glue(x, y)


/* Macros for inversion */
#define INVERT_BYTE         (UINT8)0xFFu
#define INVERT_WORD         (UINT16)0xFFFFu
#define INVERT_LWORD        (UINT32)0xFFFFFFFFul

#define INV_BYTE(Value)  ((Value)^INVERT_BYTE)
#define INV_WORD(Value)  ((Value)^INVERT_WORD)
#define INV_LWORD(Value) ((Value)^INVERT_LWORD)

//#pragma MESSAGE DISABLE C1420 /* WARNING C1420: Result of function-call is ignored */
//#pragma MESSAGE DISABLE C5905 /* WARNING C5905: Multiplication with one is ignored */
//#pragma MESSAGE DISABLE C1106 /* WARNING C1106: Non-standard bitfield type */
//#pragma MESSAGE DISABLE C12056  
//#pragma MESSAGE DISABLE C5660 /*WARNING C5660:Remove dead code*/
//#pragma MESSAGE DISABLE C5917 /* WARNING C5917: Remove dead assignment */

#endif
