/*
* @file    SchM_Fls.h
*==================================================================================================
*   Project              : YTMicro AUTOSAR 4.4.0 MCAL
*   Platform             : ARM
*   Peripheral           : SchM_Fls
*   Dependencies         : none
*
*   Autosar Version      : V4.4.0
*   Autosar Revision     : ASR_REL_4_4_REV_0000
*   SW Version           : V1.0.0
*
*   (c) Copyright 2020-2023 Yuntu Microelectronics co.,ltd.
*   All Rights Reserved.
==================================================================================================*/

#ifndef SCHM_FLS_H
#define SCHM_FLS_H

/**
*   @file    SchM_Fls.h
*
*   @addtogroup SCHM_FLS_MODULE
*   @{
*/

#ifdef __cplusplus
extern "C" {
#endif

/* PRQA S 0777,0779 EOF */
/*==================================================================================================
                                              INCLUDE FILES                                          
==================================================================================================*/
/*==================================================================================================
                                      HEADER FILE VERSION INFORMATION                                
==================================================================================================*/
#define SCHM_FLS_VENDOR_ID                      (180)
#define SCHM_FLS_AR_RELEASE_MAJOR_VERSION       (4)
#define SCHM_FLS_AR_RELEASE_MINOR_VERSION       (4)
#define SCHM_FLS_AR_RELEASE_REVISION_VERSION    (0)
#define SCHM_FLS_SW_MAJOR_VERSION               (1)
#define SCHM_FLS_SW_MINOR_VERSION               (0)
#define SCHM_FLS_SW_PATCH_VERSION               (0)
/*==================================================================================================
                                                DEFINES AND MACROS                                       
==================================================================================================*/

/* Number of cores id */
#ifndef NUMBER_OF_CORES
#define NUMBER_OF_CORES         (uint8)(1U)
#endif /* NUMBER_OF_CORES */

/*==================================================================================================
                                                EXTERNAL CONSTANTS                                        
==================================================================================================*/
/*==================================================================================================
                                                ENUMS                                        
==================================================================================================*/
/*==================================================================================================
                                                FUNCTION PROTOTYPES                                           
==================================================================================================*/

extern void SchM_Enter_Fls_FLS_EXCLUSIVE_AREA_00(void);
extern void SchM_Exit_Fls_FLS_EXCLUSIVE_AREA_00(void);

extern void SchM_Enter_Fls_FLS_EXCLUSIVE_AREA_01(void);
extern void SchM_Exit_Fls_FLS_EXCLUSIVE_AREA_01(void);

extern void SchM_Enter_Fls_FLS_EXCLUSIVE_AREA_02(void);
extern void SchM_Exit_Fls_FLS_EXCLUSIVE_AREA_02(void);

extern void SchM_Enter_Fls_FLS_EXCLUSIVE_AREA_03(void);
extern void SchM_Exit_Fls_FLS_EXCLUSIVE_AREA_03(void);

extern void SchM_Enter_Fls_FLS_EXCLUSIVE_AREA_04(void);
extern void SchM_Exit_Fls_FLS_EXCLUSIVE_AREA_04(void);

extern void SchM_Enter_Fls_FLS_EXCLUSIVE_AREA_05(void);
extern void SchM_Exit_Fls_FLS_EXCLUSIVE_AREA_05(void);

extern void SchM_Enter_Fls_FLS_EXCLUSIVE_AREA_06(void);
extern void SchM_Exit_Fls_FLS_EXCLUSIVE_AREA_06(void);

extern void SchM_Enter_Fls_FLS_EXCLUSIVE_AREA_07(void);
extern void SchM_Exit_Fls_FLS_EXCLUSIVE_AREA_07(void);
#ifdef __cplusplus
}
#endif

/** @} */

#endif /* End of file SchM_Fls.h */

