/***********************************************************************************************************************
                                    Copyright (C), 2006-2023, NAEN Auto Tech. Co., Ltd.
 *  --------------------------------------------------------------------------------------------------------------------
 *  File Description
 *  ------------------------------------------------------------------------------------------------------------------*/
/** \file     OsUserConfig.h
 *  \brief    The OsUserConfig module head file for TATA_SCM_App
 *  \Author   NAEN-RDS:R515
 *  \Version  Description
 *            0.1.0      Initial version
 *            0.2.0      Modify all OS function names to remove the prefix Org
 *  --------------------------------------------------------------------------------------------------------------------
 *  Modification Type:
 *  a.  Add
 *  b.  Remove
 *  c.  Recover
 *  d.  Change
 *  --------------------------------------------------------------------------------------------------------------------
 *  File Detail Modify History
 *  --------------------------------------------------------------------------------------------------------------------
 *  ModifyType    Date          Author  RegCodeID                   Description
 *  --------------------------------------------------------------------------------------------------------------------
 *  Add           06/29/2022    R515    MARK_OSUSERCONFIG_H00001    Add com manage task id
 *  Recover       11/29/2023    R515    MARK_OSUSERCONFIG_H00002    Recover global interrupt
***********************************************************************************************************************/

#ifndef _ORGOSCONFIG_H_
#define _ORGOSCONFIG_H_

/***********************************************************************************************************************
                                          Header File Includes
************************************************************************************************************************/
#include "Header.h"

//#include "AppDebug.h"

/***********************************************************************************************************************
                                                Macros
************************************************************************************************************************/
/*systrm globle basic configration*/
#define MCU_CLOCK_HZ     
#define OS_TIMER_TICK  (8)      //1 //8 OS ticks

/* CPU related */
#define OsGlobalIntEnable()     //__asm("cpsie i") // Enable global interrupt /***MARK_OSUSERCONFIG_H00002***/
#define OsGlobalIntDisable()    //__asm("cpsid i") // Disable global interrupt

#define EndlessLoop()           for(;;)

/*DT_ZT_L10_SW051*/
#ifdef PRINT_DEBUG
#define PRINTF                  TracePrint
#define PRINTF2                 TracePrint
#define PRINTF3                 TracePrint
#define PRINTF4                 TracePrint
#else
#define PRINTF(a)
#define PRINTF2(a,b)
#define PRINTF3(a,b,c)
#define PRINTF4(a,b,c,d)   
#endif

#define TASK_0MS                   1u
#define TASK_1MS                   1u
#define TASK_2MS                   2u
#define TASK_3MS                   3u
#define TASK_4MS                   4u
#define TASK_5MS                   5u
#define TASK_10MS                 10u
#define TASK_20MS                 20u
#define TASK_40MS                 40u
#define TASK_50MS                 50u
#define TASK_80MS                 80u

/***********************************************************************************************************************
                                      Structure&Enumerate Declarations
************************************************************************************************************************/
//**********************************Define your task Timer ID here********************************************
typedef enum{
    TIMER_2MS_ID_START,
    TIMER_PDU_IGN1_PWM,
    TIMER_2MS_ID_END,
    
    TIMER_10MS_ID_START,
    TIMER_ORG_ECUM_10MS,
    TIMER_ORG_RF_10MS,    
    TIMER_FOBS_LF_TIMEOUT,
    TIMER_BOOT_START,
    TIMER_10MS_ID_END,
    TIMER_ID_NUM
}TIMER_ID;
//**********************************Define your task ID here *************************************************
typedef enum{
    TASK_ID_FLS,                /*MARK_OSUSERCONFIG_H00001*/
    TASK_ID_FEE,                /*MARK_OSUSERCONFIG_H00001*/
    TASK_ID_NVM,                /*MARK_OSUSERCONFIG_H00001*/
   // TASK_ID_COM_MANAGE,                /*MARK_OSUSERCONFIG_H00001*/
    TASK_ID_CDD_RF,
    TASK_ID_CDD_ADC,
    TASK_ID_APP_RFR,
    TASK_ID_APP_WDT,
    TASK_ID_APP_PWR,
    TASK_ID_APP_BMS,
    //TASK_ID_APP_DIAG_SA,
    TASK_ID_APP_CONFIG,
    //TASK_ID_LEGACY_ECU,
#ifdef PRINT_DEBUG
    //TASK_ID_APP_DEBUG,
#endif  
    TASK_ID_NUM
}TASK_ID;
//**********************************Define your back up ram *************************************************
typedef enum
{
    BACKUP_RAM_TAG_IDE = 0,
    BACKUP_RAM_TAG_WAKE_ID,
    BACKUP_RAM_TAG_RSK,
    BACKUP_RAM_TAG_ISK,
    SYSTEM_WAKEUP_SRC,
    //TASK_ID_APP_RFR,
    BACKUP_RAM_SECTION_NUM
    
}BACKUP_RAM_SECTION;

/***********************************************************************************************************************
                                        Extern Function Declarations 
************************************************************************************************************************/
/*System Tick interrupt function call by ISR*/
extern void OsSysTick(void);

/*System Os random data get.*/
extern UINT32 OsRand(void); 

/*System Task Schedule Control function.*/
extern UINT32 OsGetSysTick(void);
extern void OsScheduleLock(void);
extern void OsScheduleUnlock(void);
extern BOOL OsScheduleIsLocked(void);

/*Message and Event interface function.*/
extern void OsSendMessage(UINT8 taskId, UINT8 * data);
extern void OsEventPost(UINT8 taskId, UINT16 event);
extern BOOL OsEventPend(UINT8 taskId);

/*System Timer Opteration interface function.*/
extern void OsTimerStart(UINT8 ucTid, UINT16 ulTimerLen);
extern void OsTimerStop(UINT8 ucTid);
extern BOOL OsTimeOutJudge(UINT8 ucTid);
extern void OsCallBackTimerReg(UINT8 ucTid, UINT8 ucType, UINT16 ulTimerLen,void (*Callback)(void));
extern void OsNotifyTimerReg(UINT8 ucTid, UINT8 ucType,UINT16 ulTimerLen,UINT8 TaskID,UINT16 EventID);

/*Module Local Timer Opteration interface function.*/
extern void LocalTimerRefesh(LOCAL_TIMER sTimer);
extern void LocalTimerStart(LOCAL_TIMER sTimer,UINT8 timer_id, UINT16 DeleyTick);/*GA_A06_PEPS_170*/
extern void LocalTimerStop(LOCAL_TIMER sTimer,UINT8 timer_id);
extern UINT8 LocalTimerCheck(LOCAL_TIMER sTimer,UINT8 timer_id);

/*System Safty Ram interface function.*/
extern BOOL OsBackUpRamRead(BACKUP_RAM_SECTION SectionNum, UINT8 *DataBuf, UINT8 DataLen);
extern BOOL OsBackUpRamWrite(BACKUP_RAM_SECTION SectionNum, UINT8 *DataBuf, UINT8 DataLen);

/*Os Test Functions Just for debug.*/
extern void OsSetMonitTask(UINT8 taskId);

/*Os EEP Task Run.*/
extern UINT8 OsEepTaskRunCheck(void);
extern void OsEepTaskRunClear(void);

/***********************************************************************************************************************
                                               End Of File
************************************************************************************************************************/
#endif 
