/***********************************************************************************************************************
                                    Copyright (C), 2006-2023, NAEN Auto Tech. Co., Ltd.
 *  --------------------------------------------------------------------------------------------------------------------
 *  File Description
 *  ------------------------------------------------------------------------------------------------------------------*/
/** \file     MsgEvent.h
 *  \brief    The module is msgevent head file for TATA_SCM_App
 *  \Author   NAEN-RDS:R515
 *  \Version  Description
 *            0.1.0      Initial version
 *  --------------------------------------------------------------------------------------------------------------------
 *  Modification Type:
 *  a.  Add
 *  b.  Remove
 *  c.  Recover
 *  d.  Change
 *  --------------------------------------------------------------------------------------------------------------------
 *  File Detail Modify History
 *  --------------------------------------------------------------------------------------------------------------------
 *  ModifyType    Date          Author  RegCodeID                  Description
 *  --------------------------------------------------------------------------------------------------------------------
 *  
***********************************************************************************************************************/

#ifndef __MSGEVENT_H__
#define __MSGEVENT_H__
/***********************************************************************************************************************
                                          Header File Includes
***********************************************************************************************************************/




/***********************************************************************************************************************
                                                Macros
***********************************************************************************************************************/
/*****************Global Event Definition ******************/
#define  Bit0        0x0001u
#define  Bit1        0x0002u
#define  Bit2        0x0004u
#define  Bit3        0x0008u
#define  Bit4        0x0010u
#define  Bit5        0x00000020u
#define  Bit6        0x00000040u
#define  Bit7        0x00000080u
#define  Bit8        0x00000100u
#define  Bit9        0x00000200u
#define  Bit10        0x00000400u
#define  Bit11        0x00000800u
#define  Bit12        0x00001000u
#define  Bit13        0x00002000u
#define  Bit14        0x00004000u
#define  Bit15        0x00008000u
#define  Bit16      0x00010000u

#define EVENT_READY                         0xFFFEu
#define EVENT_MSG_READY                     Bit0
#define EVENT_SYSTEM_OFF                    Bit1
#define EVENT_SYSTEM_ON                        Bit2
#define EVENT_SCAN_TIMER                    Bit3

#define EVENT_SSB_ESCLOCKED                    Bit4
/*********************AppFobSearch Events*******************/
#define EVENT_FOBS_TIMEOUT                    Bit4
/*********************OrgRF Events**************************/
#define EVENT_ORG_RF_10MS_TIMER                Bit4
#define EVENT_ORG_RF_RX_RESTART             Bit5
/*****************AppTelModeState***************************/
#define APP_TEL_AUTH_EVENT                  Bit4

#define    APP_TEL_MODE_STATE_NORMAL_MODE      0x55AAu
#define    APP_TEL_MODE_STATE_CHANGE_TEL       0x6699u
#define    APP_TEL_MODE_STATE_TEL_MODE1        0x9966u
#define    APP_TEL_MODE_STATE_TEL_MODE2        0x7788u
#define    APP_TEL_MODE_STATE_RETURN_NORMAL    0xAA55u

#define APP_TEL_RES_CMD_FLAG                0x55u
#define APP_TEL_RES_CMD_ENG_NONE            0x00u
#define APP_TEL_RES_ENG_START_REQ           0x01u
#define APP_TEL_RES_PWR_OFF_REQ             0x02u
#define APP_TEL_RES_AUTH_PASS_REQ           0x03u

#define APP_TEL_TBOX_CMD_FLAG               0x55u
#define APP_TEL_TBOX_CMD_ENG_NONE           0x00u
#define APP_TEL_TBOX_CMD_ENG_START          0x01u
#define APP_TEL_TBOX_CMD_ENG_OFF            0x02u

/***************************************************************
                  Calbration 对外公共信息
****************************************************************/

/***************************************************************
                  AppFobs 对外公共信息
****************************************************************/
#define FOB_SEARCH_TRIG_CMD                 0x01u
#define FOB_SEARCH_LF_TAG_RET               0x02u
#define FOB_SEARCH_LF_ALL_TAG_RET           0x03u
#define FOB_SEARCH_SIG_BCM_ARM              0x04u
#define FOB_SEARCH_IMMO_TAG_RET             0x05u
#define TAG_SEARCH_IMMO_IN_CAR              0x55
#define TAG_SEARCH_IMMO_NEW_FOB             0xAA

/***************************************************************
                  OrgPwrMod 对外公共信息
****************************************************************/
/*PEPS 第一次唤醒网络的原因 用于发送网络唤醒源CAN信号*/
#define ORG_PWR_WAKEUP_DEFAULT              0x00u
#define ORG_PWR_WAKEUP_CAN_MSG              0x01u
#define ORG_PWR_WAKEUP_RKE_LOCK             0x28u
#define ORG_PWR_WAKEUP_RKE_UNLOCK           0x29u
#define ORG_PWR_WAKEUP_RKE_TRUNK            0x30u
#define ORG_PWR_WAKEUP_PKE_DRV_CAP_UNLOCK   0x31u
#define ORG_PWR_WAKEUP_PKE_PAS_CAP_UNLOCK   0x32u
#define ORG_PWR_WAKEUP_PKE_L_SLID_UNLOCK    0x33u
#define ORG_PWR_WAKEUP_PKE_R_SLID_UNLOCK    0x34u
#define ORG_PWR_WAKEUP_PKE_TRUNK_SW         0x35u
#define ORG_PWR_WAKEUP_PKE_LF_LOCK          0x36u
#define ORG_PWR_WAKEUP_PKE_RF_LOCK          0x36u
#define ORG_PWR_WAKEUP_PN_SW                0x40u
#define ORG_PWR_WAKEUP_NETRUAL_SW           0x42u
#define ORG_PWR_WAKEUP_PARK_SW              0x45u
#define ORG_PWR_WAKEUP_BREAK_SW             0x49u
#define ORG_PWR_WAKEUP_SSB_SW               0x50u
#define ORG_PWR_WAKEUP_KICK_SW              0x51u
#define ORG_PWR_WAKEUP_CLUTCH_SW            0x52u
#define ORG_PWR_WAKEUP_TG_LOCK_SW           0x53u
#define ORG_PWR_WAKEUP_PKE_RL_LOCK          0x54u
#define ORG_PWR_WAKEUP_PKE_RL_UNLOCK        0x55u
#define ORG_PWR_WAKEUP_PKE_RR_LOCK          0x56u
#define ORG_PWR_WAKEUP_PKE_RR_UNLOCK        0x57u
#define ORG_PWR_WAKEUP_PANIC                0x58u
#define ORG_PWR_WAKEUP_RES                  0x59u
#define ORG_PWR_WAKEUP_SIGNAL_TRIG          0x60u/*DT_IS_PPA12_PEPS_034*/
#define ORG_PWR_WAKEUP_ERR_PROC             0x61u
#define ORG_PWR_WAKEUP_RELAY_FB             0x62u
#define ORG_PWR_WAKEUP_DIAG_MSG             0x63u

/*PEPS 系统启动类型*/
#define ORG_PWR_SYS_COLD_START              0x01u
#define ORG_PWR_SYS_WARM_START              0x00u

/***************************************************************
                    AppPdu 对外公共信息
****************************************************************/
/*远程PDU 失败原因回复APP TEL 模块*/
#define APP_PDU_ERROR_NoError               (0)
#define APP_PDU_ERROR_SsbIsPressed          (1)
#define APP_PDU_ERROR_BrakeIsPressed        (2)
#define APP_PDU_ERROR_NotInPLevel           (3)
#define APP_PDU_ERROR_NotInNeutralLevel     (4)
#define APP_PDU_ERROR_EmsAuthFail           (5)
#define APP_PDU_ERROR_EngineCrankFail       (6)
#define APP_PDU_ERROR_PudRunEngineNotRun    (7)
#define APP_PDU_ERROR_EngineStartOff        (8)
#define APP_PDU_ERROR_EmsLocked             (9)
#define APP_PDU_ERROR_BcmRsp                (10)
#define APP_PDU_ERROR_EningeRunning            (11)
/***********************************************************************************************************************
                                      Structure&Enumerate Declarations
***********************************************************************************************************************/
typedef enum
{
    ORG_FOB_COM_MSG_CMD_RSSI_OUT_LEFT = 0,   /*Driver door handle switch pressed (Passive entry/exit)*/        
    ORG_FOB_COM_MSG_CMD_RSSI_OUT_RIGHT,      /*Co-driver door handle switch pressed (Passive entry/exit)*/    
    ORG_FOB_COM_MSG_CMD_RSSI_OUT_BUMPER,      /*Bumper switch pressed (Passive entry)*/                                
    ORG_FOB_COM_MSG_CMD_RSSI_IN_CAR,         /*Start/stop button or brake pedal pressed (Passive start)*/         
    ORG_FOB_COM_MSG_CMD_RSSI_IN_TRUNK,       /*Trunk close trigger (Passive exit)*/                           
    ORG_FOB_COM_MSG_CMD_RSSI_ALL_IN_CAR,     /*Block-keys trigger (search all keys in car)*/
    ORG_FOB_COM_MSG_CMD_SEARCH_FOB_IDE,      /*Search Fob's IDE which belongs to this vehicle*/
    ORG_FOB_COM_MSG_CMD_SEARCH_LF_IN,      /*Driver door close trigger(search key driver door out and in car) */
    ORG_FOB_COM_MSG_CMD_SEARCH_RF_IN,      /*Co-driver door close trigger(search key co-driver door out and in car) */
    ORG_FOB_COM_MSG_CMD_RSSI_END,
    
    ORG_FOB_COM_MSG_CMD_SEARCH_TP,      /*Search tp*/
    ORG_FOB_COM_MSG_CMD_ACTIVE_SEARCH,       /*Positive searching fob for detect tag's trace by fl & fr ant,
                                                GA_A06_PEPS_008*/
    ORG_FOB_COM_MSG_CMD_POIING_ENABLE,  /*Enable LF Enters Polling mode*/
    ORG_FOB_COM_MSG_CMD_POIING_DISABLE, /*Enable LF Returns form  Polling mode*/
    ORG_FOB_COM_MSG_CMD_END,
}EN_ORG_FOB_COM_MSG_CMD_TYPE; /*GA_A06_PEPS_073*/

typedef enum
{
    ORG_FOB_COM_MSG_EXEC_DEFAULT,
    ORG_FOB_COM_MSG_EXEC_TAG_SUCCESS, /*查找智能钥匙操作成功，且找到有效钥匙*/
    ORG_FOB_COM_MSG_EXEC_TAG_FAILURE, /*查找智能钥匙操作失败*/
    ORG_FOB_COM_MSG_EXEC_TAG_SPECIFIC_NOT_FOUND, /*查找智能钥匙操作成功，但未找到有效钥匙*/
    ORG_FOB_COM_MSG_EXEC_ALL_TAG_SUCCESS, /*查找全部智能钥匙操作成功，且已学习钥匙都查找到*/
    ORG_FOB_COM_MSG_EXEC_ALL_TAG_FAILURE, /*查找全部智能钥匙操作失败*/
    ORG_FOB_COM_MSG_EXEC_ALL_TAG_NOT_ALL_FOUND, /*查找全部智能钥匙操作成功，但已学习钥匙未全部查找到*/
    ORG_FOB_COM_MSG_EXEC_FOB_IDE_SUCCESS, /*查找全部智能钥匙IDE，且已学习钥匙都查找到*/
    ORG_FOB_COM_MSG_EXEC_FOB_IDE_FAILURE, /*查找全部智能钥匙IDE操作失败*/
    ORG_FOB_COM_MSG_EXEC_FOB_IDE_NOT_ALL_FOUND, /*查找全部智能钥匙IDE操作成功，但已学习钥匙未全部查找到*/
    ORG_FOB_COM_MSG_EXEC_FOB_NOT_ALL_FOUND,/*查找车内外时只找到车内或者只找到车外*/
    ORG_FOB_COM_MSG_EXEC_TP_SUCCESS, /*查找备份钥匙操作成功，且找到有效钥匙*/
    ORG_FOB_COM_MSG_EXEC_TP_INHIBIT,/*查找备份钥匙操作成功，且找到有效钥匙，但该钥匙被禁止*/
    ORG_FOB_COM_MSG_EXEC_TP_FAILURE, /*查找备份钥匙操作失败*/
    ORG_FOB_COM_MSG_EXEC_TP_SPECIFIC_NOT_FOUND, /*查找备份钥匙操作成功，但未找到有效钥匙*/
    ORG_FOB_COM_MSG_EXEC_ACTIVE_SEARCH_SUCCESS, /*主动找钥匙成功，且已学习的钥匙都被找到*/
    ORG_FOB_COM_MSG_EXEC_ACTIVE_SEARCH_FAILURE, /*主动找钥匙失败*/
    ORG_FOB_COM_MSG_EXEC_ACTIVE_SEARCH_NOT_ALL_FOUND, /*主动找钥匙成功，但已学习钥匙未全部找到*/
    ORG_FOB_COM_MSG_EXEC_POLLING_EN_SUCCESS, /*触发进入Polling操作成功，且LF芯片进入Polling模式*/
    ORG_FOB_COM_MSG_EXEC_POLLING_EN_FAILURE,/*触发进入Polling操作成功，但LF芯片未能进入Polling模式*/
    ORG_FOB_COM_MSG_EXEC_POLLING_EN_LF_REFUSE, /*触发LF芯片进入Polling操作失败*/
    ORG_FOB_COM_MSG_EXEC_POLLING_DIS_SUCCESS, /*触发退出Polling操作成功，且LF芯片退出Polling模式*/
    ORG_FOB_COM_MSG_EXEC_POLLING_DIS_FAILURE, /*触发退出Polling操作成功，但LF芯片未能退出Polling模式*/
    ORG_FOB_COM_MSG_EXEC_POLLING_DIS_LF_REFUSE, /*触发LF芯片退出Polling操作失败*/
}EN_ORG_FOB_COM_MSG_EXEC_RESULT;/*GA_A06_PEPS_073*//*GA_A06_PEPS_186*/

typedef enum
{
    ORG_FOB_COM_RF_RSP_CHANNEL_NULL,
    ORG_FOB_COM_RF_RSP_CHANNEL_ONE,
    ORG_FOB_COM_RF_RSP_CHANNEL_TWO,
}EN_ORG_FOB_COM_RF_RSP_CHANNEL_TYPE;

typedef enum
{
    ORG_FOB_COM_POLLING_SIDE_NULL,
    ORG_FOB_COM_POLLING_SIDE_DOOR,
    ORG_FOB_COM_POLLING_SIDE_BUMPER,
    ORG_FOB_COM_POLLING_SIDE_COMBI,
}EN_ORG_FOB_COM_POLLING_SIDE_TYPE;

typedef enum
{
    ORG_FOB_COM_EOL_POLLING_LEVEL_1 = 0, /*500ms*/
    ORG_FOB_COM_EOL_POLLING_LEVEL_2,     /*700ms*/
    ORG_FOB_COM_EOL_POLLING_LEVEL_3,     /*1000ms*/
    ORG_FOB_COM_EOL_POLLING_INVALID_LEVEL,
}EN_ORG_FOB_COM_EOL_POLLING_LEVEL;  /*GA_A06_PEPS_166*/

typedef enum
{
    ORG_FOB_COM_ACTIVE_SEARCH_FOB_POS_NULL = 0,
    ORG_FOB_COM_ACTIVE_SEARCH_FOB_POS_IN_CAR,
    ORG_FOB_COM_ACTIVE_SEARCH_FOB_POS_OUT_CAR,
}EN_ORG_FOB_COM_ACTIVE_SEARCH_FOB_POS_TYPE; /*GA_A06_PEPS_105*/

/*********************OrgRf Msg***********************************/
typedef enum
{
    ORG_RF_VALID_FUNC_CODE_RELEASE,
    ORG_RF_VALID_FUNC_CODE_LOCK,
    ORG_RF_VALID_FUNC_CODE_UNLOCK,
    ORG_RF_VALID_FUNC_CODE_TRUNK,
    ORG_RF_VALID_FUNC_CODE_PANIC,
    ORG_RF_VALID_FUNC_CODE_RES,
    ORG_RF_VALID_FUNC_CODE_ALARM,
    ORG_RF_VALID_FUNC_CODE_MODE_CHANGE,
    ORG_RF_VALID_FUNC_CODE_OTHER_MIXED, /*为除有效按键以外的按键或按键组合,以便功能层停止长按功能*/
    ORG_RF_VALID_FUNC_CODE_INVALID
}EN_ORG_RF_VALID_FUNC_CODE;

typedef enum
{
    ORG_RF_BUTTON_CMD_NO_PRESS = 0,
    ORG_RF_BUTTON_CMD_SHORT_PRESS,
    ORG_RF_BUTTON_CMD_LONG_PRESS,
    ORG_RF_BUTTON_CMD_LONGER_PRESS,
    ORG_RF_BUTTON_CMD_DOUBLE_PRESS,
    ORG_RF_BUTTON_CMD_RELEASE,
    ORG_RF_BUTTON_CMD_END,
}EN_ORG_RF_BUTTON_CMD_TYPE;

/*PEPS 维持唤醒原因 本项目中不需要输输出到CAN*/
typedef enum
{ 
    ORG_POWER_NO_SOURCE = 0,

    ORG_POWER_RF_TRIG_SOURCE,
    ORG_POWER_RKE_TRIG_SOURCE,
    ORG_POWER_RKE_LOCK_SOURCE,
    ORG_POWER_RKE_UNLOCK_SOURCE,
    ORG_POWER_RKE_TRUNK_SOURCE,
    
    ORG_POWER_PKE_DETCET_SOURCE,
    ORG_POWER_PKE_TRIG_SOURCE,
    ORG_POWER_PKE_DRV_LOCK_SOURCE,
    ORG_POWER_PKE_DRV_UNLOCK_SOURCE,
    ORG_POWER_PKE_PAS_LOCK_SOURCE,
    ORG_POWER_PKE_PAS_UNLOCK_SOURCE,
    ORG_POWER_PKE_TRUNK_SW_SOURCE,
    
    ORG_POWER_SSB_SOURCE,
    ORG_POWER_BRAKE_SOURCE,                 
    ORG_POWER_CLUTCH_SOURCE,   
    ORG_POWER_RELAY_TRIG_SOURCE,
        
    ORG_POWER_DIAG_SOURCE, 
    ORG_POWER_APP_SOURCE,           
    ORG_POWER_WARNING_SOURCE,               
    ORG_POWER_CAN_WAKE_SOURCE,              
    ORG_POWER_ESCL_ACTIVE,                  
    ORG_POWER_COLD_START,
    ORG_POWER_LF_TRIG_SOURCE, 
    ORG_POWER_POLLING_TRIG_SOURCE,
    ORG_POWER_POLLING_EXC_SOURCE,
    ORG_POWER_TEL_MODE_SOURCE,
    //ORG_POWER_RKE_RES,    
    //ORG_POWER_N_POS_SOURCE,    
    //ORG_POWER_RKE_PANIC, 
    //  
    //ORG_POWER_ERR_PROC,
    //ORG_POWER_SIGNAL_TRIG,
    ORG_POWER_MAX_ACTIVE_SOURCE,        
}EN_ORG_PWR_KEEP_AWAKE_SRC;

/*OrgPwrMod 接收外部命令的枚举类型*/
typedef enum
{
    ORG_POWER_NO_CMD = 0,
    ORG_POWER_ACTIVE_CMD,
    ORG_POWER_SLEEP_CMD,
    ORG_POWER_FAST_SLEEP_CMD
}EN_ORG_POWER_CMD;

/*OrgPwrMod 工作模式的枚举类型*/
typedef enum
{
    ORG_PWR_MODE_RESET,
    ORG_PWR_MODE_START,
    ORG_PWR_MODE_AWAKE,
    ORG_PWR_MODE_PRE_SLEEP,
    ORG_PWR_MODE_SLEEP,
    ORG_PWR_MODE_LEARN,
    ORG_PWR_MODE_MAX
}EN_ORG_PWR_MODE;
/***************************************************************
                  OrgCanNm 对外公共信息
****************************************************************/
typedef enum
{
    ORG_CAN_NM_CTRL_AWAKE = 0,
    ORG_CAN_NM_CTRL_SLEEP,
    ORG_CAN_NM_CTRL_FAST_SLEEP
}EN_ORG_CAN_NM_CTRL_STS;

/***************************************************************
                  OrgOutput 对外公共信息
****************************************************************/
typedef enum
{
    ORG_OUTPUT_ACC_RELAY = 0,                
    ORG_OUTPUT_IGN1_RELAY,                
    ORG_OUTPUT_IGN2_RELAY,
    ORG_OUTPUT_START_RELAY,                
    ORG_OUTPUT_SSB_LED1,   /*YELLOW A*/
    ORG_OUTPUT_SSB_LED2,   /*GREEN G*/            
    ORG_OUTPUT_SSB_BACK_LIGHT,
    ORG_OUTPUT_WPC_MUTE,    
    ORG_OUTPUT_ENGINE_SW,
    ORG_OUTPUT_MAX,
}EN_ORG_OUTPUT_INDEX;

typedef enum
{
    CAL_DIAG_CTRL_FAIL = 0,
    CAL_DIAG_CTRL_OK ,
    CAL_DIAG_CTRL_BUSY,
    CAL_DIAG_CTRL_NRC24
}EN_CAL_DIAG_CTRL_RESULT;

/***************************************************************
                    AppCan 对外公开信息
****************************************************************/

/*该Enum定义App模块通过MsgEvent使用的命令*/
typedef enum
{
/*
    ACM_SOURCE_INFO_NON,    
    ACM_SOURCE_INFO_PKE,    
    ACM_SOURCE_INFO_RKE,    
    ACM_SOURCE_INFO_NEAR_ACCESS,    
*/    
    ACM_ORDER_INFO_OFF,     /*0x4*/
    ACM_ORDER_INFO_LOCK,    /*0x5*/
    ACM_ORDER_INFO_UNLOCK,    /*0x6*/
    ACM_ORDER_INFO_TRUNK,    /*0x7*/
    ACM_ORDER_INFO_WEL_ON,    /*0x8*/
    ACM_ORDER_INFO_WEL_OFF, /*0x9*/
    ACM_ORDER_INFO_POWER_SLIDE_DOR_R,    /*0xa*/
    ACM_ORDER_INFO_POWER_SLIDE_DOR_L,    /*0xb*/
    
    ACM_BLT_KEY_LOCAL_NO_REQ,  /*DT_CH_T1A_PEPS_096*/
    ACM_BLT_KEY_LOCAL_REQ_ACTIVE,
/*    
    ACM_ID_INFO_ID1,    
    ACM_ID_INFO_ID2,    
    ACM_ID_INFO_ID3,    
    ACM_ID_INFO_ID4,    
*/

    ACM_EASY_TRUNK_FLASH_LIGHT_OFF, /*0x10*/
    ACM_EASY_TRUNK_FLASH_LIGHT_ON,    /*0x11*/
    ACM_PLG_UNLOCK_ON_REQ,    /*0x12*/
    ACM_PLG_UNLOCK_REQ_UNLOCK,    /*0x13*/
    
    ACM_LONG_ORDER_INFO_OFF, 
    ACM_LONG_ORDER_INFO_LOCK,    
    ACM_LONG_ORDER_INFO_UNLOCK,    
    ACM_LONG_ORDER_INFO_TRUNK,    
    ACM_LONG_ORDER_INFO_CAR_SEARCH,/*DT_CH_T1A_PEPS_124*/

    APP_CAN_MSG_SIG_CMD_MAX
}EN_APP_CAN_CFG_SIG_CMD;

typedef enum
{
    APP_CAN_CFG_SEND_EMS_MSG1,
    APP_CAN_CFG_SEND_EMS_MSG2,
    APP_CAN_CFG_SEND_TEL_MSG1,
    APP_CAN_CFG_SEND_TEL_MSG2,
    APP_CAN_CFG_SEND_TCU_MSG1,
    APP_CAN_CFG_SEND_TCU_MSG2,
    APP_CAN_CFG_SEND_ESCL_MSG1,
    APP_CAN_CFG_SENT_MSG_MAX
}APP_CAN_CFG_POST_SEND_MSG;

typedef enum
{
    APP_CAN_CFG_RCV_EMS_MSG1,
    APP_CAN_CFG_RCV_EMS_MSG2,
    APP_CAN_CFG_RCV_TEL_MSG1,
    APP_CAN_CFG_RCV_TEL_MSG2,
    APP_CAN_CFG_RCV_TCU_MSG1,
    APP_CAN_CFG_RCV_TCU_MSG2,
    APP_CAN_CFG_RCV_MSG_MAX
}APP_CAN_CFG_POST_RCV_MSG;

/*------------------------------Msgevent---list-----------------------------------*/
typedef enum
{
    ORG_SIG_SSB_SINGLE_SHORT_PRESS,
    ORG_SIG_SSB_DOUBLE_SHORT_PRESS,
    ORG_SIG_SSB_SINGLE_EM_STOP_PRESS,
    ORG_SIG_SSB_DOUBLE_EM_STOP_PRESS,
    ORG_SIG_SSB_FORCE_START_PRESS,
    ORG_SIG_P_PRESS,
    ORG_SIG_BRAKE_PRESS,
    ORG_SIG_CLUTCH_PRESS,
    ORG_SIG_ALL_DOOR_CLOSED_TRIG,
    ORG_SIG_FOUR_DOOR_CLOSED_TRIG,
    ORG_SIG_DRV_DOOR_OPEN_TRIG,
    ORG_SIG_DRV_DOOR_CLOSED_TRIG,
    ORG_SIG_TRUNK_DOOR_CLOSED_TRIG,
    ORG_SIG_TRUNK_DOOR_OPEN_TRIG,
    ORG_SIG_ANY_DOOR_CLOSE_TRIG,
    ORG_SIG_4_ANY_DOOR_OPEN_TRIG,
    ORG_SIG_ANY_DOOR_OPEN_TRIG,
    ORG_SIG_ESCL_CHALL_ARV_TRIG,
    ORG_SIG_4_DOOR_LOCKED_TRIG,/*DT_CH_T1A_PEPS_154*/
    ORG_SIG_4_DOOR_UNLOCKED_TRIG,
    ORG_SIG_ALL_DOOR_LOCKED_TRIG,
    ORG_SIG_ANY_DOOR_UNLOCKED_TRIG,
    ORG_SIG_PLG_KICK_UNLOCK_TRIG,/*DT_CH_T1A_PEPS_022*/
    ORG_SIG_PLG_CLOSED_TRIG,/*DT_CH_T1A_PEPS_283*/
    ORG_SIG_MSG_EVENT_MAX
}EN_ORG_SIG_MSG_EVENT_INDEX;

/*****************OrgErrProc ErrorType***********************/


/***************************************************************
                   Applearn 对外公共信息
****************************************************************/
typedef enum
{
    APP_LEARN_NO_CMD = 0,                        /* 0 */
    APP_LEARN_CHECK_PEPS_STATUS_CMD,             /* 1 */

    APP_LEARN_RESET_PEPS_CMD,                    /* 2 */
    APP_LEARN_WRITR_PIN_CMD,                     /* 3 */
    APP_LEARN_READ_PIN_CMD,                         /* 4 */
    APP_LEARN_WRITE_VIN_CMD,                     /* 5 */
    APP_LEARN_READ_VIN_CMD,                         /* 6 */
    
    APP_LEARN_LEARN_TBOX_CMD,                    /* 7 */
    APP_LEARN_TEACH_TBOX_CMD,                    /* 8 */

    APP_LEARN_LEARN_TCU_CMD,                     /* 9 */
    APP_LEARN_TEACH_TCU_CMD,                     /* 10 */
    
    APP_LEARN_LEARN_EMS_CMD,                     /* 11 */
    APP_LEARN_TEACH_EMS_CMD,                     /* 12 */

    APP_LEARN_READ_FOB_IDE_CMD,                  /* 13 */
    APP_LEARN_READ_FOB_STATUS_CMD,               /* 14 */
    
    APP_LEARN_TEACH_NEW_FOB_CMD,                 /* 15 */
    APP_LEARN_TEACH_OLD_FOB_CMD,                 /* 16 */
    APP_LEARN_DELETE_FOBS_CMD,                   /* 17 */
    APP_LEARN_CMD_BUTT                           /* 18 */
}EN_APP_LEARN_CMD;/*DT_CH_T1A_PEPS_102*/
/***********************************************************************************************************************
                                        Extern Function Declarations 
***********************************************************************************************************************/


/***********************************************************************************************************************
                                               End Of File
***********************************************************************************************************************/
#endif 
