/***********************************************************************************************************************
                                    Copyright (C), 2006-2023, NAEN Auto Tech. Co., Ltd.
 *  --------------------------------------------------------------------------------------------------------------------
 *  File Description
 *  ------------------------------------------------------------------------------------------------------------------*/
/** \file     AppBms.h
 *  \brief    This is the core for AppBms voltage manage
***********************************************************************************************************************/

#ifndef __APP_BMS_H__
#define __APP_BMS_H__

/***********************************************************************************************************************
                                             Include Files
***********************************************************************************************************************/
#include "typedef.h"


/***********************************************************************************************************************
                                                Macros
***********************************************************************************************************************/


/***********************************************************************************************************************
                                      Structure&Union&Enumerate Declarations
***********************************************************************************************************************/
typedef enum
{
    APP_BMS_VOLTAGE_STOP,      /***0-8.5V***/
    APP_BMS_VOLTAGE_LOW,       /***8.5V-10.5***/
    APP_BMS_VOLTAGE_NORMAL,    /***10.5V-16.5***/
    APP_BMS_VOLTAGE_OVER,      /***>16.5v***/
    APP_BMS_VOLTAGE_STATE_NUM
}EN_APP_BMS_VOLTAGE_STATE;


/***********************************************************************************************************************
                                       Extern Function Declarations 
***********************************************************************************************************************/
extern BOOL AppBmsColdInit(void);
extern BOOL AppBmsWarmInit(void);
extern void TaskAppBms(UINT16 uwEventId,UINT8* pucData);

extern UINT8 AppBmsSleepVoltageStateJudge(UINT16 uwAdValue);
extern UINT8 AppBmsPowerOffStateGet(void);
extern UINT16 AppBmsBatVoltageValueGet(void);
extern UINT16 AppBmsBatAdcValueGet(void);
extern EN_APP_BMS_VOLTAGE_STATE AppBmsBatStateGet(void);
/***********************************************************************************************************************
                                               End Of File
***********************************************************************************************************************/
#endif
