
/*
 * Copyright 2020-2025 Yuntu Microelectronics Co., Ltd.
 * All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 * 
 * @file vector.S
 * @brief 
 * 
 */

    
    SECTION .isr_vector:DATA:ROOT(2)
    EXTERN DefaultISR
    EXTERN STACK_end   /* Top of Stack for Initial Stack Pointer */
    EXTERN Reset_Handler             /* Reset Handler */
    EXTERN NMI_Handler
    EXTERN HardFault_Handler
    EXTERN MemManage_Handler
    EXTERN BusFault_Handler
    EXTERN UsageFault_Handler
    EXTERN SVC_Handler
    EXTERN DebugMon_Handler
    EXTERN PendSV_Handler
    EXTERN SysTick_Handler
    EXTERN DMA0_IRQHandler
    EXTERN DMA1_IRQHandler
    EXTERN DMA2_IRQHandler
    EXTERN DMA3_IRQHandler
    EXTERN DMA_Error_IRQHandler
    EXTERN EFM_IRQHandler
    EXTERN EFM_Error_IRQHandler
    EXTERN PCU_IRQHandler
    EXTERN EFM_Ecc_IRQHandler
    EXTERN Wdg_Mld_Isr
    EXTERN I2C0_Master_IRQHandler
    EXTERN I2C0_Slave_IRQHandler
    EXTERN SPI0_IRQHandler
    EXTERN SPI1_IRQHandler
    EXTERN SPI2_IRQHandler
    EXTERN I2C1_Master_IRQHandler
    EXTERN UART0_IRQHandler
    EXTERN UART1_IRQHandler
    EXTERN UART2_IRQHandler
    EXTERN ADC0_IRQHandler
    EXTERN ACMP0_IRQHandler
    EXTERN EMU_SB_IRQHandler
    EXTERN EMU_DB_IRQHandler
    EXTERN pTMR_Ch0_IRQHandler
    EXTERN pTMR_Ch1_IRQHandler
    EXTERN pTMR_Ch2_IRQHandler
    EXTERN pTMR_Ch3_IRQHandler
    EXTERN SCU_IRQHandler
    EXTERN lpTMR0_IRQHandler
    EXTERN GPIOA_IRQHandler
    EXTERN GPIOB_IRQHandler
    EXTERN GPIOC_IRQHandler
    EXTERN GPIOD_IRQHandler
    EXTERN GPIOE_IRQHandler
    EXTERN CAN0_ORed_IRQHandler
    EXTERN CAN0_Error_IRQHandler
    EXTERN CAN0_Wake_Up_IRQHandler
    EXTERN CAN0_ORed_0_15_MB_IRQHandler
    EXTERN CAN0_ORed_16_31_MB_IRQHandler
    EXTERN CAN0_ORed_32_47_MB_IRQHandler
    EXTERN CAN0_ORed_48_63_MB_IRQHandler
    EXTERN CAN1_ORed_IRQHandler
    EXTERN CAN1_Error_IRQHandler
    EXTERN CAN1_Wake_Up_IRQHandler
    EXTERN CAN1_ORed_0_15_MB_IRQHandler
    EXTERN CAN1_ORed_16_31_MB_IRQHandler
    EXTERN CAN1_ORed_32_47_MB_IRQHandler
    EXTERN CAN1_ORed_48_63_MB_IRQHandler
    EXTERN eTMR0_Ch0_Ch1_IRQHandler
    EXTERN eTMR0_Ch2_Ch3_IRQHandler
    EXTERN eTMR0_Ch4_Ch5_IRQHandler
    EXTERN eTMR0_Ch6_Ch7_IRQHandler
    EXTERN eTMR0_Fault_IRQHandler
    EXTERN eTMR0_Ovf_IRQHandler
    EXTERN eTMR1_Ch0_Ch1_IRQHandler
    EXTERN eTMR1_Ch2_Ch3_IRQHandler
    EXTERN eTMR1_Ch4_Ch5_IRQHandler
    EXTERN eTMR1_Ch6_Ch7_IRQHandler
    EXTERN eTMR1_Fault_IRQHandler
    EXTERN eTMR1_Ovf_IRQHandler
    EXTERN MPWM0_Ch0_Ovf_IRQHandler
    EXTERN MPWM0_Ch1_Ovf_IRQHandler
    EXTERN MPWM0_Ch2_Ovf_IRQHandler
    EXTERN MPWM0_Ch3_Ovf_IRQHandler
    EXTERN MPWM0_Ch4_Ovf_IRQHandler
    EXTERN MPWM0_Ch5_Ovf_IRQHandler
    EXTERN MPWM0_Ch6_Ovf_IRQHandler
    EXTERN MPWM0_Ch7_Ovf_IRQHandler
    EXTERN MPWM0_Ch0_IRQHandler
    EXTERN MPWM0_Ch1_IRQHandler
    EXTERN MPWM0_Ch2_IRQHandler
    EXTERN MPWM0_Ch3_IRQHandler
    EXTERN MPWM0_Ch4_IRQHandler
    EXTERN MPWM0_Ch5_IRQHandler
    EXTERN MPWM0_Ch6_IRQHandler
    EXTERN MPWM0_Ch7_IRQHandler
    EXTERN TRNG_IRQHandler
    EXTERN HCU_IRQHandler

__vector_table

    DCD STACK_end   /* Top of Stack for Initial Stack Pointer */
    DCD Reset_Handler             /* Reset Handler */
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD NMI_Handler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD HardFault_Handler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD MemManage_Handler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD BusFault_Handler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD UsageFault_Handler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD DefaultISR
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD DefaultISR
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD DefaultISR
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD DefaultISR
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD SVC_Handler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD DebugMon_Handler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD DefaultISR
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD PendSV_Handler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD SysTick_Handler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD DMA0_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD DMA1_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD DMA2_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD DMA3_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD DefaultISR
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD DefaultISR
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD DefaultISR
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD DefaultISR
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD DefaultISR
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD DefaultISR
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD DefaultISR
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD DefaultISR
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD DefaultISR
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD DefaultISR
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD DefaultISR
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD DefaultISR
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD DMA_Error_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD DefaultISR
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD EFM_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD EFM_Error_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD PCU_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD EFM_Ecc_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD Wdg_Mld_Isr
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD DefaultISR
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD I2C0_Master_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD I2C0_Slave_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD SPI0_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD SPI1_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD SPI2_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD I2C1_Master_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD DefaultISR
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD UART0_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD DefaultISR
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD UART1_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD DefaultISR
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD UART2_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD DefaultISR
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD DefaultISR
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD DefaultISR
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD ADC0_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD DefaultISR
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD ACMP0_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD DefaultISR
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD DefaultISR
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD EMU_SB_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD EMU_DB_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD DefaultISR
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD DefaultISR
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD pTMR_Ch0_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD pTMR_Ch1_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD pTMR_Ch2_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD pTMR_Ch3_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD DefaultISR
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD DefaultISR
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD DefaultISR
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD DefaultISR
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD DefaultISR
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD SCU_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD lpTMR0_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD GPIOA_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD GPIOB_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD GPIOC_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD GPIOD_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD GPIOE_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD DefaultISR
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD DefaultISR
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD DefaultISR
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD DefaultISR
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD DefaultISR
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD DefaultISR
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD DefaultISR
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD DefaultISR
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD DefaultISR
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD DefaultISR
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD DefaultISR
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD DefaultISR
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD DefaultISR
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD DefaultISR
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD CAN0_ORed_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD CAN0_Error_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD CAN0_Wake_Up_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD CAN0_ORed_0_15_MB_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD CAN0_ORed_16_31_MB_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD CAN0_ORed_32_47_MB_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD CAN0_ORed_48_63_MB_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD CAN1_ORed_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD CAN1_Error_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD CAN1_Wake_Up_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD CAN1_ORed_0_15_MB_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD CAN1_ORed_16_31_MB_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD CAN1_ORed_32_47_MB_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD CAN1_ORed_48_63_MB_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD DefaultISR
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD DefaultISR
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD DefaultISR
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD DefaultISR
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD DefaultISR
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD DefaultISR
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD DefaultISR
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD eTMR0_Ch0_Ch1_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD eTMR0_Ch2_Ch3_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD eTMR0_Ch4_Ch5_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD eTMR0_Ch6_Ch7_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD eTMR0_Fault_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD eTMR0_Ovf_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD eTMR1_Ch0_Ch1_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD eTMR1_Ch2_Ch3_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD eTMR1_Ch4_Ch5_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD eTMR1_Ch6_Ch7_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD eTMR1_Fault_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD eTMR1_Ovf_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD DefaultISR
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD DefaultISR
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD DefaultISR
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD DefaultISR
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD DefaultISR
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD DefaultISR
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD DefaultISR
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD DefaultISR
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD DefaultISR
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD DefaultISR
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD DefaultISR
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD DefaultISR
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD DefaultISR
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD DefaultISR
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD DefaultISR
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD DefaultISR
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD DefaultISR
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD DefaultISR
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD DefaultISR
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD DefaultISR
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD DefaultISR
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD DefaultISR
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD DefaultISR
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD DefaultISR
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD MPWM0_Ch0_Ovf_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD MPWM0_Ch1_Ovf_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD MPWM0_Ch2_Ovf_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD MPWM0_Ch3_Ovf_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD MPWM0_Ch4_Ovf_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD MPWM0_Ch5_Ovf_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD MPWM0_Ch6_Ovf_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD MPWM0_Ch7_Ovf_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD MPWM0_Ch0_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD MPWM0_Ch1_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD MPWM0_Ch2_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD MPWM0_Ch3_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD MPWM0_Ch4_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD MPWM0_Ch5_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD MPWM0_Ch6_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD MPWM0_Ch7_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD DefaultISR
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD DefaultISR
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD DefaultISR
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD DefaultISR
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD DefaultISR
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD TRNG_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD HCU_IRQHandler
#endif
    END

