/*
 * Copyright 2020-2025 Yuntu Microelectronics Co., Ltd.
 * All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 * 
 * @file undefined
 * @brief 
 * 
 */


/*==================================================================================================
*                                        INCLUDE FILES
==================================================================================================*/
#include "Spi_Cfg.h"
#include "Spi.h"
#if (SPI_DMA_USED == STD_ON)
#include "CddDma_Cfg.h"
#endif

#if (SPI_ENABLE_DEM_REPORT_ERROR_STATUS == STD_ON)
#include "Dem.h"
#endif

/*==================================================================================================
*                              SOURCE FILE VERSION INFORMATION
==================================================================================================*/
#define SPI_VENDOR_ID_PBCFG_C                      (180)
#define SPI_AR_RELEASE_MAJOR_VERSION_PBCFG_C       (4)
#define SPI_AR_RELEASE_MINOR_VERSION_PBCFG_C       (4)
#define SPI_AR_RELEASE_REVISION_VERSION_PBCFG_C    (0)
#define SPI_SW_MAJOR_VERSION_PBCFG_C               (2)
#define SPI_SW_MINOR_VERSION_PBCFG_C               (3)
#define SPI_SW_PATCH_VERSION_PBCFG_C               (0)

/*================================================================================================== */
#if (SPI_ENABLE_DEM_REPORT_ERROR_STATUS == STD_ON)
/* Check if Spi_PBcfg.c file and Dem.h file are of the same Autosar version */
#if ((SPI_AR_RELEASE_MAJOR_VERSION_PBCFG_C != DEM_AR_RELEASE_MAJOR_VERSION) || \
     (SPI_AR_RELEASE_MINOR_VERSION_PBCFG_C != DEM_AR_RELEASE_MINOR_VERSION))
    #error "AutoSar Version Numbers of Spi_PBcfg.c and Dem.h are different"
#endif
#endif

/*================================================================================================== 
*                              GLOBAL FUNCTIONS
==================================================================================================*/

/* List of Notification Functions*/
/* Job end notifications*/

/* Sequence end notifications*/



/*==================================================================================================
*                                       LOCAL VARIABLES
==================================================================================================*/
#if ((SPI_DMA_USED == STD_ON) && ((SPI_LEVEL_DELIVERED == LEVEL1) || (SPI_LEVEL_DELIVERED == LEVEL2)))
#define SPI_START_SEC_VAR_CLEARED_UNSPECIFIED_NO_CACHEABLE
#else
#define SPI_START_SEC_VAR_CLEARED_UNSPECIFIED
#endif
#include "Spi_MemMap.h"

/* Buffers Descriptors for EB Channels and Allocate Buffers for IB Channels */
SPI_VAR __attribute__((aligned(4))) static Spi_BufferDescriptorType Spi_EbDefaultBuffer_SpiChannel_SpiChannel_RF;

#if ((SPI_DMA_USED == STD_ON) && ((SPI_LEVEL_DELIVERED == LEVEL1) || (SPI_LEVEL_DELIVERED == LEVEL2)))
#define SPI_STOP_SEC_VAR_CLEARED_UNSPECIFIED_NO_CACHEABLE
#else
#define SPI_STOP_SEC_VAR_CLEARED_UNSPECIFIED
#endif
#include "Spi_MemMap.h"

#define SPI_START_SEC_VAR_INIT_UNSPECIFIED
#include "Spi_MemMap.h"

/* Buffers Descriptors for IB Channels */

/* Channel Configuration */
SPI_VAR static Spi_ChannelConfigType Spi_ChannelConfigs[1] =
{
    /* Channel Configuration for SpiChannel_ID: 0*/
    {
        .BufferType = SPI_EB,
        .DataWidth = 8U,
        .Length =  150,
        .MsbOrLsbFirst = MSB_FIRST,
        .DefaultValue = 0U,
        .BufferDescriptorPtr = &Spi_EbDefaultBuffer_SpiChannel_SpiChannel_RF,
    },
};

#define SPI_STOP_SEC_VAR_INIT_UNSPECIFIED
#include "Spi_MemMap.h"

#define SPI_START_SEC_CONFIG_DATA_UNSPECIFIED
#include "Spi_MemMap.h"

/* Channel Assignment of Jobs*/
/* Spi Job_ID: 0*/
SPI_CONST static const Spi_ChannelType Spi_Job_0_ChannelAssignment[1] =
{
    SpiConf_SpiChannel_SpiChannel_RF,
};

/* Configuration of Jobs*/
SPI_CONST static const Spi_JobConfigType Spi_JobConfigs[1] =
{ 
    /* Job configuration for SpiJob_ID: 0*/
    {
        .HWUnit = (uint8)CSIB0,
        .ExternalDeviceId = 0U,
        .Priority = 0,
        .ChannelLinkPtr = Spi_Job_0_ChannelAssignment,
        .NumChannels = 1U,
        .JobEndNotification = NULL_PTR,
        .JobStatePtr = &Spi_JobState[0],
    },
};

/* Job Assignment of Sequence*/
/* Spi Sequence_ID: 0*/
SPI_CONST static const Spi_JobType Spi_Sequence_0_JobAssignment[1] =
{
    SpiConf_SpiJob_SpiJob_RF,
};

/* Configuration of Sequences */
SPI_CONST static const Spi_SequenceConfigType Spi_SequenceConfigs[1] =
{
    /* Sequence Configuration for SpiSequence_ID: 0 */
    {
        .NumJobs = 1U,
        .SeqEndNotification = NULL_PTR,
        .JobIndexListPtr = Spi_Sequence_0_JobAssignment,
#if (SPI_INTERRUPTIBLE_SEQ_ALLOWED == STD_ON)
        .Interruptible = FALSE,
#endif
    },
};

/* Configuration of External device unit */
SPI_CONST static const Spi_ExternalDeviceConfigType Spi_ExternalDeviceConfigs[1] =
{
    
    /*External Device 0 at CSIB0, configuration*/
    {
        .HWUnitId = CSIB0,
#if (SPI_SLAVE_SUPPORT == STD_ON)
        .SlaveMode = FALSE,
#endif
        .WhichPcs = SPI_PCS0,
        .DualEn = FALSE,
        .SamplePoint = 0U,
        .PinConfig = 0U,
        .PcsPolarity = SPI_ACTIVE_LOW,
        .BaudRate = 500000,
        .TimeClkToCs = 0U,
        .TimeCsToClk = 0U,
        .TimeCsToCs = 20U,
        .ClkPolarity = SPI_SCK_IDLE_LOW,
        .ClkPhase = SPI_DATA_SHIFT_TRAILING,
        .SrcClk = 10000000U,
        .IsSync = TRUE,
        .IsPcsContinuous = TRUE,
#if ((SPI_LEVEL_DELIVERED == LEVEL1) || (SPI_LEVEL_DELIVERED == LEVEL2))
#if (SPI_DMA_USED == STD_ON)
        .UseDma = FALSE,
#endif /* SPI_DMA_USED == STD_ON*/
#endif /* (SPI_LEVEL_DELIVERED == LEVEL1) || (SPI_LEVEL_DELIVERED == LEVEL2)*/
    },
};

SPI_CONST static const Spi_HWUnitConfigType Spi_HWUnitConfigs[SPI_MAX_HWUNIT] = 
{
    {
        .Instance = (uint8)SPI_0,
        .IsSync = TRUE,
    },
};

/* Spi Configuration */
SPI_CONST const Spi_ConfigType Spi_PreCompileConfig =
{
    .ChannelConfigPtr = Spi_ChannelConfigs, /* ChannelConfig */
    .JobConfigPtr = Spi_JobConfigs, /* JobConfig */
    .SequenceConfigPtr = Spi_SequenceConfigs, /* SequenceConfig */
    .ExternalDeviceConfigPtr = Spi_ExternalDeviceConfigs, /* ExternalDeviceConfig */

    .MaxJob = 1U, /* SpiMaxJob - number of jobs */
    .MaxChannel = 1U, /* SpiMaxChannel - number of channels */
    .MaxSequence = 1U, /* SpiMaxSequence - number of sequences */
    .MaxHWUnitUsed = 1U, /* MaxExternalDevice - number of external devices */
    .HWUnitConfigPtr = Spi_HWUnitConfigs, /* HWUnitConfig */
#if (SPI_ENABLE_DEM_REPORT_ERROR_STATUS == STD_ON)
    .SpiErrorHardwareCfg.Id = 0, /* SPI_E_HARDWARE_ERROR parameters ID of DEM error */
    .SpiErrorHardwareCfg.State = STD_OFF, /* SPI_E_HARDWARE_ERROR parameters enabling the DEM error */
#endif
};

#define SPI_STOP_SEC_CONFIG_DATA_UNSPECIFIED
#include "Spi_MemMap.h"

