/*
 * Copyright 2020-2025 Yuntu Microelectronics Co., Ltd.
 * All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 * 
 * @file Mcu_PBcfg.c
 * @brief 
 * 
 */



#include "Mcu.h"
#if (MCU_ENABLE_DEM_REPORT_ERROR_STATUS == STD_ON)
#include "Dem.h"
#endif

/*==================================================================================================
*                              SOURCE FILE VERSION INFORMATION
==================================================================================================*/
#define MCU_VENDOR_ID_PBCFG_C                      (180)
#define MCU_AR_RELEASE_MAJOR_VERSION_PBCFG_C       (4)
#define MCU_AR_RELEASE_MINOR_VERSION_PBCFG_C       (4)
#define MCU_AR_RELEASE_REVISION_VERSION_PBCFG_C    (0)
#define MCU_SW_MAJOR_VERSION_PBCFG_C               (2)
#define MCU_SW_MINOR_VERSION_PBCFG_C               (3)
#define MCU_SW_PATCH_VERSION_PBCFG_C               (0)

/*================================================================================================== */


#if (MCU_ENABLE_DEM_REPORT_ERROR_STATUS == STD_ON)
/* Check if Mcu_Cfg.c file and Dem.h file are of the same Autosar version */
#if ((MCU_AR_RELEASE_MAJOR_VERSION_PBCFG_C != DEM_AR_RELEASE_MAJOR_VERSION) || \
     (MCU_AR_RELEASE_MINOR_VERSION_PBCFG_C != DEM_AR_RELEASE_MINOR_VERSION))
    #error "AutoSar Version Numbers of Mcu_PBcfg.c and Dem.h are different"
#endif

#endif



#define MCU_START_SEC_CONFIG_DATA_UNSPECIFIED
#include "Mcu_MemMap.h"

MCU_CONST const Mcu_SircConfigType Mcu_RootSircConfig[2] = {
    {
        .SircClockRefPointFrequency = 2000000U,
        .SircDeepSleepEnable = (boolean)STD_OFF,
        .SircStandbyEnable = (boolean)STD_OFF,
    },
    {
        .SircClockRefPointFrequency = 2000000U,
        .SircDeepSleepEnable = (boolean)STD_OFF,
        .SircStandbyEnable = (boolean)STD_OFF,
    },
};

MCU_CONST const Mcu_FircConfigType Mcu_RootFircConfig[2] = {
    {
        .FircClockRefPointFrequency = 80000000U,
        .FircDeepSleepEnable = (boolean)STD_OFF,
        .FircDelayEnable = (boolean)STD_OFF,
    },
    {
        .FircClockRefPointFrequency = 80000000U,
        .FircDeepSleepEnable = (boolean)STD_OFF,
        .FircDelayEnable = (boolean)STD_OFF,
    },
};

MCU_CONST const Mcu_FxoscConfigType Mcu_RootFxoscConfig[2] = {
    {
        .ClockRefPointFrequency = 40000000U,
        .BypassMode = (boolean)STD_OFF,
        .GainSelection = 7U,
        .DeepSleepEnable = (boolean)STD_OFF,
        .DelaySelect = MCU_FXOSC_DELAY_16384_CYCLES,
    },
    {
        .ClockRefPointFrequency = 40000000U,
        .BypassMode = (boolean)STD_OFF,
        .GainSelection = 7U,
        .DeepSleepEnable = (boolean)STD_OFF,
        .DelaySelect = MCU_FXOSC_DELAY_16384_CYCLES,
    },
};

#if MCU_NO_PLL == STD_OFF
MCU_CONST const Mcu_PllConfigType Mcu_RootPllConfig[2] = {
    {
        .ClockRef = MCU_PLL_CLOCK_REFERENCE_FXOSC,
        .RefDiv = 0U,
        .FeedbackDiv = 9U,
    },
    {
        .ClockRef = MCU_PLL_CLOCK_REFERENCE_FXOSC,
        .RefDiv = 0U,
        .FeedbackDiv = 9U,
    },
};
#endif /* #if MCU_NO_PLL == STD_OFF */


MCU_CONST const Mcu_ClockOutConfigType Mcu_RootClockOutConfig[2] = {
    {
        .Source = MCU_CLOCK_OUT_SOURCE_FIRC,
        .ClockOutDiv = 2U,
    },
    {
        .Source = MCU_CLOCK_OUT_SOURCE_FIRC,
        .ClockOutDiv = 2U,
    },
};



MCU_CONST const Mcu_IpcConfigType Mcu_RootIpcConfig_0[32] = {
    {
        .PeripheralIndex = MCU_IPC_DMA_INDEX,
        .ClockEnable = (boolean)STD_ON,
        .ClockSource = MCU_IPC_CLK_SRC_OFF,
        .ClockDiv = 0U,
    },
    {
        .PeripheralIndex = MCU_IPC_GPIO_INDEX,
        .ClockEnable = (boolean)STD_ON,
        .ClockSource = MCU_IPC_CLK_SRC_OFF,
        .ClockDiv = 0U,
    },
    {
        .PeripheralIndex = MCU_IPC_PCTRLA_INDEX,
        .ClockEnable = (boolean)STD_ON,
        .ClockSource = MCU_IPC_CLK_SRC_OFF,
        .ClockDiv = 0U,
    },
    {
        .PeripheralIndex = MCU_IPC_PCTRLB_INDEX,
        .ClockEnable = (boolean)STD_ON,
        .ClockSource = MCU_IPC_CLK_SRC_OFF,
        .ClockDiv = 0U,
    },
    {
        .PeripheralIndex = MCU_IPC_PCTRLC_INDEX,
        .ClockEnable = (boolean)STD_ON,
        .ClockSource = MCU_IPC_CLK_SRC_OFF,
        .ClockDiv = 0U,
    },
    {
        .PeripheralIndex = MCU_IPC_PCTRLD_INDEX,
        .ClockEnable = (boolean)STD_ON,
        .ClockSource = MCU_IPC_CLK_SRC_OFF,
        .ClockDiv = 0U,
    },
    {
        .PeripheralIndex = MCU_IPC_PCTRLE_INDEX,
        .ClockEnable = (boolean)STD_ON,
        .ClockSource = MCU_IPC_CLK_SRC_OFF,
        .ClockDiv = 0U,
    },
    {
        .PeripheralIndex = MCU_IPC_UART0_INDEX,
        .ClockEnable = (boolean)STD_OFF,
        .ClockSource = MCU_IPC_CLK_SRC_FXOSC,
        .ClockDiv = 0U,
    },
    {
        .PeripheralIndex = MCU_IPC_UART1_INDEX,
        .ClockEnable = (boolean)STD_OFF,
        .ClockSource = MCU_IPC_CLK_SRC_FXOSC,
        .ClockDiv = 0U,
    },
    {
        .PeripheralIndex = MCU_IPC_UART2_INDEX,
        .ClockEnable = (boolean)STD_OFF,
        .ClockSource = MCU_IPC_CLK_SRC_FXOSC,
        .ClockDiv = 0U,
    },
    {
        .PeripheralIndex = MCU_IPC_I2C0_INDEX,
        .ClockEnable = (boolean)STD_ON,
        .ClockSource = MCU_IPC_CLK_SRC_OFF,
        .ClockDiv = 0U,
    },
    {
        .PeripheralIndex = MCU_IPC_I2C1_INDEX,
        .ClockEnable = (boolean)STD_ON,
        .ClockSource = MCU_IPC_CLK_SRC_OFF,
        .ClockDiv = 0U,
    },
    {
        .PeripheralIndex = MCU_IPC_SPI0_INDEX,
        .ClockEnable = (boolean)STD_ON,
        .ClockSource = MCU_IPC_CLK_SRC_FIRC,
        .ClockDiv = 7U,
    },
    {
        .PeripheralIndex = MCU_IPC_SPI1_INDEX,
        .ClockEnable = (boolean)STD_ON,
        .ClockSource = MCU_IPC_CLK_SRC_FIRC,
        .ClockDiv = 7U,
    },
    {
        .PeripheralIndex = MCU_IPC_SPI2_INDEX,
        .ClockEnable = (boolean)STD_ON,
        .ClockSource = MCU_IPC_CLK_SRC_FIRC,
        .ClockDiv = 7U,
    },
    {
        .PeripheralIndex = MCU_IPC_FlexCAN0_INDEX,
        .ClockEnable = (boolean)STD_ON,
        .ClockSource = MCU_IPC_CLK_SRC_OFF,
        .ClockDiv = 0U,
    },
    {
        .PeripheralIndex = MCU_IPC_FlexCAN1_INDEX,
        .ClockEnable = (boolean)STD_ON,
        .ClockSource = MCU_IPC_CLK_SRC_OFF,
        .ClockDiv = 0U,
    },
    {
        .PeripheralIndex = MCU_IPC_ADC0_INDEX,
        .ClockEnable = (boolean)STD_ON,
        .ClockSource = MCU_IPC_CLK_SRC_FIRC,
        .ClockDiv = 4U,
    },
    {
        .PeripheralIndex = MCU_IPC_ACMP0_INDEX,
        .ClockEnable = (boolean)STD_ON,
        .ClockSource = MCU_IPC_CLK_SRC_OFF,
        .ClockDiv = 0U,
    },
    {
        .PeripheralIndex = MCU_IPC_TMU_INDEX,
        .ClockEnable = (boolean)STD_ON,
        .ClockSource = MCU_IPC_CLK_SRC_OFF,
        .ClockDiv = 0U,
    },
    {
        .PeripheralIndex = MCU_IPC_eTMR0_INDEX,
        .ClockEnable = (boolean)STD_ON,
        .ClockSource = MCU_IPC_CLK_SRC_OFF,
        .ClockDiv = 0U,
    },
    {
        .PeripheralIndex = MCU_IPC_eTMR1_INDEX,
        .ClockEnable = (boolean)STD_ON,
        .ClockSource = MCU_IPC_CLK_SRC_OFF,
        .ClockDiv = 0U,
    },
    {
        .PeripheralIndex = MCU_IPC_MPWM0_INDEX,
        .ClockEnable = (boolean)STD_ON,
        .ClockSource = MCU_IPC_CLK_SRC_OFF,
        .ClockDiv = 0U,
    },
    {
        .PeripheralIndex = MCU_IPC_pTMR0_INDEX,
        .ClockEnable = (boolean)STD_ON,
        .ClockSource = MCU_IPC_CLK_SRC_OFF,
        .ClockDiv = 0U,
    },
    {
        .PeripheralIndex = MCU_IPC_lpTMR0_INDEX,
        .ClockEnable = (boolean)STD_ON,
        .ClockSource = MCU_IPC_CLK_SRC_OFF,
        .ClockDiv = 0U,
    },
    {
        .PeripheralIndex = MCU_IPC_CRC_INDEX,
        .ClockEnable = (boolean)STD_ON,
        .ClockSource = MCU_IPC_CLK_SRC_OFF,
        .ClockDiv = 0U,
    },
    {
        .PeripheralIndex = MCU_IPC_TRNG_INDEX,
        .ClockEnable = (boolean)STD_ON,
        .ClockSource = MCU_IPC_CLK_SRC_OFF,
        .ClockDiv = 0U,
    },
    {
        .PeripheralIndex = MCU_IPC_HCU_INDEX,
        .ClockEnable = (boolean)STD_ON,
        .ClockSource = MCU_IPC_CLK_SRC_OFF,
        .ClockDiv = 0U,
    },
    {
        .PeripheralIndex = MCU_IPC_EWDG_INDEX,
        .ClockEnable = (boolean)STD_OFF,
        .ClockSource = MCU_IPC_CLK_SRC_OFF,
        .ClockDiv = 0U,
    },
    {
        .PeripheralIndex = MCU_IPC_EMU_INDEX,
        .ClockEnable = (boolean)STD_ON,
        .ClockSource = MCU_IPC_CLK_SRC_OFF,
        .ClockDiv = 0U,
    },
    {
        .PeripheralIndex = MCU_IPC_CIM_INDEX,
        .ClockEnable = (boolean)STD_ON,
        .ClockSource = MCU_IPC_CLK_SRC_OFF,
        .ClockDiv = 0U,
    },
    {
        .PeripheralIndex = MCU_IPC_SCU_INDEX,
        .ClockEnable = (boolean)STD_ON,
        .ClockSource = MCU_IPC_CLK_SRC_OFF,
        .ClockDiv = 0U,
    },
};

MCU_CONST const Mcu_IpcConfigType Mcu_RootIpcConfig_1[9] = {
    {
        .PeripheralIndex = MCU_IPC_GPIO_INDEX,
        .ClockEnable = (boolean)STD_ON,
        .ClockSource = MCU_IPC_CLK_SRC_OFF,
        .ClockDiv = 0U,
    },
    {
        .PeripheralIndex = MCU_IPC_PCTRLA_INDEX,
        .ClockEnable = (boolean)STD_ON,
        .ClockSource = MCU_IPC_CLK_SRC_OFF,
        .ClockDiv = 0U,
    },
    {
        .PeripheralIndex = MCU_IPC_PCTRLB_INDEX,
        .ClockEnable = (boolean)STD_ON,
        .ClockSource = MCU_IPC_CLK_SRC_OFF,
        .ClockDiv = 0U,
    },
    {
        .PeripheralIndex = MCU_IPC_PCTRLC_INDEX,
        .ClockEnable = (boolean)STD_ON,
        .ClockSource = MCU_IPC_CLK_SRC_OFF,
        .ClockDiv = 0U,
    },
    {
        .PeripheralIndex = MCU_IPC_PCTRLD_INDEX,
        .ClockEnable = (boolean)STD_ON,
        .ClockSource = MCU_IPC_CLK_SRC_OFF,
        .ClockDiv = 0U,
    },
    {
        .PeripheralIndex = MCU_IPC_PCTRLE_INDEX,
        .ClockEnable = (boolean)STD_ON,
        .ClockSource = MCU_IPC_CLK_SRC_OFF,
        .ClockDiv = 0U,
    },
    {
        .PeripheralIndex = MCU_IPC_SPI0_INDEX,
        .ClockEnable = (boolean)STD_ON,
        .ClockSource = MCU_IPC_CLK_SRC_FIRC,
        .ClockDiv = 7U,
    },
    {
        .PeripheralIndex = MCU_IPC_ADC0_INDEX,
        .ClockEnable = (boolean)STD_ON,
        .ClockSource = MCU_IPC_CLK_SRC_FIRC,
        .ClockDiv = 4U,
    },
    {
        .PeripheralIndex = MCU_IPC_lpTMR0_INDEX,
        .ClockEnable = (boolean)STD_ON,
        .ClockSource = MCU_IPC_CLK_SRC_OFF,
        .ClockDiv = 0U,
    },
};

MCU_CONST const Mcu_PeripheralClockConfigType Mcu_RootPeripheralClockConfig[2] = {
    {
        .IpcCount = 32U,
        .IpcConfig = (Mcu_IpcConfigType *)&Mcu_RootIpcConfig_0[0],
    },
    {
        .IpcCount = 9U,
        .IpcConfig = (Mcu_IpcConfigType *)&Mcu_RootIpcConfig_1[0],
    },
};



MCU_CONST const Mcu_ClockConfigType Mcu_RootClockConfig[2] = {
    [0] = {
        .SystemClockSource = MCU_SYSTEM_CLOCK_SOURCE_FXOSC,
        .CoreClockDiv = 0U,
        .FastBusClockDiv = 0U,
        .SlowBusClockDiv = 3U,
        .EfmPrescaleValue = 5U,
        .EfmWRSValue = 1U,

        .SircUnderUserCtrl = (boolean)STD_ON,
        .SircConfig = &Mcu_RootSircConfig[0],

        .FircUnderUserCtrl = (boolean)STD_ON,
        .FircEnable = (boolean)STD_ON,
        .FircConfig = &Mcu_RootFircConfig[0],

        .FxoscUnderUserCtrl = (boolean)STD_ON,
        .FxoscEnable = (boolean)STD_ON,
        .FxoscConfig = &Mcu_RootFxoscConfig[0],
#if (MCU_NO_PLL == STD_OFF)
        .PllUnderUserCtrl = (boolean)STD_OFF,
        .PllEnable = (boolean)STD_OFF,
        .PllConfig = (Mcu_PllConfigType *)&Mcu_RootPllConfig[0],
#endif
        .ClockOutEnable = (boolean)STD_OFF,
        .ClockOutConfig = &Mcu_RootClockOutConfig[0],

        .ClockMonitorConfig = NULL_PTR,
        .ClockMonitorConfigNums = 0,

        .PeripheralClockConfig = &Mcu_RootPeripheralClockConfig[0],
    },
    [1] = {
        .SystemClockSource = MCU_SYSTEM_CLOCK_SOURCE_FIRC,
        .CoreClockDiv = 3U,
        .FastBusClockDiv = 0U,
        .SlowBusClockDiv = 1U,
        .EfmPrescaleValue = 5U,
        .EfmWRSValue = 1U,

        .SircUnderUserCtrl = (boolean)STD_OFF,
        .SircConfig = &Mcu_RootSircConfig[1],

        .FircUnderUserCtrl = (boolean)STD_ON,
        .FircEnable = (boolean)STD_ON,
        .FircConfig = &Mcu_RootFircConfig[1],

        .FxoscUnderUserCtrl = (boolean)STD_OFF,
        .FxoscEnable = (boolean)STD_OFF,
        .FxoscConfig = &Mcu_RootFxoscConfig[1],
#if (MCU_NO_PLL == STD_OFF)
        .PllUnderUserCtrl = (boolean)STD_OFF,
        .PllEnable = (boolean)STD_OFF,
        .PllConfig = (Mcu_PllConfigType *)&Mcu_RootPllConfig[1],
#endif
        .ClockOutEnable = (boolean)STD_OFF,
        .ClockOutConfig = &Mcu_RootClockOutConfig[1],

        .ClockMonitorConfig = NULL_PTR,
        .ClockMonitorConfigNums = 0,

        .PeripheralClockConfig = &Mcu_RootPeripheralClockConfig[1],
    },
};

MCU_CONST const Mcu_ResetConfigType Mcu_RootResetConfig={
    .HwResetPinOutputEnable = STD_ON,
    .HwResetPinFilterEnable = STD_OFF,
    .HwResetPinFilterCount = 0U,
};

MCU_CONST const Mcu_PcuLvdConfigType Mcu_PcuLvdConfig = {
    .EnableBitList.BOREnable               = (boolean)STD_OFF,
    .EnableBitList.BORLowPowerModeEnable   = (boolean)STD_OFF,
    .EnableBitList.LVD1P5VEnable           = (boolean)STD_OFF,
    .EnableBitList.LVD5VEnable             = (boolean)STD_ON,
    .EnableBitList.LVD5VFilterEnable       = (boolean)STD_OFF,
    .EnableBitList.LVD5VIntEnable          = (boolean)STD_ON,
    .EnableBitList.LVD5VLowPowerModeEnable = (boolean)STD_ON,
    .EnableBitList.LVD5VReset              = (boolean)STD_ON,
    .LVD5VFilterWidth                      = (uint8)0,
    .LVD5VNotificationPtr                  = NULL_PTR,
    .LVD5VTrim                             = MCU_PCU_LVD5V_TRIM_2570MV,
    .LVD5VHysteresis                       = MCU_PCU_LVD5V_HYS_PERCENT_0P0
};

MCU_CONST const Mcu_PcuConfigType Mcu_PcuConfig = {
    .LvdConfigPtr = &Mcu_PcuLvdConfig,
    .SetCoreVoltage = STD_OFF,
    .PMCHPRDYConfigure = MCU_PCU_PMCHPRDY_DELAY_80US,
    .EnergySavingConfigure = MCU_PCU_ESCFG_INDEX_0,
};

MCU_CONST const Mcu_PowerModeType PowerModeMap[2]={
    MCU_POWER_MODE_RUN,
    MCU_POWER_MODE_STANDBY,
};


MCU_CONST const Mcu_PowerConfigType McuPowerConfig = {
    .ModeMap = PowerModeMap
};

const Mcu_ConfigType Mcu_PreCompileConfig ={
    .ClockConfig = Mcu_RootClockConfig,
    .ClockConfigNum = (2U),
    .RamSectionConfig = NULL_PTR,
    .ResetConfig = &Mcu_RootResetConfig,
    .RamSectionConfigNum = 0U,
    .ModeConfigNum = 2U,
    .PowerConfig = &McuPowerConfig,
    .PcuConfig = &Mcu_PcuConfig,
};


#define MCU_STOP_SEC_CONFIG_DATA_UNSPECIFIED
#include "Mcu_MemMap.h"

