/*
 * Copyright 2020-2025 Yuntu Microelectronics Co., Ltd.
 * All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 * 
 * @file Icu_PBcfg.c
 * @brief 
 * 
 */


#include "Icu.h"
#include "Icu_Lld_Etmr.h"
#include "Icu_Lld_Port.h"
#include "Icu_Base.h"
/*==================================================================================================
*                              SOURCE FILE VERSION INFORMATION
==================================================================================================*/
#define ICU_VENDOR_ID_PBCFG_C                      (180)
#define ICU_AR_RELEASE_MAJOR_VERSION_PBCFG_C       (4)
#define ICU_AR_RELEASE_MINOR_VERSION_PBCFG_C       (4)
#define ICU_AR_RELEASE_REVISION_VERSION_PBCFG_C    (0)
#define ICU_SW_MAJOR_VERSION_PBCFG_C               (2)
#define ICU_SW_MINOR_VERSION_PBCFG_C               (3)
#define ICU_SW_PATCH_VERSION_PBCFG_C               (0)

/*================================================================================================== */

 extern void Icu_SiginalUART2RXNotification(void); 
 extern void DrvRfReceive_ISR(void); 





#define ICU_START_SEC_CONFIG_DATA_UNSPECIFIED
#include "Icu_MemMap.h"

ICU_CONST const Icu_ChannelConfigType Icu_ChannelConfig[3] = 
{
    {
        .IcuChannelId = 0,
        .IcuHwIp = ICU_PORT,
        .IcuHwIpInstance = ICU_PORTA,
        .IcuHwChannel = 12,
        .IcuDefaultStartEdge = ICU_FALLING_EDGE,
        .IcuWakeupCapability = FALSE,
#if (ICU_WAKEUP_FUNCTIONALITY_API == STD_ON)
        .IcuWakeupSource = (EcuM_WakeupSourceType)0,
#endif
        .IcuMeasurementMode = ICU_MODE_SIGNAL_EDGE_DETECT,        
        .SignalNotificationPtr = Icu_SiginalUART2RXNotification,
    },
    {
        .IcuChannelId = 1,
        .IcuHwIp = ICU_PORT,
        .IcuHwIpInstance = ICU_PORTC,
        .IcuHwChannel = 8,
        .IcuDefaultStartEdge = ICU_FALLING_EDGE,
        .IcuWakeupCapability = FALSE,
#if (ICU_WAKEUP_FUNCTIONALITY_API == STD_ON)
        .IcuWakeupSource = (EcuM_WakeupSourceType)0,
#endif
        .IcuMeasurementMode = ICU_MODE_SIGNAL_EDGE_DETECT,        
        .SignalNotificationPtr = DrvRfReceive_ISR,
    },
    {
        .IcuChannelId = 2,
        .IcuHwIp = ICU_ETMR,
        .IcuHwIpInstance = ICU_ETMR0,
        .IcuHwChannel = 0,
        .IcuDefaultStartEdge = ICU_RISING_EDGE,
        .IcuWakeupCapability = FALSE,
#if (ICU_WAKEUP_FUNCTIONALITY_API == STD_ON)
        .IcuWakeupSource = (EcuM_WakeupSourceType)0,
#endif
        .IcuMeasurementMode = ICU_MODE_SIGNAL_MEASUREMENT,        
        .SignalMeasurementProperty = ICU_DUTY_CYCLE,
    },
};

 
ICU_CONST const IcuEtmrChannelType EtmrListChannels_0[1]=
{
    {         
        .ChannelNum = 0,
        },
};


ICU_CONST const Icu_EtmrConfigType Icu_EtmrConfig[1]=
{
    {
        .IcuEtmrModule = ICU_ETMR0,
        .IcuEtmrCount = 1,
        .IcuEtmrChannelPtr = (IcuEtmrChannelType*)EtmrListChannels_0,
        .IcuEtmrClockSource = ICU_MC_CLOCK_SOURCE_FASTBUSCLK,
        .IcuEtmrClockOthers = ICU_MC_CLOCK_OTHERS_EXTERNAL_IN0,
        .IcuEtmrPrescaler = 0,    
        .IcuEtmrModValue = 0,
    },    
};
/*
ICU_CONST const Icu_LptmrConfigType Icu_LptmrConfig[0]=
{

};
*/
 
ICU_CONST const IcuPortChannelType PortListChannels_0[1]=
{
    {         
        .PortChannel = 12,
        },
};
ICU_CONST const IcuPortChannelType PortListChannels_1[1]=
{
    {         
        .PortChannel = 8,
        },
};

ICU_CONST const Icu_PortConfigType Icu_PortConfig[2]=
{
    {
        .IcuPortModule = ICU_PORTA,
        .IcuPortCount = 2,
        .IcuPortChannelPtr = (IcuPortChannelType*)PortListChannels_0
    },
    {
        .IcuPortModule = ICU_PORTC,
        .IcuPortCount = 2,
        .IcuPortChannelPtr = (IcuPortChannelType*)PortListChannels_1
    },

};





ICU_CONST const Icu_HwInterruptConfigType Icu_HwInterruptConfig[3]=
{
    {         
        .IcuIsrHwId = ICU_PORT_0,
        .IcuIsrEnable = TRUE,     
    },
    {         
        .IcuIsrHwId = ICU_PORT_2,
        .IcuIsrEnable = TRUE,     
    },
    {         
        .IcuIsrHwId = ICU_ETMR_0_CH_0,
        .IcuIsrEnable = FALSE,     
    },
};
ICU_CONST const Icu_ConfigType Icu_PreCompileConfig ={
    .ChannelConfigPtr = (Icu_ChannelConfigType*)Icu_ChannelConfig,
    .IcuEtmrConfigPtr = (Icu_EtmrConfigType*) Icu_EtmrConfig,
    .IcuLptmrConfigPtr = (Icu_LptmrConfigType*)NULL_PTR,
    .IcuPortConfigPtr = (Icu_PortConfigType*) Icu_PortConfig,
    .IcuLpCmpConfigPtr = (Icu_LpCmpConfigType*) NULL_PTR,
    .IcuHwInterruptConfigPtr = (Icu_HwInterruptConfigType*)Icu_HwInterruptConfig,
#if WKU_SUPPORT == STD_ON
    .IcuWakeUpNotificationPtr = NULL_PTR,
#endif
    .IcuChannelCount = 3,
};
#define ICU_STOP_SEC_CONFIG_DATA_UNSPECIFIED
#include "Icu_MemMap.h"

