/*
 * Copyright 2020-2025 Yuntu Microelectronics Co., Ltd.
 * All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 * 
 * @file undefined
 * @brief 
 * 
 */

#include "Fls_Types.h"

/*==================================================================================================
*                              SOURCE FILE VERSION INFORMATION
==================================================================================================*/
#define FLS_VENDOR_ID_PBCFG_C                      (180)
#define FLS_AR_RELEASE_MAJOR_VERSION_PBCFG_C       (4)
#define FLS_AR_RELEASE_MINOR_VERSION_PBCFG_C       (4)
#define FLS_AR_RELEASE_REVISION_VERSION_PBCFG_C    (0)
#define FLS_SW_MAJOR_VERSION_PBCFG_C               (1)
#define FLS_SW_MINOR_VERSION_PBCFG_C               (0)
#define FLS_SW_PATCH_VERSION_PBCFG_C               (0)

/*==================================================================================================
 *                                       Function Prototypes
==================================================================================================*/
extern void Fee_JobEndNotification(void); 
extern void Fee_JobErrorNotification(void); 

#define FLS_START_SEC_CONFIG_DATA_UNSPECIFIED
#include "Fls_MemMap.h"
/*================================================================================================== */
FLS_CONST const Fls_SectorType Fls_SectorConfig[40] ={
    {
                        
        .SectorId = FlsConf_FlsConfigSet_FlsSector_0,
        .SectorStartAddress = 0x0U,
        .SectorSize = 0x200U,
        .PageSize = 0x8U,
        .SectorHwStartAddress = 0x10001000U,
        .AsyncAccess = FALSE,
    },
    {
                        
        .SectorId = FlsConf_FlsConfigSet_FlsSector_1,
        .SectorStartAddress = 0x200U,
        .SectorSize = 0x200U,
        .PageSize = 0x8U,
        .SectorHwStartAddress = 0x10001200U,
        .AsyncAccess = FALSE,
    },
    {
                        
        .SectorId = FlsConf_FlsConfigSet_FlsSector_2,
        .SectorStartAddress = 0x400U,
        .SectorSize = 0x200U,
        .PageSize = 0x8U,
        .SectorHwStartAddress = 0x10001400U,
        .AsyncAccess = FALSE,
    },
    {
                        
        .SectorId = FlsConf_FlsConfigSet_FlsSector_3,
        .SectorStartAddress = 0x600U,
        .SectorSize = 0x200U,
        .PageSize = 0x8U,
        .SectorHwStartAddress = 0x10001600U,
        .AsyncAccess = FALSE,
    },
    {
                        
        .SectorId = FlsConf_FlsConfigSet_FlsSector_4,
        .SectorStartAddress = 0x800U,
        .SectorSize = 0x200U,
        .PageSize = 0x8U,
        .SectorHwStartAddress = 0x10001800U,
        .AsyncAccess = FALSE,
    },
    {
                        
        .SectorId = FlsConf_FlsConfigSet_FlsSector_5,
        .SectorStartAddress = 0xa00U,
        .SectorSize = 0x200U,
        .PageSize = 0x8U,
        .SectorHwStartAddress = 0x10001a00U,
        .AsyncAccess = FALSE,
    },
    {
                        
        .SectorId = FlsConf_FlsConfigSet_FlsSector_6,
        .SectorStartAddress = 0xc00U,
        .SectorSize = 0x200U,
        .PageSize = 0x8U,
        .SectorHwStartAddress = 0x10001c00U,
        .AsyncAccess = FALSE,
    },
    {
                        
        .SectorId = FlsConf_FlsConfigSet_FlsSector_7,
        .SectorStartAddress = 0xe00U,
        .SectorSize = 0x200U,
        .PageSize = 0x8U,
        .SectorHwStartAddress = 0x10001e00U,
        .AsyncAccess = FALSE,
    },
    {
                        
        .SectorId = FlsConf_FlsConfigSet_FlsSector_8,
        .SectorStartAddress = 0x1000U,
        .SectorSize = 0x200U,
        .PageSize = 0x8U,
        .SectorHwStartAddress = 0x10002000U,
        .AsyncAccess = FALSE,
    },
    {
                        
        .SectorId = FlsConf_FlsConfigSet_FlsSector_9,
        .SectorStartAddress = 0x1200U,
        .SectorSize = 0x200U,
        .PageSize = 0x8U,
        .SectorHwStartAddress = 0x10002200U,
        .AsyncAccess = FALSE,
    },
    {
                        
        .SectorId = FlsConf_FlsConfigSet_FlsSector_10,
        .SectorStartAddress = 0x1400U,
        .SectorSize = 0x200U,
        .PageSize = 0x8U,
        .SectorHwStartAddress = 0x10002400U,
        .AsyncAccess = FALSE,
    },
    {
                        
        .SectorId = FlsConf_FlsConfigSet_FlsSector_11,
        .SectorStartAddress = 0x1600U,
        .SectorSize = 0x200U,
        .PageSize = 0x8U,
        .SectorHwStartAddress = 0x10002600U,
        .AsyncAccess = FALSE,
    },
    {
                        
        .SectorId = FlsConf_FlsConfigSet_FlsSector_12,
        .SectorStartAddress = 0x1800U,
        .SectorSize = 0x200U,
        .PageSize = 0x8U,
        .SectorHwStartAddress = 0x10002800U,
        .AsyncAccess = FALSE,
    },
    {
                        
        .SectorId = FlsConf_FlsConfigSet_FlsSector_13,
        .SectorStartAddress = 0x1a00U,
        .SectorSize = 0x200U,
        .PageSize = 0x8U,
        .SectorHwStartAddress = 0x10002a00U,
        .AsyncAccess = FALSE,
    },
    {
                        
        .SectorId = FlsConf_FlsConfigSet_FlsSector_14,
        .SectorStartAddress = 0x1c00U,
        .SectorSize = 0x200U,
        .PageSize = 0x8U,
        .SectorHwStartAddress = 0x10002c00U,
        .AsyncAccess = FALSE,
    },
    {
                        
        .SectorId = FlsConf_FlsConfigSet_FlsSector_15,
        .SectorStartAddress = 0x1e00U,
        .SectorSize = 0x200U,
        .PageSize = 0x8U,
        .SectorHwStartAddress = 0x10002e00U,
        .AsyncAccess = FALSE,
    },
    {
                        
        .SectorId = FlsConf_FlsConfigSet_FlsSector_16,
        .SectorStartAddress = 0x2000U,
        .SectorSize = 0x200U,
        .PageSize = 0x8U,
        .SectorHwStartAddress = 0x10003000U,
        .AsyncAccess = FALSE,
    },
    {
                        
        .SectorId = FlsConf_FlsConfigSet_FlsSector_17,
        .SectorStartAddress = 0x2200U,
        .SectorSize = 0x200U,
        .PageSize = 0x8U,
        .SectorHwStartAddress = 0x10003200U,
        .AsyncAccess = FALSE,
    },
    {
                        
        .SectorId = FlsConf_FlsConfigSet_FlsSector_18,
        .SectorStartAddress = 0x2400U,
        .SectorSize = 0x200U,
        .PageSize = 0x8U,
        .SectorHwStartAddress = 0x10003400U,
        .AsyncAccess = FALSE,
    },
    {
                        
        .SectorId = FlsConf_FlsConfigSet_FlsSector_19,
        .SectorStartAddress = 0x2600U,
        .SectorSize = 0x200U,
        .PageSize = 0x8U,
        .SectorHwStartAddress = 0x10003600U,
        .AsyncAccess = FALSE,
    },
    {
                        
        .SectorId = FlsConf_FlsConfigSet_FlsSector_20,
        .SectorStartAddress = 0x2800U,
        .SectorSize = 0x200U,
        .PageSize = 0x8U,
        .SectorHwStartAddress = 0x10011000U,
        .AsyncAccess = TRUE,
    },
    {
                        
        .SectorId = FlsConf_FlsConfigSet_FlsSector_21,
        .SectorStartAddress = 0x2a00U,
        .SectorSize = 0x200U,
        .PageSize = 0x8U,
        .SectorHwStartAddress = 0x10011200U,
        .AsyncAccess = TRUE,
    },
    {
                        
        .SectorId = FlsConf_FlsConfigSet_FlsSector_22,
        .SectorStartAddress = 0x2c00U,
        .SectorSize = 0x200U,
        .PageSize = 0x8U,
        .SectorHwStartAddress = 0x10011400U,
        .AsyncAccess = TRUE,
    },
    {
                        
        .SectorId = FlsConf_FlsConfigSet_FlsSector_23,
        .SectorStartAddress = 0x2e00U,
        .SectorSize = 0x200U,
        .PageSize = 0x8U,
        .SectorHwStartAddress = 0x10011600U,
        .AsyncAccess = TRUE,
    },
    {
                        
        .SectorId = FlsConf_FlsConfigSet_FlsSector_24,
        .SectorStartAddress = 0x3000U,
        .SectorSize = 0x200U,
        .PageSize = 0x8U,
        .SectorHwStartAddress = 0x10011800U,
        .AsyncAccess = TRUE,
    },
    {
                        
        .SectorId = FlsConf_FlsConfigSet_FlsSector_25,
        .SectorStartAddress = 0x3200U,
        .SectorSize = 0x200U,
        .PageSize = 0x8U,
        .SectorHwStartAddress = 0x10011a00U,
        .AsyncAccess = TRUE,
    },
    {
                        
        .SectorId = FlsConf_FlsConfigSet_FlsSector_26,
        .SectorStartAddress = 0x3400U,
        .SectorSize = 0x200U,
        .PageSize = 0x8U,
        .SectorHwStartAddress = 0x10011c00U,
        .AsyncAccess = TRUE,
    },
    {
                        
        .SectorId = FlsConf_FlsConfigSet_FlsSector_27,
        .SectorStartAddress = 0x3600U,
        .SectorSize = 0x200U,
        .PageSize = 0x8U,
        .SectorHwStartAddress = 0x10011e00U,
        .AsyncAccess = TRUE,
    },
    {
                        
        .SectorId = FlsConf_FlsConfigSet_FlsSector_28,
        .SectorStartAddress = 0x3800U,
        .SectorSize = 0x200U,
        .PageSize = 0x8U,
        .SectorHwStartAddress = 0x10012000U,
        .AsyncAccess = TRUE,
    },
    {
                        
        .SectorId = FlsConf_FlsConfigSet_FlsSector_29,
        .SectorStartAddress = 0x3a00U,
        .SectorSize = 0x200U,
        .PageSize = 0x8U,
        .SectorHwStartAddress = 0x10012200U,
        .AsyncAccess = TRUE,
    },
    {
                        
        .SectorId = FlsConf_FlsConfigSet_FlsSector_30,
        .SectorStartAddress = 0x3c00U,
        .SectorSize = 0x200U,
        .PageSize = 0x8U,
        .SectorHwStartAddress = 0x10012400U,
        .AsyncAccess = TRUE,
    },
    {
                        
        .SectorId = FlsConf_FlsConfigSet_FlsSector_31,
        .SectorStartAddress = 0x3e00U,
        .SectorSize = 0x200U,
        .PageSize = 0x8U,
        .SectorHwStartAddress = 0x10012600U,
        .AsyncAccess = TRUE,
    },
    {
                        
        .SectorId = FlsConf_FlsConfigSet_FlsSector_32,
        .SectorStartAddress = 0x4000U,
        .SectorSize = 0x200U,
        .PageSize = 0x8U,
        .SectorHwStartAddress = 0x10012800U,
        .AsyncAccess = TRUE,
    },
    {
                        
        .SectorId = FlsConf_FlsConfigSet_FlsSector_33,
        .SectorStartAddress = 0x4200U,
        .SectorSize = 0x200U,
        .PageSize = 0x8U,
        .SectorHwStartAddress = 0x10012a00U,
        .AsyncAccess = TRUE,
    },
    {
                        
        .SectorId = FlsConf_FlsConfigSet_FlsSector_34,
        .SectorStartAddress = 0x4400U,
        .SectorSize = 0x200U,
        .PageSize = 0x8U,
        .SectorHwStartAddress = 0x10012c00U,
        .AsyncAccess = TRUE,
    },
    {
                        
        .SectorId = FlsConf_FlsConfigSet_FlsSector_35,
        .SectorStartAddress = 0x4600U,
        .SectorSize = 0x200U,
        .PageSize = 0x8U,
        .SectorHwStartAddress = 0x10012e00U,
        .AsyncAccess = TRUE,
    },
    {
                        
        .SectorId = FlsConf_FlsConfigSet_FlsSector_36,
        .SectorStartAddress = 0x4800U,
        .SectorSize = 0x200U,
        .PageSize = 0x8U,
        .SectorHwStartAddress = 0x10013000U,
        .AsyncAccess = TRUE,
    },
    {
                        
        .SectorId = FlsConf_FlsConfigSet_FlsSector_37,
        .SectorStartAddress = 0x4a00U,
        .SectorSize = 0x200U,
        .PageSize = 0x8U,
        .SectorHwStartAddress = 0x10013200U,
        .AsyncAccess = TRUE,
    },
    {
                        
        .SectorId = FlsConf_FlsConfigSet_FlsSector_38,
        .SectorStartAddress = 0x4c00U,
        .SectorSize = 0x200U,
        .PageSize = 0x8U,
        .SectorHwStartAddress = 0x10013400U,
        .AsyncAccess = TRUE,
    },
    {
                        
        .SectorId = FlsConf_FlsConfigSet_FlsSector_39,
        .SectorStartAddress = 0x4e00U,
        .SectorSize = 0x200U,
        .PageSize = 0x8U,
        .SectorHwStartAddress = 0x10013600U,
        .AsyncAccess = TRUE,
    },
};


FLS_CONST const Fls_ConfigType Fls_Config = {
    .AcEraseFunPtr = NULL_PTR,
    .AcWriteFunPtr = NULL_PTR,
    .JobEndNotificationFunPtr = Fee_JobEndNotification,
    .JobErrorNotificationFunPtr = Fee_JobErrorNotification,
    .DefaultMode = MEMIF_MODE_SLOW,
    .MaxReadFastMode = 10240U,
    .MaxReadNormalMode = 1024U,
    .MaxWriteFastMode = 256U,
    .MaxWriteNormalMode = 8U,
    .ConfiguredSectorNumber = 40U,
    .SectorList = Fls_SectorConfig,
};

#define FLS_STOP_SEC_CONFIG_DATA_UNSPECIFIED
#include "Fls_MemMap.h"

