/*
 * Copyright 2020-2025 Yuntu Microelectronics Co., Ltd.
 * All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 * 
 * @file Fee_Cfg.c
 * @brief 
 * 
 */


#ifdef __cplusplus
extern "C"{
#endif

/*==================================================================================================
*                                        INCLUDE FILES
==================================================================================================*/
#include "Fee.h"

/*==================================================================================================
*                              SOURCE FILE VERSION INFORMATION
==================================================================================================*/
#define FEE_VENDOR_ID_CFG_C                      (180)
#define FEE_AR_RELEASE_MAJOR_VERSION_CFG_C       (4)
#define FEE_AR_RELEASE_MINOR_VERSION_CFG_C       (4)
#define FEE_AR_RELEASE_REVISION_VERSION_CFG_C    (0)
#define FEE_SW_MAJOR_VERSION_CFG_C               (1)
#define FEE_SW_MINOR_VERSION_CFG_C               (0)
#define FEE_SW_PATCH_VERSION_CFG_C               (0)

/*==================================================================================================
                                      FILE VERSION CHECKS
==================================================================================================*/
/* Check if source file and Fee header file are of the same vendor */
#if (FEE_VENDOR_ID_CFG_C != FEE_VENDOR_ID)
    #error "Fee_Cfg.c and Fee.h have different vendor ids"
#endif
/* Check if current file and Fee header file are of the same Autosar version */
#if ((FEE_AR_RELEASE_MAJOR_VERSION_CFG_C    != FEE_AR_RELEASE_MAJOR_VERSION) || \
     (FEE_AR_RELEASE_MINOR_VERSION_CFG_C    != FEE_AR_RELEASE_MINOR_VERSION) || \
     (FEE_AR_RELEASE_REVISION_VERSION_CFG_C != FEE_AR_RELEASE_REVISION_VERSION) \
    )
    #error "AutoSar Version Numbers of Fee_Cfg.c and Fee.h are different"
#endif
/* Check if current file and Fee header file are of the same Software version */
#if ((FEE_SW_MAJOR_VERSION_CFG_C != FEE_SW_MAJOR_VERSION) || \
     (FEE_SW_MINOR_VERSION_CFG_C != FEE_SW_MINOR_VERSION) || \
     (FEE_SW_PATCH_VERSION_CFG_C != FEE_SW_PATCH_VERSION) \
    )
    #error "Software Version Numbers of Fee_Cfg.c and Fee.h are different"
#endif

/*==================================================================================================
*                                        GLOBAL VARIABLES
==================================================================================================*/

#define FEE_START_SEC_CONFIG_DATA_UNSPECIFIED
#include "Fee_MemMap.h"

/* Configuration of cluster group BootData_Group */
FEE_CONST static const Fee_ClusterType Fee_BootData_Group[2] = 
{
    /* FeeCluster_0 */
    {
    .StartAddr = 0x0U,
    .Length = 0x200U,
    },
    /* FeeCluster_1 */
    {
    .StartAddr = 0x200U,
    .Length = 0x200U,
    },
};
/* Configuration of cluster group KeyData_Group */
FEE_CONST static const Fee_ClusterType Fee_KeyData_Group[2] = 
{
    /* FeeCluster_0 */
    {
    .StartAddr = 0x2800U,
    .Length = 0x400U,
    },
    /* FeeCluster_1 */
    {
    .StartAddr = 0x2c00U,
    .Length = 0x400U,
    },
};
/* Configuration of cluster group Diag_Group */
FEE_CONST static const Fee_ClusterType Fee_Diag_Group[2] = 
{
    /* FeeCluster_0 */
    {
    .StartAddr = 0x3000U,
    .Length = 0x400U,
    },
    /* FeeCluster_1 */
    {
    .StartAddr = 0x3400U,
    .Length = 0x400U,
    },
};
/* Configuration of cluster group Debug_Group */
FEE_CONST static const Fee_ClusterType Fee_Debug_Group[2] = 
{
    /* FeeCluster_0 */
    {
    .StartAddr = 0x3800U,
    .Length = 0x400U,
    },
    /* FeeCluster_1 */
    {
    .StartAddr = 0x3c00U,
    .Length = 0x400U,
    },
};
/* Configuration of cluster group KeyDataBackUp_Group */
FEE_CONST static const Fee_ClusterType Fee_KeyDataBackUp_Group[2] = 
{
    /* FeeCluster_0 */
    {
    .StartAddr = 0x4000U,
    .Length = 0x400U,
    },
    /* FeeCluster_1 */
    {
    .StartAddr = 0x4400U,
    .Length = 0x400U,
    },
};

/* Configuration of cluster group set */
FEE_CONST const Fee_ClusterGroupType Fee_ClrGrps[FEE_NUMBER_OF_CLUSTER_GROUPS] =
{
    /* BootData_Group */
    {
        .ClrPtr = Fee_BootData_Group,
        .ClrCount = 2U,
        .ReservedSize = 0U,
    },
    /* KeyData_Group */
    {
        .ClrPtr = Fee_KeyData_Group,
        .ClrCount = 2U,
        .ReservedSize = 0U,
    },
    /* Diag_Group */
    {
        .ClrPtr = Fee_Diag_Group,
        .ClrCount = 2U,
        .ReservedSize = 0U,
    },
    /* Debug_Group */
    {
        .ClrPtr = Fee_Debug_Group,
        .ClrCount = 2U,
        .ReservedSize = 0U,
    },
    /* KeyDataBackUp_Group */
    {
        .ClrPtr = Fee_KeyDataBackUp_Group,
        .ClrCount = 2U,
        .ReservedSize = 0U,
    },
};

/* Configuration of Fee blocks */
FEE_CONST const Fee_BlockConfigType Fee_BlockConfig[FEE_CRT_CFG_NR_OF_BLOCKS] =
{
    /* The Fee Block 1 */
    {
        .BlockNumber = 1U,
        .BlockSize = 8U,
        .ClrGrp = 0U,
        .ImmediateData = 0U,
#if (FEE_SWAP_FOREIGN_BLOCKS_ENABLED == STD_ON) 
        .BlockAssignment = FEE_PROJECT_APPLICATION,
#else
        .BlockAssignment = FEE_PROJECT_RESERVED,
#endif
    },
    /* The Fee Block 2 */
    {
        .BlockNumber = 2U,
        .BlockSize = 8U,
        .ClrGrp = 0U,
        .ImmediateData = 0U,
#if (FEE_SWAP_FOREIGN_BLOCKS_ENABLED == STD_ON) 
        .BlockAssignment = FEE_PROJECT_APPLICATION,
#else
        .BlockAssignment = FEE_PROJECT_RESERVED,
#endif
    },
    /* The Fee Block 3 */
    {
        .BlockNumber = 3U,
        .BlockSize = 16U,
        .ClrGrp = 0U,
        .ImmediateData = 0U,
#if (FEE_SWAP_FOREIGN_BLOCKS_ENABLED == STD_ON) 
        .BlockAssignment = FEE_PROJECT_APPLICATION,
#else
        .BlockAssignment = FEE_PROJECT_RESERVED,
#endif
    },
    /* The Fee Block 4 */
    {
        .BlockNumber = 4U,
        .BlockSize = 8U,
        .ClrGrp = 0U,
        .ImmediateData = 0U,
#if (FEE_SWAP_FOREIGN_BLOCKS_ENABLED == STD_ON) 
        .BlockAssignment = FEE_PROJECT_APPLICATION,
#else
        .BlockAssignment = FEE_PROJECT_RESERVED,
#endif
    },
    /* The Fee Block 5 */
    {
        .BlockNumber = 5U,
        .BlockSize = 24U,
        .ClrGrp = 1U,
        .ImmediateData = 0U,
#if (FEE_SWAP_FOREIGN_BLOCKS_ENABLED == STD_ON) 
        .BlockAssignment = FEE_PROJECT_APPLICATION,
#else
        .BlockAssignment = FEE_PROJECT_RESERVED,
#endif
    },
    /* The Fee Block 6 */
    {
        .BlockNumber = 6U,
        .BlockSize = 24U,
        .ClrGrp = 4U,
        .ImmediateData = 0U,
#if (FEE_SWAP_FOREIGN_BLOCKS_ENABLED == STD_ON) 
        .BlockAssignment = FEE_PROJECT_APPLICATION,
#else
        .BlockAssignment = FEE_PROJECT_RESERVED,
#endif
    },
    /* The Fee Block 7 */
    {
        .BlockNumber = 7U,
        .BlockSize = 24U,
        .ClrGrp = 1U,
        .ImmediateData = 0U,
#if (FEE_SWAP_FOREIGN_BLOCKS_ENABLED == STD_ON) 
        .BlockAssignment = FEE_PROJECT_APPLICATION,
#else
        .BlockAssignment = FEE_PROJECT_RESERVED,
#endif
    },
    /* The Fee Block 8 */
    {
        .BlockNumber = 8U,
        .BlockSize = 24U,
        .ClrGrp = 4U,
        .ImmediateData = 0U,
#if (FEE_SWAP_FOREIGN_BLOCKS_ENABLED == STD_ON) 
        .BlockAssignment = FEE_PROJECT_APPLICATION,
#else
        .BlockAssignment = FEE_PROJECT_RESERVED,
#endif
    },
    /* The Fee Block 9 */
    {
        .BlockNumber = 9U,
        .BlockSize = 8U,
        .ClrGrp = 2U,
        .ImmediateData = 0U,
#if (FEE_SWAP_FOREIGN_BLOCKS_ENABLED == STD_ON) 
        .BlockAssignment = FEE_PROJECT_APPLICATION,
#else
        .BlockAssignment = FEE_PROJECT_RESERVED,
#endif
    },
    /* The Fee Block 10 */
    {
        .BlockNumber = 10U,
        .BlockSize = 8U,
        .ClrGrp = 2U,
        .ImmediateData = 0U,
#if (FEE_SWAP_FOREIGN_BLOCKS_ENABLED == STD_ON) 
        .BlockAssignment = FEE_PROJECT_APPLICATION,
#else
        .BlockAssignment = FEE_PROJECT_RESERVED,
#endif
    },
    /* The Fee Block 11 */
    {
        .BlockNumber = 11U,
        .BlockSize = 8U,
        .ClrGrp = 2U,
        .ImmediateData = 0U,
#if (FEE_SWAP_FOREIGN_BLOCKS_ENABLED == STD_ON) 
        .BlockAssignment = FEE_PROJECT_APPLICATION,
#else
        .BlockAssignment = FEE_PROJECT_RESERVED,
#endif
    },
    /* The Fee Block 12 */
    {
        .BlockNumber = 12U,
        .BlockSize = 8U,
        .ClrGrp = 2U,
        .ImmediateData = 0U,
#if (FEE_SWAP_FOREIGN_BLOCKS_ENABLED == STD_ON) 
        .BlockAssignment = FEE_PROJECT_APPLICATION,
#else
        .BlockAssignment = FEE_PROJECT_RESERVED,
#endif
    },
    /* The Fee Block 13 */
    {
        .BlockNumber = 13U,
        .BlockSize = 8U,
        .ClrGrp = 2U,
        .ImmediateData = 0U,
#if (FEE_SWAP_FOREIGN_BLOCKS_ENABLED == STD_ON) 
        .BlockAssignment = FEE_PROJECT_APPLICATION,
#else
        .BlockAssignment = FEE_PROJECT_RESERVED,
#endif
    },
    /* The Fee Block 14 */
    {
        .BlockNumber = 14U,
        .BlockSize = 32U,
        .ClrGrp = 3U,
        .ImmediateData = 0U,
#if (FEE_SWAP_FOREIGN_BLOCKS_ENABLED == STD_ON) 
        .BlockAssignment = FEE_PROJECT_APPLICATION,
#else
        .BlockAssignment = FEE_PROJECT_RESERVED,
#endif
    },
    /* The Fee Block 15 */
    {
        .BlockNumber = 15U,
        .BlockSize = 8U,
        .ClrGrp = 2U,
        .ImmediateData = 0U,
#if (FEE_SWAP_FOREIGN_BLOCKS_ENABLED == STD_ON) 
        .BlockAssignment = FEE_PROJECT_APPLICATION,
#else
        .BlockAssignment = FEE_PROJECT_RESERVED,
#endif
    },
};

#define FEE_STOP_SEC_CONFIG_DATA_UNSPECIFIED
#include "Fee_MemMap.h"

#ifdef __cplusplus
}
#endif

/** @} */

