/*
 * Copyright 2020-2025 Yuntu Microelectronics Co., Ltd.
 * All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 * 
 * @file undefined
 * @brief 
 * 
 */

#include "Adc.h"
#include "Adc_Cfg.h"
#ifdef ADC_DMA_SUPPORTED
#include "CddDma_Cfg.h"
#endif

/*==================================================================================================
*                              SOURCE FILE VERSION INFORMATION
==================================================================================================*/
#define ADC_VENDOR_ID_PBCFG_C                      (180)
#define ADC_AR_RELEASE_MAJOR_VERSION_PBCFG_C       (4)
#define ADC_AR_RELEASE_MINOR_VERSION_PBCFG_C       (4)
#define ADC_AR_RELEASE_REVISION_VERSION_PBCFG_C    (0)
#define ADC_SW_MAJOR_VERSION_PBCFG_C               (2)
#define ADC_SW_MINOR_VERSION_PBCFG_C               (3)
#define ADC_SW_PATCH_VERSION_PBCFG_C               (0)

/*================================================================================================== */

/*****************************************************************************************************/


#define ADC_START_SEC_CONFIG_DATA_UNSPECIFIED
#include "Adc_MemMap.h"

/*Group channels definetion*/
ADC_CONST static const Adc_ChannelType AdcGroup_0_Channel[1] = 
{
    ADC0_SE20_ADCH20,
};

/**/

ADC_CONST static const Adc_GroupDefType AdcGroup_0_ChannelsInf = 
{
    .GroupChannels       = &AdcGroup_0_Channel[0],
    .GroupChannelsNum    = 1,
    .GroupInHwUnitId     = ADC_0,
};


#if (ADC_UNIT_NUMBER != 0)
#if (ADC_UNIT_NUMBER > ADC_MAX_HW_UNITS)
    #error "Config too many ADC Hw Unit !"
#else
ADC_CONST const Adc_HwUnitType Adc_HwUnitConfiguration[ADC_UNIT_NUMBER] = {
{ 
    .HwUnitId = ADC_0,
    .ClockSource = ADC_BUSCLK,
    .Prescale = 0,
        .StartupTime = 41,
    .InternalTempSensor = FALSE,
},
};
#endif /* ADC_UNIT_NUMBER > ADC_MAX_HW_UNITS */
#endif /* ADC_UNIT_NUMBER != 0 */

ADC_CONST const Adc_ChannelSampleType AdcGroup_0_ChannelSample = {
    .ChannelSampTime = 18,
    .ChannelConvTime = 0,
    .ChannelRefVoltsrcHigh = 0,
    .ChannelRefVoltsrcLow = 0,
    .ChannelResolution = ADC_RESOLUTION_10BIT,
};

ADC_CONST const Adc_GroupSampleType AdcGroup_0_Configuration = 
{
    .GroupAccessMode = ADC_ACCESS_MODE_SINGLE,
    .GroupConversionMode = ADC_CONV_MODE_ONESHOT,
#if (ADC_PRIORITY_IMPLEMENTATION != ADC_PRIORITY_NONE)
    .GroupPriority = 0,
#endif /* (ADC_PRIORITY_IMPLEMENTATION != ADC_PRIORITY_NONE) */
    .GroupReplacement = ADC_GROUP_REPL_ABORT_RESTART,
    .GroupTriggSrc = ADC_TRIGG_SRC_SW,
#if (ADC_HW_TRIGGER_API == STD_ON)
    .HwTrigSrc = (Adc_HwTriggerSourceType)0U,
#endif /* (ADC_HW_TRIGGER_API == STD_ON) */
    .StreamingBufferMode = ADC_STREAM_BUFFER_LINEAR,
    .StreamingNumSamples = 1,
    .GroupDefinition = &AdcGroup_0_ChannelsInf,
    .NotificationFunc = NULL_PTR,
    .IntcAndDmaCfg = ADC_INTCANDDMA_DISABLED,
};

ADC_CONST const Adc_GroupConfigType Adc_GourpsConfiguration[1] = 
{
    {
        .GroupId = AdcConf_AdcConfigSet_AdcGroup_0,
        .GroupSample = &AdcGroup_0_Configuration,
        .ChannelSample = &AdcGroup_0_ChannelSample,
    },
};
ADC_CONST const Adc_ConfigType Adc_PreCompileConfig =
{
    .GroupCfgNum    = ADC_GROUP_NUMBER,
    .HwUnitCfgNum   = ADC_UNIT_NUMBER,
    .HwUnitUserCfg = &Adc_HwUnitConfiguration[0],
    .GroupUserCfg  = &Adc_GourpsConfiguration[0],
};

#define ADC_STOP_SEC_CONFIG_DATA_UNSPECIFIED
#include "Adc_MemMap.h"

