/* USER CODE BEGIN Header */
/* you can remove the copyright */

/*
 *  Copyright 2020-2023 Yuntu Microelectronics co.,ltd
 *  All rights reserved.
 * 
 *  YUNTU Confidential. This software is owned or controlled by YUNTU and may only be
 *  used strictly in accordance with the applicable license terms. By expressly
 *  accepting such terms or by downloading, installing, activating and/or otherwise
 *  using the software, you are agreeing that you have read, and that you agree to
 *  comply with and are bound by, such license terms. If you do not agree to be
 *  bound by the applicable license terms, then you may not retain, install,
 *  activate or otherwise use the software. The production use license in
 *  Section 2.3 is expressly granted for this software.
 * 
 * @file main.c
 * @brief 
 * 
 */

/* USER CODE END Header */
#include "sdk_project_config.h"
/* Includes ------------------------------------------------------------------*/

/* Private includes ----------------------------------------------------------*/
/* USER CODE BEGIN Includes */
/* USER CODE END Includes */

/* Private typedef -----------------------------------------------------------*/
/* USER CODE BEGIN PTD */
/* USER CODE END PTD */

/* Private define ------------------------------------------------------------*/
/* USER CODE BEGIN PD */
#define PRINTF_UART (2)
#define I2C_INST    (0)
/* USER CODE END PD */

/* Private macro -------------------------------------------------------------*/
/* USER CODE BEGIN PM */
#define BUFF_SIZE 8
/* USER CODE END PM */

/* Private variables ---------------------------------------------------------*/
/* USER CODE BEGIN PV */
uint8_t masterTxBuffer[BUFF_SIZE];
uint8_t masterRxBuffer[BUFF_SIZE];
uint8_t slaveTxBuffer[BUFF_SIZE];
uint8_t slaveRxBuffer[BUFF_SIZE];
uint8_t slaveRxBuffer_test[5][BUFF_SIZE];
/* USER CODE END PV */

/* Private function declare --------------------------------------------------*/
/* USER CODE BEGIN PFDC */
/* USER CODE END PFDC */
static void Board_Init(void);

/* Private user code ---------------------------------------------------------*/
/* USER CODE BEGIN 0 */
uint8_t asd[2] = {0};
void I2C0_SlaveRxCpltCallback(i2c_slave_event_t event, void *userData)
{
    /* Get the instance number from userData */
    uint32_t instance = 0;
    (void)userData;
    /* Depending on the event received, set the buffers or abort the transfer */
    switch (event)
    {
        case I2C_SLAVE_EVENT_RX_REQ:
            /*
             * If the bus master requests data, then set the destination RX buffer
             * and accepted transfer size
             */
              if(asd[0] == 0)
              {
                  memcpy(slaveRxBuffer_test[0], slaveRxBuffer, BUFF_SIZE);          
              }
              else if(asd[0] == 1)
              {
                  memcpy(slaveRxBuffer_test[1], slaveRxBuffer, BUFF_SIZE);   
              }
              else if(asd[0] == 2)
              {
                  memcpy(slaveRxBuffer_test[2], slaveRxBuffer, BUFF_SIZE);  
              }

              I2C_DRV_SlaveSetRxBuffer(instance, slaveRxBuffer, BUFF_SIZE);
              asd[0]++;
              if(asd[0] == 3)
              {
                  memcpy(slaveRxBuffer_test[3], slaveRxBuffer, BUFF_SIZE);  
              }
            break;
        case I2C_SLAVE_EVENT_TX_REQ:
            /*
             * If the bus master sends data, then set the source TX buffer
             * and accepted transfer size
             */
              I2C_DRV_SlaveSetTxBuffer(instance, slaveTxBuffer, BUFF_SIZE);
            break;
        case I2C_SLAVE_EVENT_TX_EMPTY:
            /*
             * If the TX buffer is empty. Because the example does not handle 
             * this case there is no action taken.
             */
        case I2C_SLAVE_EVENT_RX_FULL:
            /*
             * If the RX buffer is full, check the slave receive buffer is correct
             */
            I2C_DRV_SlaveSetRxBuffer(instance, slaveRxBuffer, BUFF_SIZE);
            break;
        case I2C_SLAVE_EVENT_STOP:
            /*
             * This case is used when a stop condition is on the bus. Because
             * the example does not handle this case there is no action taken.
//             */
              memcpy(slaveRxBuffer_test[4], slaveRxBuffer, BUFF_SIZE); 
              asd[1]++;
//            g_i2cCompleteFlag = true;
            break;
    }  
}

//void I2C_ReceiveDataISR(uint8_t *RData, uint32_t RLen)
//{
//    memcpy(&IIC_RevDataStruct.I2cReceiveBuf[0], RData, RLen);
//    IIC_RevDataStruct.RevLength = RLen;
//    memset(RData, 0, RLen);
//}
/* USER CODE END 0 */


/**
 * @brief  The application entry point.
 * @retval int
 */
int main(void)
{
    /* USER CODE BEGIN 1 */
    status_t status = STATUS_SUCCESS;
    /* USER CODE END 1 */ 
    Board_Init();
    /* USER CODE BEGIN 2 */
    I2C_DRV_SlaveSetRxBuffer(0, slaveRxBuffer, BUFF_SIZE);
    
    for (uint8_t i = 0; i < BUFF_SIZE; i++)
    {
        masterTxBuffer[i] = i;
    }
    /* USER CODE END 2 */

    /* Infinite loop */
    /* USER CODE BEGIN WHILE */
    uint32_t num = 0;
    while (1)
    {
      num++;
      OSIF_TimeDelay(100);
      if(num <= 3)
      {
        I2C_DRV_MasterSendDataBlocking(1,masterTxBuffer,8,1,100);
//        while (STATUS_SUCCESS != I2C_DRV_MasterGetTransferStatus(1, NULL))
//            ;
        for (uint8_t i = 0; i < BUFF_SIZE; i++)
        {
            masterTxBuffer[i] = i+num;
        }        
      }
      if(num >= 100)
      {
        num = 3;
      }
        /* USER CODE END WHILE */
        /* USER CODE BEGIN 3 */
    }
    /* USER CODE END 3 */
}

static void Board_Init(void)
{
    CLOCK_SYS_Init(g_clockManConfigsArr,CLOCK_MANAGER_CONFIG_CNT,g_clockManCallbacksArr,CLOCK_MANAGER_CALLBACK_CNT);
    CLOCK_SYS_UpdateConfiguration(CLOCK_MANAGER_ACTIVE_INDEX,CLOCK_MANAGER_POLICY_AGREEMENT);
    PINS_DRV_Init(NUM_OF_CONFIGURED_PINS0,g_pin_mux_InitConfigArr0);
    UTILITY_PRINT_Init();
    I2C_DRV_SlaveInit(0,&I2C_SlaveConfig0,&I2C_SlaveConfig0_State);
    I2C_DRV_MasterInit(1,&I2C_MasterConfig0,&I2C_MasterConfig0_State);
}

/* USER CODE BEGIN 4 */
/* USER CODE END 4 */
