/*
 * Copyright 2020-2025 Yuntu Microelectronics Co., Ltd.
 * All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 * 
 * @file RamInit2.c
 * @brief 
 * 
 */

#include "stdint.h"
#include "device_registers.h"

/**
 * @brief Check MCU is power on reset or not, user can override this function
 * @return 1: POR, 0: Not POR
 */
#define RCU_RSSR_POR_MASK   (0x1U)
__attribute__((weak)) int IsPOR(){
    int RetVal = 0U;

    /* Check if the MCU is power on reset or not */
    if (RCU_RSSR_POR_MASK == (RCU->RSSR & RCU_RSSR_POR_MASK))
    {
        RetVal = 1U;
    }

    return RetVal;
}

#define WORD_ALIGN_MASK (3U)
#define WORD_SHIFT      (2U)



typedef struct
{
    uint32_t *RamStart;   /*!< Start address of section in RAM */
    uint32_t *RamEnd;     /*!< End address of section in RAM */
} RamZeroLayoutType;



/**
 * @brief RAM initialization for POR only regions
 */
void RamInit2(){
    /* No POR need to initialize */
}


