/*
 *  Copyright 2020-2024 Yuntu Microelectronics co.,ltd
 *  All rights reserved.
 * 
 *  YUNTU Confidential. This software is owned or controlled by YUNTU and may only be
 *  used strictly in accordance with the applicable license terms. By expressly
 *  accepting such terms or by downloading, installing, activating and/or otherwise
 *  using the software, you are agreeing that you have read, and that you agree to
 *  comply with and are bound by, such license terms. If you do not agree to be
 *  bound by the applicable license terms, then you may not retain, install,
 *  activate or otherwise use the software. The production use license in
 *  Section 2.3 is expressly granted for this software.
 * 
 * @file lin_sync_api.h
 * @brief 
 * 
 */

#ifndef LIN_SYNC_API_H
#define LIN_SYNC_API_H

#include "sdk_project_config.h"
#include "lin_cfg.h"
#include <stdint.h>


typedef struct{
    uint32_t uartInstance;
    bool isSyncing;
    uint32_t capturedValue;
    uint32_t previousCounterValue;
    uint32_t bitTimeLength[11];
    uint32_t edgeCount;
    uint32_t averageBitTimeLength;
    uint32_t nominalBaudrateHz;
    uint16_t nominalOsr;
    uint16_t nominalSbr;
    uint32_t currentBaudrateHz;
}lin_sync_t;


extern lin_sync_t g_linSync;


void LinSync_Init(lin_sync_t *linSync, uint32_t nominalBaudrateHz);
status_t LinSync_AutoBaudCapture(lin_sync_t *linSync);
#endif
