/*
 *  Copyright 2020-2024 Yuntu Microelectronics co.,ltd
 *  All rights reserved.
 * 
 *  YUNTU Confidential. This software is owned or controlled by YUNTU and may only be
 *  used strictly in accordance with the applicable license terms. By expressly
 *  accepting such terms or by downloading, installing, activating and/or otherwise
 *  using the software, you are agreeing that you have read, and that you agree to
 *  comply with and are bound by, such license terms. If you do not agree to be
 *  bound by the applicable license terms, then you may not retain, install,
 *  activate or otherwise use the software. The production use license in
 *  Section 2.3 is expressly granted for this software.
 * 
 * @file interrupt_config.c
 * @brief 
 * 
 */


#include <stddef.h>
#include "interrupt_config.h"

extern void LinSync_lptmrIsrHandler(void);
extern void LinSync_RxPinIrqHandler(void);

void INT_SYS_ConfigInit()
{
    INT_SYS_DisableIRQGlobal();
    /* lpTMR0_IRQn(8) lpTMR0_IRQHandler*/
    INT_SYS_SetPriority(lpTMR0_IRQn,1);
    INT_SYS_EnableIRQ(lpTMR0_IRQn);
    INT_SYS_InstallHandler(lpTMR0_IRQn,LinSync_lptmrIsrHandler,NULL);
    /* GPIO_IRQn(9) GPIO_IRQHandler*/
    INT_SYS_SetPriority(GPIO_IRQn,0);
    INT_SYS_EnableIRQ(GPIO_IRQn);
    INT_SYS_InstallHandler(GPIO_IRQn,LinSync_RxPinIrqHandler,NULL);
    /* UART0_IRQn(31) UART0_IRQHandler*/
    INT_SYS_SetPriority(UART0_IRQn,1);
    INT_SYS_EnableIRQ(UART0_IRQn);
    INT_SYS_EnableIRQGlobal();
}
