/*
 *  Copyright 2020-2024 Yuntu Microelectronics co.,ltd
 *  All rights reserved.
 * 
 *  YUNTU Confidential. This software is owned or controlled by YUNTU and may only be
 *  used strictly in accordance with the applicable license terms. By expressly
 *  accepting such terms or by downloading, installing, activating and/or otherwise
 *  using the software, you are agreeing that you have read, and that you agree to
 *  comply with and are bound by, such license terms. If you do not agree to be
 *  bound by the applicable license terms, then you may not retain, install,
 *  activate or otherwise use the software. The production use license in
 *  Section 2.3 is expressly granted for this software.
 * 
 * @file lin_cfg.h
 * @brief 
 * 
 */

 #ifndef LIN_CFG_H
#define LIN_CFG_H

#include "sdk_project_config.h"


/* 在同步场中，获取当前的计数器值 */
#define LIN_SYNC_TIMER_GET_COUNTER_VALUE()        (pTMR0->CH[0].TCV)
#define LIN_SYNC_TIMER_CLOCK_HZ                 (24000000U)
/* 配置当前LIN_RX引脚的GPIO和PORT */
#define LIN_SYNC_RX_GPIO                    (GPIOA)
#define LIN_SYNC_RX_PORT                    (PCTRLA)
#define LIN_SYNC_RX_PIN_INDEX               (2)
#define LIN_SYNC_RX_PORT_MUX_ALTx           (PCTRL_MUX_ALT6)


//lin的时间机制的参数，本例程用的是lptmr, 负责timeout和唤醒的定时器
#define TIMER_COMPARE_VAL_MICROSECONDS  (uint16_t)(52U)
#define TIMER_TICKS_1US                 (uint16_t)(12U)
#define TIMER_TOTAL_TICKS               (TIMER_COMPARE_VAL_MICROSECONDS  * TIMER_TICKS_1US)
#endif