/*
 * Copyright 2020-2025 Yuntu Microelectronics Co., Ltd.
 * All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 * 
 * @file eadc_config.c
 * @brief 
 * 
 */


#include "eadc_config.h"


const eadc_compare_config_t eadc_config0CompCfg[1] = {
    {
        .comWdchIndex=0,    
        .compareEnable=false,
        .compareAllChannelEnable=false,
        .compChalSel=eADC_INPUTCHAN_EXT0,
        .compHigh=4095,
        .compLow=0,
        .effectiveMode=eADC_AWG_EFFECTIVE_OUTSIDE,
    },
};

/* eadc_config0 */
const eadc_converter_config_t eadc_config0={
    .clockDivider=0,
    .startTime=40,
    .switchChannelCnt=8,
    .sampleTime0=2,
    .sampleTime1=2,
    .sampleAverage=eADC_RESULT_NO_AVERAGE,

    .autoOffEnable=false,
    .lowPowerEnable=false,
    .overrideGenDMAReq=false,
    .align=eADC_ALIGN_RIGHT,
    .resolution=eADC_RESOLUTION_12BIT,

    .convIntEnable=false,
    .ovrunIntEnable=false,
    .sampIntEnable=false,
    .readyIntEnable=false,
    .lowerTriggerErrorEnable=false,
    .normalErrorEnable=false,
    
    .seqConfig={
        .seqLengthMax=eADC_SEQ0_8_SEQ1_8,
        .highSelect=eADC_SEQ0_AS_HIGH_PRIORITY_SEQ,
        .sequenceMode=eADC_CONV_HIGH_PRIORITY_LOOP_LOW_PRIORITY_LOOP,

        .highPrioSequence={
            .totalChannels=1,
            .sequenceIntEnable=false,
            .dmaEnable=false,
            .channels={
                {
                    .channel=eADC_INPUTCHAN_EXT0,
                    .sampleSelect=eADC_CHANNEL_SELECT_SMP0,
                    .overflowMode=eADC_OVERFLOW_COVER_DATA
                },
            },
        },

        .swTriggerEnable=false, // if enable low priority hardware trigger need disable it
        .lowPrioSequence={
            .totalChannels=1,
            .sequenceIntEnable=false,
            .dmaEnable=false,
            .channels={
                {
                    .channel=eADC_INPUTCHAN_EXT1,
                    .sampleSelect=eADC_CHANNEL_SELECT_SMP0,
                    .overflowMode=eADC_OVERFLOW_COVER_DATA
                },
            },
        }
    },

    .eadcCompareCnt=1,
    .compIntEnable=false,
    .compareConfig=(eadc_compare_config_t*)eadc_config0CompCfg, 
};


