/*
 * Copyright 2020-2024 Yuntu Microelectronics co.,ltd
 * All rights reserved.
 *
 * YUNTU Confidential. This software is owned or controlled by YUNTU and may
 * only be used strictly in accordance with the applicable license terms. By expressly
 * accepting such terms or by downloading, installing, activating and/or otherwise
 * using the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software. The production use license in
 * Section 2.3 is expressly granted for this software.
 */
/*!
 * @file hw_adc.h
 */
#ifndef HW_ADC_H
#define HW_ADC_H

#include "status.h"
#include "interrupt_manager.h"

/*******************************************************************************
* Definitions
******************************************************************************/

typedef enum _adc_channels_t
{
    ADC_U_PHASE_CHANNEL = 2U,
    ADC_V_PHASE_CHANNEL = 3U,
    ADC_W_PHASE_CHANNEL = 4U,
    ADC_VDCBUS_CHANNEL = 5U,
    ADC_NTC_TEMP_CHANNEL = 6U,
} adc_channels_t;

#define ADC_USER_CHANNEL_NUM (4U)

void HW_SetupAdcSeqMode(const uint8_t *channels, uint8_t channel_cnt, const isr_t adcISR);
void HW_SetupAdcSeq1Mode(const uint8_t *channels, uint8_t channel_cnt, const isr_t adcISR);
void HW_SetupAdcSeq2Mode(const uint8_t *channels, uint8_t channel_cnt, const isr_t adcISR);
//void HW_SetupAdc2SeqMode(const uint8_t *channels, uint8_t channel_cnt, const isr_t adcISR);

void HW_DeinitADC(void);

#endif /* HW_ADC_H */

/*******************************************************************************
* EOF
******************************************************************************/
 