/*
 * Copyright 2020-2025 Yuntu Microelectronics co.,ltd
 * All rights reserved.
 *
 * YUNTU Confidential. This software is owned or controlled by YUNTU and may
 * only be used strictly in accordance with the applicable license terms. By expressly
 * accepting such terms or by downloading, installing, activating and/or otherwise
 * using the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software. The production use license in
 * Section 2.3 is expressly granted for this software.
 */
/*!
 * @file hw_config.h
 * @brief Hardware abstraction layer for motor control peripherals
 */
#ifndef HW_CONFIG_H
#define HW_CONFIG_H

#include "device_registers.h"

/* Hardware peripheral definitions */
/* ADC instance used for motor control */
#define MC_ADC          ADC0
/* PWM timer instance used for motor control */
#define MC_PWM          eTMR0
#define MC_PWM_INST     (0)

#define PWM_CHANNEL_U_PHASE (0U)
#define PWM_CHANNEL_V_PHASE (4U)
#define PWM_CHANNEL_W_PHASE (6U)

/* PWM pin definitions for U phase low side */
#define PWM_U_H_PIN_BASE    (GPIOC)
#define PWM_U_H_PIN_PORT    (PCTRLC)
#define PWM_U_H_PIN_PWM_MUX (PCTRL_MUX_ALT2)
#define PWM_U_H_PIN         (0U)

#define PWM_U_L_PIN_BASE    (GPIOC)
#define PWM_U_L_PIN_PORT    (PCTRLC)
#define PWM_U_L_PIN_PWM_MUX (PCTRL_MUX_ALT2)
#define PWM_U_L_PIN         (1U)

#define PWM_V_H_PIN_BASE    (GPIOB)
#define PWM_V_H_PIN_PORT    (PCTRLB)
#define PWM_V_H_PIN_PWM_MUX (PCTRL_MUX_ALT2)
#define PWM_V_H_PIN         (4U)

#define PWM_V_L_PIN_BASE    (GPIOB)
#define PWM_V_L_PIN_PORT    (PCTRLB)
#define PWM_V_L_PIN_PWM_MUX (PCTRL_MUX_ALT2)
#define PWM_V_L_PIN         (5U)

#define PWM_W_H_PIN_BASE    (GPIOE)
#define PWM_W_H_PIN_PORT    (PCTRLE)
#define PWM_W_H_PIN_PWM_MUX (PCTRL_MUX_ALT2)
#define PWM_W_H_PIN         (8U)

#define PWM_W_L_PIN_BASE    (GPIOE)
#define PWM_W_L_PIN_PORT    (PCTRLE)
#define PWM_W_L_PIN_PWM_MUX (PCTRL_MUX_ALT2)
#define PWM_W_L_PIN         (9U)

 
 
#endif /* HW_CONFIG_H */

/*******************************************************************************
 * EOF
 ******************************************************************************/