/*
 * Copyright 2020-2025 Yuntu Microelectronics Co., Ltd.
 * All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 * 
 * @file interrupt_config.c
 * @brief 
 * 
 */


#include <stddef.h>
#include "interrupt_config.h"


void INT_SYS_ConfigInit()
{
    INT_SYS_DisableIRQGlobal();
    /* ADC0_IRQn(39) ADC0_IRQHandler*/
    INT_SYS_SetPriority(ADC0_IRQn,0);
    INT_SYS_EnableIRQ(ADC0_IRQn);
    /* pTMR0_Ch0_IRQn(48) pTMR0_Ch0_IRQHandler*/
    INT_SYS_SetPriority(pTMR0_Ch0_IRQn,1);
    INT_SYS_EnableIRQ(pTMR0_Ch0_IRQn);
    /* GPIOE_IRQn(63) GPIOE_IRQHandler*/
    INT_SYS_SetPriority(GPIOE_IRQn,5);
    INT_SYS_EnableIRQ(GPIOE_IRQn);
    /* CAN0_ORed_0_15_MB_IRQn(81) CAN0_ORed_0_15_MB_IRQHandler*/
    INT_SYS_SetPriority(CAN0_ORed_0_15_MB_IRQn,3);
    INT_SYS_EnableIRQ(CAN0_ORed_0_15_MB_IRQn);
    INT_SYS_EnableIRQGlobal();
}
