/*
 * Copyright 2020-2024 Yuntu Microelectronics co.,ltd
 * All rights reserved.
 *
 * YUNTU Confidential. This software is owned or controlled by YUNTU and may
 * only be used strictly in accordance with the applicable license terms. By expressly
 * accepting such terms or by downloading, installing, activating and/or otherwise
 * using the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software. The production use license in
 * Section 2.3 is expressly granted for this software.
 */
/*!
 * @file hw_motor.h
 */
#ifndef HW_MOTOR_H
#define HW_MOTOR_H
#include "motor_foc_lib.h"
#include "motor_parameters.h"

extern motor_config_params_t gp;
extern motor_state_params_t gs;
extern motor_low_pass_filter_t speed_lpf;
extern volatile int32_t UserSetRMP;

#define MOTOR_ACCRPM2THETA(s)  ((s<<16) / (((int32_t)(60/MOTOR_NP)) * 1000))

static inline int32_t Motor_Rps2Theta(int32_t s)
{
    return (int32_t)(s * 2 * 32768 * MOTOR_NP / PWM_FREQ);
}

static inline int32_t Motor_Rpm2Theta(int32_t s)
{
    return  (s<<14) / (((int32_t)(15/MOTOR_NP)) * ((int32_t)PWM_FREQ));
}

static inline int32_t Motor_Theta2Rpm(int32_t s)
{
    /* (omega * PWM_FREQ * 60) / (NP * 65536) */
    return (s * ((int32_t)PWM_FREQ) * ((int32_t)(15/MOTOR_NP))) >> 14;
}

static inline int32_t Motor_ConvCurrent2Adc(float i)
{
    return (int32_t)(((float)i) / PEAK_CURRENT * 32768.0f);
}

static inline void Motor_Ctrl_ErrorStop(void)
{
    gs.state = STATE_ERROR;
}

static inline void Motor_Ctrl_Start(void)
{
    if (STATE_STOP == gs.state)
    {
        gs.state = STATE_INIT;
    }
}

static inline void Motor_Ctrl_Stop(void)
{
    gs.state = STATE_STOP;
}

/* Set motor speed RPM */
static inline void Motor_SetSpeedRpm(int32_t rpm)
{
    /* Only support speed update when under WORK mode */

    if (STATE_WORK == gs.state)
    {
        /* Check if rpm in range */
        if ((rpm >= MOTOR_RUN_MIN_RPM) && (rpm <= MOTOR_RUN_MAX_RPM))
        {
            gp.rpm = rpm;
        }
    }
}
int8_t Motor_GetTemperature(void);
int16_t Motor_GetBusVoltage(void);
int16_t Motor_GetBusPower(void);
void Motor_SetError(uint32_t errorCode);
void Motor_ClearError(void);
motor_state_t Motor_GetState(void);
void Motor_SetState(motor_state_t newState);
motor_run_mode_t Motor_GetRunMode(void);
void Motor_SetRunMode(motor_run_mode_t runMode);
void Motor_SetIq(int32_t iq);
uint32_t Motor_GetSpeedRpm(void);
motor_error_t Motor_GetErrorCode(void);
void Motor_CtrlInit(void);
void ptmr0_interrupt_isr(void);
void Motor_StateSpeedLoopService(void);
void SpeedRAMP(int32_t SpeedSet);
#endif /* HW_MOTOR_H */

/*******************************************************************************
 * EOF
 ******************************************************************************/
