/*
 * Copyright 2020-2025 Yuntu Microelectronics Co., Ltd.
 * All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 * 
 * @file interrupt_config.c
 * @brief 
 * 
 */


#include <stddef.h>
#include "interrupt_config.h"


void INT_SYS_ConfigInit()
{
    INT_SYS_DisableIRQGlobal();
    /* GPIO_IRQn(9) GPIO_IRQHandler*/
    INT_SYS_SetPriority(GPIO_IRQn,5);
    INT_SYS_EnableIRQ(GPIO_IRQn);
    /* CAN0_ORed_0_15_MB_IRQn(11) CAN0_ORed_0_15_MB_IRQHandler*/
    INT_SYS_SetPriority(CAN0_ORed_0_15_MB_IRQn,4);
    INT_SYS_EnableIRQ(CAN0_ORed_0_15_MB_IRQn);
    /* pTMR0_IRQn(20) pTMR0_IRQHandler*/
    INT_SYS_SetPriority(pTMR0_IRQn,1);
    INT_SYS_EnableIRQ(pTMR0_IRQn);
    /* ADC0_IRQn(28) ADC0_IRQHandler*/
    INT_SYS_SetPriority(ADC0_IRQn,0);
    INT_SYS_EnableIRQ(ADC0_IRQn);
    INT_SYS_EnableIRQGlobal();
}
