/* USER CODE BEGIN Header */
/* you can remove the copyright */

/*
 *  Copyright 2020-2023 Yuntu Microelectronics co.,ltd
 *  All rights reserved.
 * 
 *  YUNTU Confidential. This software is owned or controlled by YUNTU and may only be
 *  used strictly in accordance with the applicable license terms. By expressly
 *  accepting such terms or by downloading, installing, activating and/or otherwise
 *  using the software, you are agreeing that you have read, and that you agree to
 *  comply with and are bound by, such license terms. If you do not agree to be
 *  bound by the applicable license terms, then you may not retain, install,
 *  activate or otherwise use the software. The production use license in
 *  Section 2.3 is expressly granted for this software.
 * 
 * @file main.c
 * @brief 
 * 
 */

/* USER CODE END Header */
#include "sdk_project_config.h"
/* Includes ------------------------------------------------------------------*/

/* Private includes ----------------------------------------------------------*/
/* USER CODE BEGIN Includes */
#include "printf.h"
#include "FreeRTOS.h"
#include "task.h"
#include "queue.h"
#include "timers.h"
/* USER CODE END Includes */

/* Private typedef -----------------------------------------------------------*/
/* USER CODE BEGIN PTD */
/* USER CODE END PTD */

/* Private define ------------------------------------------------------------*/
/* USER CODE BEGIN PD */
/* Priorities at which the tasks are created. */
#define mainQUEUE_RECEIVE_TASK_PRIORITY (tskIDLE_PRIORITY + 2)
#define mainQUEUE_SEND_TASK_PRIORITY    (tskIDLE_PRIORITY + 1)
#define POWERDOWN_MODE 0
#define WKU_INST       0
/* USER CODE END PD */

/* Private macro -------------------------------------------------------------*/
/* USER CODE BEGIN PM */
/* USER CODE END PM */

/* Private variables ---------------------------------------------------------*/
/* USER CODE BEGIN PV */
uint32_t TaskA_Count = 0;
uint32_t TaskB_Count = 0;

/* This uses prvButtonLEDTimerCallback() as its callback function. */
static TimerHandle_t xPrintTimer = NULL;

/* USER CODE END PV */

/* Private function declare --------------------------------------------------*/
/* USER CODE BEGIN PFDC */
void prvPrintTaskA(void *pvParameters)
{
    (void)pvParameters;
    while (1)
    {
        PRINTF("TASK A, Count %d\r\n", TaskA_Count++);
        vTaskDelay(1000UL);
    }
}

void prvPrintTaskB(void *pvParameters)
{
    (void)pvParameters;
    while (1)
    {
        PRINTF("POWERDOWN_MODE \r\n");

			  POWER_SYS_SetMode(POWERDOWN_MODE, POWER_MANAGER_POLICY_AGREEMENT);

        vTaskDelay(2000UL);
    }
}

void prvPrintTimerCallback(TimerHandle_t xTimer)
{
    (void)xTimer;
    PRINTF("TASK C\r\n");
}

void vApplicationTickHook(void)
{}

void vApplicationStackOverflowHook(TaskHandle_t pxTask, char *pcTaskName)
{
    (void)pcTaskName;
    (void)pxTask;

    taskDISABLE_INTERRUPTS();
    for (;;)
        ;
}

void vApplicationMallocFailedHook(void)
{
    taskDISABLE_INTERRUPTS();
    for (;;)
        ;
}

void vApplicationIdleHook(void)
{
    volatile size_t xFreeHeapSpace;
    xFreeHeapSpace = xPortGetFreeHeapSize();

    if (xFreeHeapSpace > 100)
    {
        /* By now, the kernel has allocated everything it is going to, so
        if there is a lot of heap remaining unallocated then
        the value of configTOTAL_HEAP_SIZE in FreeRTOSConfig.h can be
        reduced accordingly. */
    }
}

/* USER CODE END PFDC */
static void Board_Init(void);

/* Private user code ---------------------------------------------------------*/
/* USER CODE BEGIN 0 */
/* USER CODE END 0 */


/**
 * @brief  The application entry point.
 * @retval int
 */
int main(void)
{
    /* USER CODE BEGIN 1 */
    status_t status = STATUS_SUCCESS;
	  volatile uint32_t temp = 0xFFFFFF;
    /* USER CODE END 1 */ 
    Board_Init();
  	PRINTF("1\r\n");
    /* USER CODE BEGIN 2 */
    PRINTF("main Build %s %s\r\n", __DATE__, __TIME__);
	
    WKU_DRV_SetPinIsolation(false);	
	
    WKU_DRV_InitReset(WKU_INST, &wkup_resetConfig0);
    WKU_DRV_InitPinWakeup(WKU_INST, WKP_PIN_CH_NUM0, wkup_pinsConfig0);
  	PRINTF("2\r\n");
    while(temp--);
	
		WKU_DRV_SetPinIsolation(true);
	
  	PRINTF("Freertos GPIO wku form pd Demo!\r\n");
  	PRINTF("3\r\n");
    xTaskCreate(prvPrintTaskA, "TaskA", configMINIMAL_STACK_SIZE, NULL, mainQUEUE_RECEIVE_TASK_PRIORITY, NULL);
    xTaskCreate(prvPrintTaskB, "TaskB", configMINIMAL_STACK_SIZE, NULL, mainQUEUE_SEND_TASK_PRIORITY, NULL);

    /* Create the software timer that is responsible for turning off the LED
  if the button is not pushed within 5000ms, as described at the top of
  this file. */
    xPrintTimer = xTimerCreate("PrintTimer",         /* A text name, purely to help debugging. */
                               5000UL,               /* The timer period, in this case 5000ms (5s). */
                               pdTRUE,               /* This is a one shot timer, so xAutoReload is set to pdFALSE. */
                               (void *)0,            /* The ID is not used, so can be set to anything. */
                               prvPrintTimerCallback /* The callback function that switches the LED off. */
    );
    xTimerStart(xPrintTimer, 0);
    /* Start the tasks and timer running. */
    vTaskStartScheduler();
    /* USER CODE END 2 */

    /* Infinite loop */
    /* USER CODE BEGIN WHILE */
    while (1)
    {
        if (status != STATUS_SUCCESS)
        {
            break;
        }
        /* USER CODE END WHILE */
        /* USER CODE BEGIN 3 */
    }
    return status;
    /* USER CODE END 3 */
}

static void Board_Init(void)
{
    CLOCK_SYS_Init(g_clockManConfigsArr,CLOCK_MANAGER_CONFIG_CNT,g_clockManCallbacksArr,CLOCK_MANAGER_CALLBACK_CNT);
    CLOCK_SYS_UpdateConfiguration(CLOCK_MANAGER_ACTIVE_INDEX,CLOCK_MANAGER_POLICY_AGREEMENT);
    PINS_DRV_Init(NUM_OF_CONFIGURED_PINS0,g_pin_mux_InitConfigArr0);
    UTILITY_PRINT_Init();
    POWER_SYS_Init(&powerConfigsArr,POWER_MANAGER_CONFIG_CNT,NULL,POWER_MANAGER_CALLBACK_CNT);

}

/* USER CODE BEGIN 4 */
/* USER CODE END 4 */
