/* USER CODE BEGIN Header */
/* you can remove the copyright */

/*
 *  Copyright 2020-2023 Yuntu Microelectronics co.,ltd
 *  All rights reserved.
 *
 *  YUNTU Confidential. This software is owned or controlled by YUNTU and may only be
 *  used strictly in accordance with the applicable license terms. By expressly
 *  accepting such terms or by downloading, installing, activating and/or otherwise
 *  using the software, you are agreeing that you have read, and that you agree to
 *  comply with and are bound by, such license terms. If you do not agree to be
 *  bound by the applicable license terms, then you may not retain, install,
 *  activate or otherwise use the software. The production use license in
 *  Section 2.3 is expressly granted for this software.
 *
 * @file main.c
 * @brief
 *
 */

/* USER CODE END Header */
#include "sdk_project_config.h"
/* Includes ------------------------------------------------------------------*/

/* Private includes ----------------------------------------------------------*/
/* USER CODE BEGIN Includes */
#include "printf.h"
#include <stdint.h>
/* USER CODE END Includes */

/* Private typedef -----------------------------------------------------------*/
/* USER CODE BEGIN PTD */
/* USER CODE END PTD */

/* Private define ------------------------------------------------------------*/
/* USER CODE BEGIN PD */
#define RTC_INST       (0U)
#define RUN_MODE       (0U)
#define SLEEP_MODE     (1U)
#define DEEPSLEEP_MODE (2U)
#define STANDBY_MODE   (3U)
/* USER CODE END PD */

/* Private macro -------------------------------------------------------------*/
/* USER CODE BEGIN PM */
#define UART_DMA_ENABLE 	1U
/* USER CODE END PM */

/* Private variables ---------------------------------------------------------*/
/* USER CODE BEGIN PV */
/* USER CODE END PV */

/* Private function declare --------------------------------------------------*/
/* USER CODE BEGIN PFDC */
/* USER CODE END PFDC */
static void Board_Init(void);

/* Private user code ---------------------------------------------------------*/
/* USER CODE BEGIN 0 */
void second_callback(void *callbackParam)
{
    rtc_timedate_t time;
    (void)callbackParam;
    RTC_DRV_GetCurrentTimeDate(RTC_INST, &time);
    // PRINTF("%d/%d/%d %d:%d:%d\n", time.year, time.month, time.day, time.hour, time.minutes, time.seconds);
}

void alarm_callback(void *callbackParam)
{
    (void)callbackParam;
    PRINTF("RTC alarm interrupt!\n\r");
}

volatile uint8_t buff[1024];
uint32_t rssr,ers;
/* USER CODE END 0 */


/**
 * @brief  The application entry point.
 * @retval int
 */
int main(void)
{
    /* USER CODE BEGIN 1 */
    status_t status = STATUS_SUCCESS;
    const rtc_timedate_t current_time = {
        .year = 2024,
        .month = 2,
        .day = 20,
        .hour = 13,
        .minutes = 56,
        .seconds = 0,
    };
    /* USER CODE END 1 */
    Board_Init();
    /* USER CODE BEGIN 2 */

    // 1. UART2初始化, 上面的Board_Init中已对UART1进行了初始化
    LINFlexD_UART_DRV_Init(2,&linflexd_uart_config2_State,&linflexd_uart_config2);
    // LINFlexD_UART_DRV_InstallTxCallback(2, UartCallback, (void *)1);
    // LINFlexD_UART_DRV_InstallRxCallback(2, UartCallback, (void *)2);
    // LINFlexD_UART_DRV_InstallErrorCallback(2, UartCallback, (void *)3);

#if UART_DMA_ENABLE
    DMA_DRV_Init(&dmaState, &dmaController_InitConfig, dmaChnState, dmaChnConfigArray, NUM_OF_CONFIGURED_DMA_CHANNEL);
    // int count = 0;
    // while (count++ < 3) {
    //     PRINTF("uart dma test, count = %d\r\n", count);
    //     OSIF_TimeDelay(1000);
    // }
#endif
//    PRINTF("MCU start, Build %s %s\n", __DATE__, __TIME__);
    PRINTF("main rtc wakeup!\r\n");
		
		rssr = RCU->RSSR;
		PRINTF("RSSR: 0x%08x\r\n",rssr);
    if ((RCU_RSSR_LPACK_MASK ) & RCU->RSSR)
    {
        PRINTF("RCU_RSSR_LPACK_MASK.\r\n");

        RCU->RSSR = RCU_RSSR_LPACK_MASK ;
    }
    OSIF_TimeDelay(1000);
   
    LINFlexD_UART_DRV_ReceiveDataBlocking(2,&buff, 1,0x8FF);
		LINFlexD_UART_DRV_SendDataBlocking(2,&buff,1,0xFF);

	  OSIF_TimeDelay(2000);
    RTC_DRV_Deinit(RTC_INST);
    RTC_DRV_Init(RTC_INST, &rtc_config0);
    RTC_DRV_SetTimeDate(RTC_INST, &current_time);

    RTC_DRV_StartCounter(RTC_INST);

    POWER_SYS_Init(&powerConfigsArr, POWER_MANAGER_CONFIG_CNT, NULL, POWER_MANAGER_CALLBACK_CNT);

    rtc_timedate_t time;
    for (uint8_t i = 0; i < 3; i++) 
		{
        PRINTF("Start to enter DeepSleep mode.\r\n");
        RTC_DRV_GetCurrentTimeDate(RTC_INST, &time);
        PRINTF("Start to enter sleep mode. i is %d\r\n", i);
        OSIF_TimeDelay(1000);
#if UART_DMA_ENABLE

        // 3. DMA逆初始化
        // DMA_DRV_ClearCTS(0);
        DMA_DRV_StopChannel(0);
        DMA_DRV_ReleaseChannel(0);
        // DMA_DRV_DisableRequestsOnTransferComplete(0, true);

        // DMA_DRV_ClearCTS(1);
        DMA_DRV_StopChannel(1);
        DMA_DRV_ReleaseChannel(1);
        // DMA_DRV_DisableRequestsOnTransferComplete(1, true);

        // sDMA_DRV_CancelTransfer(false);
        DMA_DRV_Deinit();

        OSIF_TimeDelay(1000);
#endif
        // 4. 串口逆初始化
        LINFlexD_UART_DRV_AbortSendingData(2);
        LINFlexD_UART_DRV_AbortReceivingData(2);
        LINFlexD_UART_DRV_Deinit(2);
				
				OSIF_TimeDelay(500);
        // 5. 休眠, 5秒后由RTC唤醒
				RCU->RSSR = 0xFFFFFFFF;
        POWER_SYS_SetMode(DEEPSLEEP_MODE, POWER_MANAGER_POLICY_AGREEMENT);

        // 6. 串口和DMA重新初始化
        LINFlexD_UART_DRV_Init(1, &linflexd_uart_config1_State, &linflexd_uart_config1);
        LINFlexD_UART_DRV_Init(2, &linflexd_uart_config2_State, &linflexd_uart_config2);
#if UART_DMA_ENABLE
        DMA_DRV_Init(&dmaState, &dmaController_InitConfig, dmaChnState, dmaChnConfigArray, NUM_OF_CONFIGURED_DMA_CHANNEL);

        DMA_DRV_StartChannel(0);
				DMA_DRV_StartChannel(1);

#endif
        PRINTF("wakeup from DeepSleep mode\n");
        OSIF_TimeDelay(1000);
    }
    PRINTF("end: sleep 6 s\r\n");
    OSIF_TimeDelay(6000);
    RTC_DRV_Deinit(RTC_INST);
    PRINTF("<----Demo end---->\r\n");
    /* USER CODE END 2 */

    /* Infinite loop */
    /* USER CODE BEGIN WHILE */
    while (1)
    {
        if (status != STATUS_SUCCESS)
        {
            break;
        }
        /* USER CODE END WHILE */
        /* USER CODE BEGIN 3 */
    }
    return status;
    /* USER CODE END 3 */
}

static void Board_Init(void)
{
    CLOCK_SYS_Init(g_clockManConfigsArr,CLOCK_MANAGER_CONFIG_CNT,g_clockManCallbacksArr,CLOCK_MANAGER_CALLBACK_CNT);
    CLOCK_SYS_UpdateConfiguration(CLOCK_MANAGER_ACTIVE_INDEX,CLOCK_MANAGER_POLICY_AGREEMENT);
    PINS_DRV_Init(NUM_OF_CONFIGURED_PINS0,g_pin_mux_InitConfigArr0);
    UTILITY_PRINT_Init();
//    LINFlexD_UART_DRV_Init(1,&linflexd_uart_config1_State,&linflexd_uart_config1);
}

/* USER CODE BEGIN 4 */
/* USER CODE END 4 */
