/*
 *  Copyright 2020-2024 Yuntu Microelectronics co.,ltd
 *  All rights reserved.
 * 
 *  YUNTU Confidential. This software is owned or controlled by YUNTU and may only be
 *  used strictly in accordance with the applicable license terms. By expressly
 *  accepting such terms or by downloading, installing, activating and/or otherwise
 *  using the software, you are agreeing that you have read, and that you agree to
 *  comply with and are bound by, such license terms. If you do not agree to be
 *  bound by the applicable license terms, then you may not retain, install,
 *  activate or otherwise use the software. The production use license in
 *  Section 2.3 is expressly granted for this software.
 * 
 * @file clock_config.c
 * @brief 
 * 
 */

#include "stddef.h"
#include "clock_config.h"

/*! @brief peripheral clock PeripheralClockConfig */

peripheral_clock_config_t clock_config0PeripheralClockConfig[4] = {
    {
        .clkName = DMA_CLK,
        .clkGate = true,
        .clkSrc = CLK_SRC_DISABLED,
        .divider = DIV_BY_1,
    },
    {
        .clkName = GPIO_CLK,
        .clkGate = true,
        .clkSrc = CLK_SRC_DISABLED,
        .divider = DIV_BY_1,
    },
    {
        .clkName = LINFlexD2_CLK,
        .clkGate = true,
        .clkSrc = CLK_SRC_FXOSC,
        .divider = DIV_BY_1,
    },
    {
        .clkName = LINFlexD3_CLK,
        .clkGate = true,
        .clkSrc = CLK_SRC_FXOSC,
        .divider = DIV_BY_1,
    },
};

const scu_config_t clock_config0ScuConfig = {
    .sircDeepSleepEnable = true,
    .sircStandbyEnable = true,
    .sircPowerDownEnable = true,
    .fircEnable = true,
    .fircDeepSleepEnable = false,
    .sysClkSrc = SCU_SYSTEM_CLOCK_SRC_PLL,
    .fxoscConfig =
        {
            .enable = true,
            .bypassMode = false,
            .gainSelection = 5,
            .frequency = 24000000U,
        },
    .sxoscConfig = 
        {
            .enable = false,
            .gainSelection = 0,
            .bypassMode = false,
            .deepsleepEnable = false,
            .standbyEnable = false,
            .powerdownEnable = false,
            .frequency = 32768U,
        },
    .pllConfig =
        {
            .enable = true,
            .pllRefClock = SCU_PLL_REF_FXOSC_CLK,
            .pllFeedBackDiv = 50,
            .pllRefClkDiv = 3,
        },
    .sysDiv = SCU_SYS_CLK_DIV_BY_1,
    .fastBusDiv = SCU_SYS_CLK_DIV_BY_2,
    .slowBusDiv = SCU_SYS_CLK_DIV_BY_2,
    .flashDiv = SCU_SYS_CLK_DIV_BY_3,
    .flashPrs = 0,
    .clockOutConfig =
        {
            .enable = false,
            .divider = 1,
            .source = SCU_CLKOUT_SEL_PLL_CLK,
        },
};

/*! @brief User Configuration structure clock_config0ClockManager */
clock_manager_user_config_t clock_config0ClockManager = {
    .ipcConfig = {
        .count = 4,
        .peripheralClocks = clock_config0PeripheralClockConfig,
    },
    .scuConfigPtr = &clock_config0ScuConfig,
    .cmuConfigPtr = NULL,
};

/*! @brief Array of pointers to User configuration structures */
clock_manager_user_config_t const *g_clockManConfigsArr[] = {
    &clock_config0ClockManager,
};

/*! @brief Array of pointers to User defined Callbacks configuration structures */
/* The tool do not support generate Callbacks configuration. It's always empty. */
clock_manager_callback_user_config_t *g_clockManCallbacksArr[] = {(void *)0};
