/* USER CODE BEGIN Header */
/* you can remove the copyright */

/*
 *  Copyright 2020-2023 Yuntu Microelectronics co.,ltd
 *  All rights reserved.
 * 
 *  YUNTU Confidential. This software is owned or controlled by YUNTU and may only be
 *  used strictly in accordance with the applicable license terms. By expressly
 *  accepting such terms or by downloading, installing, activating and/or otherwise
 *  using the software, you are agreeing that you have read, and that you agree to
 *  comply with and are bound by, such license terms. If you do not agree to be
 *  bound by the applicable license terms, then you may not retain, install,
 *  activate or otherwise use the software. The production use license in
 *  Section 2.3 is expressly granted for this software.
 * 
 * @file main.c
 * @brief 
 * 
 */

/* USER CODE END Header */
#include "sdk_project_config.h"
/* Includes ------------------------------------------------------------------*/

/* Private includes ----------------------------------------------------------*/
/* USER CODE BEGIN Includes */
#include "printf.h"
/* USER CODE END Includes */

/* Private typedef -----------------------------------------------------------*/
/* USER CODE BEGIN PTD */
/* USER CODE END PTD */

/* Private define ------------------------------------------------------------*/
/* USER CODE BEGIN PD */
#define PRINTF_UART    3

#define POWERDOWN_MODE 0
#define DEEPSLEEP_MODE 1

#define SW2_PORT       (GPIOE)
#define SW2_PORT_INDEX (3U)

volatile uint8_t buff[1024];
uint32_t rssr,ers;
/* USER CODE END PD */

/* Private macro -------------------------------------------------------------*/
/* USER CODE BEGIN PM */
/* USER CODE END PM */

/* Private variables ---------------------------------------------------------*/
/* USER CODE BEGIN PV */
/* USER CODE END PV */

/* Private function declare --------------------------------------------------*/
/* USER CODE BEGIN PFDC */
/* USER CODE END PFDC */
static void Board_Init(void);

/* Private user code ---------------------------------------------------------*/
/* USER CODE BEGIN 0 */
void GPIOE_IRQHandler(void)
{
    if (PINS_DRV_GetPortIntFlag(SW2_PORT) & (1 << SW2_PORT_INDEX))
    {
				PRINTF("GPIOE_IRQHandler\r\n");
        PINS_DRV_ClearPinIntFlagCmd(SW2_PORT, SW2_PORT_INDEX);

    }

}
/* USER CODE END 0 */


/**
 * @brief  The application entry point.
 * @retval int
 */
int main(void)
{
    /* USER CODE BEGIN 1 */
    status_t status = STATUS_SUCCESS;
    /* USER CODE END 1 */ 
    Board_Init();
    /* USER CODE BEGIN 2 */
//    WKU_DRV_SetPinIsolation(false);
    PRINTF("Power Pin Wakeup from deepsleep Mode!\r\n");
		rssr = RCU->RSSR;
		PRINTF("RSSR: 0x%08x\r\n",rssr);
    if ((RCU_RSSR_LPACK_MASK ) & RCU->RSSR)
    {
        PRINTF("RCU_RSSR_LPACK_MASK.\r\n");

        RCU->RSSR = RCU_RSSR_LPACK_MASK ;
    }
		INT_SYS_EnableIRQ(GPIOE_IRQn);
		
    OSIF_TimeDelay(5000);


#if 1
    // ע: # if 1  #endifΧĴ, ڵȴUART2.
    // ⲿUART2, MCUһյ, ͻڵPOWER_SYS_SetMode
		LINFlexD_UART_DRV_ReceiveData(2, &buff, sizeof(buff));
    uint32_t remain_bytes = sizeof(buff);
    // while (LINFlexD_UART_DRV_GetReceiveStatus(2, NULL) != STATUS_SUCCESS)
    PRINTF("waiting 8 bytes from UART2...\r\n");
    while (1)
    {
        LINFlexD_UART_DRV_GetReceiveStatus(2, &remain_bytes);
        if (remain_bytes < sizeof(buff) - 8) {
							LINFlexD_UART_DRV_SendDataBlocking(2,&buff,8,0xFF);
            break;
        }
    }
    // LINFlexD_UART_DRV_SendData(2, buff, 8);
#endif
		
	
    PRINTF("Start to enter deepsleep mode.\n");

//        LINFlexD_UART_DRV_AbortSendingData(2);
//        LINFlexD_UART_DRV_AbortReceivingData(2);
//        LINFlexD_UART_DRV_Deinit(2);
    // Enter into deepsleep mode
		
		LINFlexD2->LINCR1 |= LINFlexD_LINCR1_SLEEP_MASK;
		OSIF_TimeDelay(500);
		RCU->RSSR = 0xFFFFFFFF;
    POWER_SYS_SetMode(DEEPSLEEP_MODE, POWER_MANAGER_POLICY_AGREEMENT);
		
		LINFlexD2->LINCR1 &= ~LINFlexD_LINCR1_SLEEP_MASK;
		PRINTF("Wakeup  from deepsleep ");
    /* USER CODE END 2 */

    /* Infinite loop */
    /* USER CODE BEGIN WHILE */
    while (1)
    {
        if (status != STATUS_SUCCESS)
        {
            break;
        }
        /* USER CODE END WHILE */
        /* USER CODE BEGIN 3 */
    }
    return status;
    /* USER CODE END 3 */
}

static void Board_Init(void)
{
    CLOCK_SYS_Init(g_clockManConfigsArr,CLOCK_MANAGER_CONFIG_CNT,g_clockManCallbacksArr,CLOCK_MANAGER_CALLBACK_CNT);
    CLOCK_SYS_UpdateConfiguration(CLOCK_MANAGER_ACTIVE_INDEX,CLOCK_MANAGER_POLICY_AGREEMENT);
    PINS_DRV_Init(NUM_OF_CONFIGURED_PINS0,g_pin_mux_InitConfigArr0);
    UTILITY_PRINT_Init();
    POWER_SYS_Init(&powerConfigsArr,POWER_MANAGER_CONFIG_CNT,NULL,POWER_MANAGER_CALLBACK_CNT);
    LINFlexD_UART_DRV_Init(2,&linflexd_uart_config0_State,&linflexd_uart_config1);
    DMA_DRV_Init(&dmaState,&dmaController_InitConfig,dmaChnState,dmaChnConfigArray,NUM_OF_CONFIGURED_DMA_CHANNEL);
}

/* USER CODE BEGIN 4 */
/* USER CODE END 4 */
