/*
 *  Copyright 2020-2024 Yuntu Microelectronics co.,ltd
 *  All rights reserved.
 * 
 *  YUNTU Confidential. This software is owned or controlled by YUNTU and may only be
 *  used strictly in accordance with the applicable license terms. By expressly
 *  accepting such terms or by downloading, installing, activating and/or otherwise
 *  using the software, you are agreeing that you have read, and that you agree to
 *  comply with and are bound by, such license terms. If you do not agree to be
 *  bound by the applicable license terms, then you may not retain, install,
 *  activate or otherwise use the software. The production use license in
 *  Section 2.3 is expressly granted for this software.
 * 
 * @file rtc_config.c
 * @brief 
 * 
 */


#include <stddef.h>
#include "rtc_config.h"


/*rtc_config0*/

extern void alarm_callback(void *callbackParam);


extern void second_callback(void *callbackParam);






static rtc_alarm_config_t rtc_config0Alarm={
    .alarmTime={
        .year=2024,
        .month=2,
        .day=20,
        .hour=13,
        .minutes=56,
        .seconds=5
    },
    .repetitionInterval=5,
    .numberOfRepeats=0,
    .repeatForever=false,
    .alarmIntEnable=true,
    .rtcAlarmCallback=alarm_callback,
    .callbackParams=NULL,
};

static rtc_overflow_config_t rtc_config0Overflow={
    .overflowIntEnable=false,
    .rtcOverflowCallback=NULL,
    .callbackParams=NULL,
};

static rtc_seconds_config_t rtc_config0Seconds={
    .secondsIntConfig=RTC_INT_1HZ,
    .secondsIntEnable=true,
    .rtcSecondsCallback=second_callback,
    .callbackParams=NULL,
};


const rtc_init_config_t rtc_config0 = {
    .compensationInterval=0,
    .compensation=0,
    .clockSource=RTC_CLK_SRC_OSC_32KHZ,
    .clockOutConfig=RTC_CLKOUT_DISABLED,
    .debugEnable=true,
    .rtcAlarmConfig=&rtc_config0Alarm,
    .rtcOverflowConfig=&rtc_config0Overflow,
    .rtcSecondsConfig=&rtc_config0Seconds,
};
