/* USER CODE END Header */
#include "sdk_project_config.h"
/* Includes ------------------------------------------------------------------*/

/* Private includes ----------------------------------------------------------*/
/* USER CODE BEGIN Includes */
#include "printf.h"
/* USER CODE END Includes */

/* Private typedef -----------------------------------------------------------*/
/* USER CODE BEGIN PTD */
/* USER CODE END PTD */

/* Private define ------------------------------------------------------------*/
/* USER CODE BEGIN PD */
#define RTC_INST       (0U)
#define RUN_MODE       (0U)
#define SLEEP_MODE     (1U)
#define DEEPSLEEP_MODE (2U)
#define POWERDOWN_MODE   (3U)
#define WKU_INST       0
/* USER CODE END PD */

/* Private macro -------------------------------------------------------------*/
/* USER CODE BEGIN PM */
/* USER CODE END PM */

/* Private variables ---------------------------------------------------------*/
/* USER CODE BEGIN PV */
/* USER CODE END PV */

/* Private function declare --------------------------------------------------*/
/* USER CODE BEGIN PFDC */
/* USER CODE END PFDC */
static void Board_Init(void);

/* Private user code ---------------------------------------------------------*/
/* USER CODE BEGIN 0 */
void second_callback(void *callbackParam)
{

	  
    rtc_timedate_t time;
    (void)callbackParam;
    RTC_DRV_GetCurrentTimeDate(RTC_INST, &time);

		//PRINTF("%d/%d/%d %d:%d:%d\r\n", time.year, time.month, time.day, time.hour, time.minutes, time.seconds);

}

void alarm_callback(void *callbackParam)
{
    (void)callbackParam;
    PRINTF("RTC alarm interrupt!\n");
}

/* USER CODE END 0 */


/**
 * @brief  The application entry point.
 * @retval int
 */
int main(void)
{
    /* USER CODE BEGIN 1 */
	  rtc_timedate_t time;
    status_t status = STATUS_SUCCESS;
    const rtc_timedate_t current_time = {
        .year = 2025,
        .month = 3,
        .day = 11,
        .hour = 00,
        .minutes = 00,
        .seconds = 00,
    };
    /* USER CODE END 1 */ 
    Board_Init();
		WKU_DRV_SetPinIsolation(false);
    WKU_DRV_InitReset(WKU_INST, &wkup_resetConfig0);
    WKU_DRV_InitPinWakeup(WKU_INST, WKP_PIN_CH_NUM0, wkup_pinsConfig0);
    /* USER CODE BEGIN 2 */
    PRINTF("demo!\r\n");
    OSIF_TimeDelay(5000);

    /* if POR or Reset pin */
    if ((RCU_RSSR_POR_LVD_MASK | RCU_RSSR_PIN_MASK) & RCU->RSSR)
    {
        PRINTF("POR or PIN reset.\n\r");
        RCU->RSSR = RCU_RSSR_POR_LVD_MASK | RCU_RSSR_PIN_MASK;
				RTC_DRV_Deinit(RTC_INST);
				RTC_DRV_Init(RTC_INST, &rtc_config0);
				RTC_DRV_SetTimeDate(RTC_INST, &current_time);

        RTC_DRV_StartCounter(RTC_INST);
    }
		else
    {
        RTC_DRV_StartCounter(RTC_INST);
    }
		
//				RTC_DRV_Deinit(RTC_INST);
//				RTC_DRV_Init(RTC_INST, &rtc_config0);
//				RTC_DRV_SetTimeDate(RTC_INST, &current_time);

//        RTC_DRV_StartCounter(RTC_INST);
		
    RTC_DRV_GetCurrentTimeDate(RTC_INST, &time);
		PRINTF("%d/%d/%d %d:%d:%d\r\n", time.year, time.month, time.day, time.hour, time.minutes, time.seconds);

		PRINTF("Start to enter POWERDOWN_MODE .\r\n");
		POWER_SYS_SetMode(POWERDOWN_MODE, POWER_MANAGER_POLICY_AGREEMENT);

    /* USER CODE END 2 */

    /* Infinite loop */
    /* USER CODE BEGIN WHILE */
    while (1)
    {
        if (status != STATUS_SUCCESS)
        {
            break;
        }
        /* USER CODE END WHILE */
        /* USER CODE BEGIN 3 */
    }
    return status;
    /* USER CODE END 3 */
}

static void Board_Init(void)
{
    CLOCK_SYS_Init(g_clockManConfigsArr,CLOCK_MANAGER_CONFIG_CNT,g_clockManCallbacksArr,CLOCK_MANAGER_CALLBACK_CNT);
    CLOCK_SYS_UpdateConfiguration(CLOCK_MANAGER_ACTIVE_INDEX,CLOCK_MANAGER_POLICY_AGREEMENT);
    PINS_DRV_Init(NUM_OF_CONFIGURED_PINS0,g_pin_mux_InitConfigArr0);
    UTILITY_PRINT_Init();
    POWER_SYS_Init(&powerConfigsArr, POWER_MANAGER_CONFIG_CNT, NULL, POWER_MANAGER_CALLBACK_CNT);
}

/* USER CODE BEGIN 4 */
/* USER CODE END 4 */
