/*
 *  Copyright 2020-2024 Yuntu Microelectronics co.,ltd
 *  All rights reserved.
 * 
 *  YUNTU Confidential. This software is owned or controlled by YUNTU and may only be
 *  used strictly in accordance with the applicable license terms. By expressly
 *  accepting such terms or by downloading, installing, activating and/or otherwise
 *  using the software, you are agreeing that you have read, and that you agree to
 *  comply with and are bound by, such license terms. If you do not agree to be
 *  bound by the applicable license terms, then you may not retain, install,
 *  activate or otherwise use the software. The production use license in
 *  Section 2.3 is expressly granted for this software.
 * 
 * @file adc_config.c
 * @brief 
 * 
 */


#include "adc_config.h"


const adc_compare_config_t adc_config0CompCfg[1] = {
    {
        .comWdchIndex=0,    
        .compareEnable=true,
        .compareAllChannelEnable=false,
        .compChalSel=ADC_INPUTCHAN_EXT0,
        .compHigh=4000,
        .compLow=1000,
        .compIntEnable=true,  
        .effectiveMode=ADC_AWG_EFFECTIVE_INSIDE,
    },
};

/* adc_config0 */
const adc_converter_config_t adc_config0={
    .clockDivider=0,
    .startTime=48,
    .sampleTime=2,
    .overrunMode=false,
    .autoOffEnable=false,
    .waitEnable=false,
    .trigger=ADC_TRIGGER_SOFTWARE,
    .align=ADC_ALIGN_RIGHT,
    .resolution=ADC_RESOLUTION_12BIT,
    .dmaWaterMark=0,
    .dmaEnable=false,
    .sequenceConfig={
        .sequenceMode=ADC_CONV_CONTINUOUS,
        .sequenceIntEnable=false,
        .convIntEnable=false,
        .readyIntEnable=false,
        .ovrunIntEnable=false,
        .sampIntEnable=false,
        .channels={
            ADC_INPUTCHAN_EXT0,
        },
        .totalChannels=1,
    },
    .adcCompareCnt=1,
    .compareConfig=(adc_compare_config_t*)adc_config0CompCfg, 
};


