/*
 *  Copyright 2020-2024 Yuntu Microelectronics co.,ltd
 *  All rights reserved.
 * 
 *  YUNTU Confidential. This software is owned or controlled by YUNTU and may only be
 *  used strictly in accordance with the applicable license terms. By expressly
 *  accepting such terms or by downloading, installing, activating and/or otherwise
 *  using the software, you are agreeing that you have read, and that you agree to
 *  comply with and are bound by, such license terms. If you do not agree to be
 *  bound by the applicable license terms, then you may not retain, install,
 *  activate or otherwise use the software. The production use license in
 *  Section 2.3 is expressly granted for this software.
 * 
 * @file startup.S
 * @brief 
 * 
 */

    PRESERVE8
    THUMB
    AREA    |.text|, CODE, READONLY
_start
Reset_Handler

    EXPORT  Reset_Handler
    IMPORT  RamInit
    IMPORT  __main
    IMPORT  SystemInit
    IMPORT |Image$$STACK_start$$Base|
    IMPORT |Image$$OS_HEAP_DTCM_start$$Base|
#ifndef __NO_VECTOR_TABLE_COPY
    IMPORT  VectorTableCopy
#endif
    IMPORT  __initial_sp
    cpsid   i               /* Mask interrupts */

    /* Init the rest of the registers */
    ldr     r1,=0
    ldr     r2,=0
    ldr     r3,=0
    ldr     r4,=0
    ldr     r5,=0
    ldr     r6,=0
    ldr     r7,=0
    mov     r8,r7
    mov     r9,r7
    mov     r10,r7
    mov     r11,r7
    mov     r12,r7
	
    
    /* RamInit 0 Stage, focus on ecc init, asm code*/
    /*bl     RamInit0*/
#define ITCMCR  (0xE000EF90)
#define DTCMCR  (0xE000EF94)

/* Enable ITCM and DTCM with ECC support */
_TCM_Enable
    LDR     R11, =ITCMCR
    LDR     R0, [R11]
    ORR     R0, R0, #0x7
    STR     R0, [R11]
    LDR     R11, =DTCMCR
    LDR     R0, [R11]
    ORR     R0, R0, #0x7
    STR     R0, [R11]

    
_STACK_start
/* 8bytes align */
    LDR     R1, =|Image$$STACK_start$$Base|
    LDR     R2, =|Image$$OS_HEAP_DTCM_start$$Base|
    
    SUBS    R2, R2, R1
    SUBS    R2, #1
    BLE     _STACK_end

    LDR     R0, =0x5A5A5A5A
    LDR     R3, =0x5A5A5A5A

_STACK_loop
    STM     R1!, {R0,R3}
    SUBS    R2, #8
    BGE      _STACK_loop
_STACK_end
    /* Initialize the stack pointer */
    ldr     r0,=__initial_sp
    mov     r13,r0

    /* RamInit 1 Stage, focus on copy data,clear bss, c code*/
    ldr     r0,=RamInit
    blx     r0

    /* Copy Vector Table for interrupt, c code */
#ifndef __NO_VECTOR_TABLE_COPY
    /* Call the to copy vector table from flash to ram */
    ldr     r0,=VectorTableCopy
    blx     r0
#endif
    /* SystemInit, user can init PLL to speed up left startup code, c code*/
#ifndef __NO_SYSTEM_INIT
    /* Call the system init routine */
    ldr     r0,=SystemInit
    blx     r0
#endif
    /* Unmask interrupts */
    cpsie   i               
	
    /* Call the main routine */
    LDR     R0, = __main
    BX      R0

JumpToSelf
    b       JumpToSelf
    
    ALIGN 4
    END