#include "string.h"
#include <stdbool.h>
#include "device_registers.h"
__attribute__((section (".relocation_initial_sp")))uint32_t __initial_sp;

extern int Image$$IVT_RAM_start$$Base;
#define ItcmStartAddress &Image$$IVT_RAM_start$$Base
extern int Image$$OS_HEAP_ITCM_end$$Limit;
#define ItcmEndAddress &Image$$OS_HEAP_ITCM_end$$Limit

extern int Image$$OS_HEAP_DTCM_start$$Base;
#define DtcmStartAddress &Image$$OS_HEAP_DTCM_start$$Base

extern int Image$$OS_HEAP_DTCM_end$$Limit;
#define DtcmEndAddress  &Image$$OS_HEAP_DTCM_end$$Limit

extern int Image$$Sram$$Base;
#define SramStartAddress  &Image$$Sram$$Base

extern int Image$$OS_HEAP_RAM_end$$Limit;
#define EndAddressOfNeedInitSram  &Image$$OS_HEAP_RAM_end$$Limit 

#define RCU_RSSR_POR_MASK   (0x1U)
static bool IsPOR(void)
{
    bool RetVal = false;
    /* Check if the MCU is power on reset or not */
    if (RCU_RSSR_POR_MASK == (RCU->RSSR & RCU_RSSR_POR_MASK))
    {
        RetVal = true;
    }

    return RetVal;
}

void RamInit(void)
{
  //ITCM DTCM RAM全部清0
	
	
	memset(ItcmStartAddress,0,(uint32_t)ItcmEndAddress - (uint32_t)ItcmStartAddress);
  memset(DtcmStartAddress,0,(uint32_t)DtcmEndAddress - (uint32_t)DtcmStartAddress);
  memset(SramStartAddress,0,(uint32_t)EndAddressOfNeedInitSram - (uint32_t)SramStartAddress);
	//Copy Code RAM
  //todo 看看 copy coderam是不是在__main函数做了
	
	//Copy 中断向量表到RAM  這個不用做，因VectorTableCopy已經做了

}
