#!armclang -E --target=arm-arm-none-eabi -mcpu=cortex-m7 -xc
#define __BootManagerImageStartAddress__ 0x2000000
#define __BootManagerImageMaxSize__  128*1024

#define __BootImageStartAddress__    __BootManagerImageStartAddress__ + __BootManagerImageMaxSize__ + 0x800	/*这0x800是给打包工具留的*/
#define __BootImageMaxSize__  256*1024 -0x800

#define __AppImageStartAddress__   __BootImageStartAddress__ + __BootImageMaxSize__ +0x800
#define __AppImageMaxSize__   (1024*1024) - __AppImageStartAddress__ - 0x800
#define __AppImageMaxEndAddress__  __AppImageStartAddress__ + __AppImageMaxSize__ 


#define __CodeFlashStartAddress__  0x2000000
#define __CodeFlashMaxSize__  1024*1024

#define __PFlashBvtSize__		0x800
#define __PFlashIvtSize__		0x400


BootManagerImage __BootManagerImageStartAddress__
{
	BootManagerImageStart __BootManagerImageStartAddress__ FIXED EMPTY 0
	{
	
	}
}

BootImage __BootImageStartAddress__
{
	BootImageStart __BootImageStartAddress__ FIXED EMPTY 0
	{
	
	}
}



LR_BVT_0 __CodeFlashStartAddress__
{

        AppImageStart +0 FIXED EMPTY 0
        {
        }
        bvt_header_region_start AlignExpr(+0,4) FIXED EMPTY 0
        {
        }
        bvt_header_region +0 
        {
                *(.bvt_header)
        }
        bvt_header_region_end +0  EMPTY 0
        {
        }
        sb_config_group_region_start AlignExpr(+0,4) FIXED EMPTY 0
        {
        }
        sb_config_group_region +0 
        {
                *(.sb_config_group)
        }
        sb_config_group_region_end +0  EMPTY 0
        {
        }
        sb_config_section_region_start AlignExpr(+0,16) FIXED EMPTY 0
        {
        }
        sb_config_section_region +0 
        {
                *(.sb_config_section)
        }
        sb_config_section_region_end +0  EMPTY 0
        {
        }
        sb_cmac_region_start AlignExpr(+0,16) FIXED EMPTY 0
        {
        }
        sb_cmac_region +0 
        {
                *(.sb_cmac)
        }
        sb_cmac_region_end +0  EMPTY 0
        {
        }
        BVT_end +0 EMPTY 0
        {
        }
}
ScatterAssert(ImageLength(LR_BVT_0) <= __PFlashBvtSize__)

LR_IVT_0 __CodeFlashStartAddress__ + __PFlashBvtSize__
{

        IVT_start +0 FIXED EMPTY 0
        {
        }
        isr_vector_region_start +0 FIXED EMPTY 0
        {
        }
        isr_vector_region +0 
        {
                *(.isr_vector)
        }
        isr_vector_region_end +0  EMPTY 0
        {
        }
        IVT_end +0 EMPTY 0
        {
        }
}
ScatterAssert(ImageLength(LR_IVT_0) <= __PFlashIvtSize__)


LR_TEXT_0 __CodeFlashStartAddress__ + __PFlashBvtSize__ +__PFlashIvtSize__
{

        TEXT_start  +0 FIXED EMPTY 0
        {
        }
        text_region_start +0 FIXED EMPTY 0
        {
        }
        text_region +0 
        {
                *(InRoot$$Sections)               ; 链接__main函数,该函数用于RW段数据的拷贝和ZI段数据的清零
				.ANY (+RO)                        ; 剩余的code、RO数据随意链接
        }
        text_region_end +0  EMPTY 0
        {
        }
       

        CODE_RAM_start AlignExpr(0x400,4)  EMPTY 0
        {
        }
        code_ram_region_start AlignExpr(+0,4)  EMPTY 0
        {
        }
        code_ram_region +0 
        {
                *(.code_ram)
        }
        code_ram_region_end +0  EMPTY 0
        {
        }
        CODE_RAM_end +0 EMPTY 0
        {
        }
}
ScatterAssert(ImageLength(LR_TEXT_0) <= (1024*1024 - (__PFlashBvtSize__ +__PFlashIvtSize__)))


LR_IVT_RAM_0 0
{

        IVT_RAM_start AlignExpr(+0,0x400)  EMPTY 0
        {
        }
        IVT_RAM AlignExpr(+0,0x400) EMPTY 0x400
        {
        }
        IVT_RAM_end +0 EMPTY 0
        {
        }
}
ScatterAssert(ImageLength(LR_IVT_RAM_0) <= 0x400)

LR_OS_HEAP_ITCM_0 0x2400
{

        OS_HEAP_ITCM_start +0  EMPTY 0
        {
        }
        OS_HEAP_ITCM_region_start +0  EMPTY 0
        {
        }
        OS_HEAP_ITCM_region +0 
        {

        }
        OS_HEAP_ITCM_region_end +0  EMPTY 0
        {
        }
        OS_HEAP_ITCM_end +0x5C00 EMPTY 0
        {
        }
}
ScatterAssert(ImageLength(LR_OS_HEAP_ITCM_0) <= 0x5C00)


LR_STACK_0 0x20000000
{

        STACK_start +0  EMPTY 0
        {
        }
        STACK_region_start AlignExpr(+0,0x2000) EMPTY 0
        {
		
        }
        STACK_end +0x2000
        {
		*(.relocation_initial_sp)
        }
}
ScatterAssert(ImageLength(LR_STACK_0) <= 0x2000)



LR_Os_HEAP_DTCM_0 0x20002000
{

        OS_HEAP_DTCM_start +0  EMPTY 0
        {
        }
        OS_HEAP_DTCM AlignExpr(+0,0x1E000)  EMPTY 0
        {
        }
        OS_HEAP_DTCM_end +0x1E000 EMPTY 0
        {
        }
}
ScatterAssert(ImageLength(LR_Os_HEAP_DTCM_0) <=0x1E000)




SRAM 0x20020000 0x60000
{
   Sram 0x20020000  0x3FF00
  {
	.ANY (+RW +ZI)                    ; 存放所有的RW段数据和ZI段数据
  }
  OS_HEAP_RAM_start +0 EMPTY 0
  {
  
  }
  OS_HEAP_RAM_end 0x2005FF00  EMPTY 0
  {
  
  }
  BOOT_APP_COM_RAM_start 0x2005FF00 EMPTY 0
  {
  
  }
}
  
  
